/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.metamodel;

import java.io.Serializable;
import java.lang.reflect.Member;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.Bindable;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.SingularAttribute;
import javax.persistence.metamodel.Type;
import org.hibernate.mapping.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingularAttributeImpl<X, Y>
implements SingularAttribute<X, Y>,
Serializable {
    private final boolean isId;
    private final boolean isVersion;
    private final boolean isOptional;
    private final ManagedType<X> ownerType;
    private final Type<Y> attrType;
    private final Member member;
    private final String name;
    private final Attribute.PersistentAttributeType persistentAttributeType;

    private SingularAttributeImpl(Builder<X, Y> builder) {
        this.ownerType = ((Builder)builder).type;
        this.attrType = ((Builder)builder).attributeType;
        this.isId = ((Builder)builder).isId;
        this.isVersion = ((Builder)builder).isVersion;
        Property property = ((Builder)builder).property;
        this.isOptional = property.isOptional();
        this.member = ((Builder)builder).member;
        this.name = property.getName();
        this.persistentAttributeType = ((Builder)builder).persistentAttributeType != null ? ((Builder)builder).persistentAttributeType : (property.isComposite() ? Attribute.PersistentAttributeType.EMBEDDED : Attribute.PersistentAttributeType.BASIC);
    }

    public static <X, Y> Builder<X, Y> create(ManagedType<X> ownerType, Type<Y> attrType) {
        return new Builder(ownerType, attrType);
    }

    public boolean isId() {
        return this.isId;
    }

    public boolean isVersion() {
        return this.isVersion;
    }

    public boolean isOptional() {
        return this.isOptional;
    }

    public Type<Y> getType() {
        return this.attrType;
    }

    public String getName() {
        return this.name;
    }

    public Attribute.PersistentAttributeType getPersistentAttributeType() {
        return this.persistentAttributeType;
    }

    public ManagedType<X> getDeclaringType() {
        return this.ownerType;
    }

    public Class<Y> getJavaType() {
        return this.attrType.getJavaType();
    }

    public Member getJavaMember() {
        return this.member;
    }

    public boolean isAssociation() {
        return false;
    }

    public boolean isCollection() {
        return false;
    }

    public Bindable.BindableType getBindableType() {
        return Bindable.BindableType.SINGULAR_ATTRIBUTE;
    }

    public Class<Y> getBindableJavaType() {
        return this.attrType.getJavaType();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder<X, Y> {
        private boolean isId;
        private boolean isVersion;
        private final Type<Y> attributeType;
        private final ManagedType<X> type;
        private Member member;
        private Attribute.PersistentAttributeType persistentAttributeType;
        private Property property;

        private Builder(ManagedType<X> ownerType, Type<Y> attrType) {
            this.type = ownerType;
            this.attributeType = attrType;
        }

        public Builder<X, Y> member(Member member) {
            this.member = member;
            return this;
        }

        public Builder<X, Y> property(Property property) {
            this.property = property;
            return this;
        }

        public Builder<X, Y> id() {
            this.isId = true;
            return this;
        }

        public Builder<X, Y> version() {
            this.isVersion = true;
            return this;
        }

        public SingularAttribute<X, Y> build() {
            return new SingularAttributeImpl(this);
        }

        public Builder<X, Y> persistentAttributeType(Attribute.PersistentAttributeType attrType) {
            this.persistentAttributeType = attrType;
            return this;
        }
    }
}

