/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.metamodel;

import java.io.Serializable;
import java.lang.reflect.Member;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.Bindable;
import javax.persistence.metamodel.CollectionAttribute;
import javax.persistence.metamodel.ListAttribute;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.MapAttribute;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.SetAttribute;
import javax.persistence.metamodel.Type;
import org.hibernate.mapping.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PluralAttributeImpl<X, C, E>
implements PluralAttribute<X, C, E>,
Serializable {
    private final ManagedType<X> ownerType;
    private final Type<E> elementType;
    private final Member member;
    private final String name;
    private final Attribute.PersistentAttributeType persistentAttributeType;
    private final Class<C> collectionClass;

    private PluralAttributeImpl(Builder<X, C, E, ?> builder) {
        this.ownerType = ((Builder)builder).type;
        this.elementType = ((Builder)builder).attributeType;
        this.collectionClass = ((Builder)builder).collectionClass;
        this.member = ((Builder)builder).member;
        this.name = ((Builder)builder).property.getName();
        this.persistentAttributeType = ((Builder)builder).persistentAttributeType;
    }

    public static <X, C, E, K> Builder<X, C, E, K> create(ManagedType<X> ownerType, Type<E> attrType, Class<C> collectionClass, Type<K> keyType) {
        return new Builder(ownerType, attrType, collectionClass, keyType);
    }

    public String getName() {
        return this.name;
    }

    public Attribute.PersistentAttributeType getPersistentAttributeType() {
        return this.persistentAttributeType;
    }

    public ManagedType<X> getDeclaringType() {
        return this.ownerType;
    }

    public Class<C> getJavaType() {
        return this.collectionClass;
    }

    public abstract PluralAttribute.CollectionType getCollectionType();

    public Type<E> getElementType() {
        return this.elementType;
    }

    public Member getJavaMember() {
        return this.member;
    }

    public boolean isAssociation() {
        return true;
    }

    public boolean isCollection() {
        return true;
    }

    public Bindable.BindableType getBindableType() {
        return Bindable.BindableType.PLURAL_ATTRIBUTE;
    }

    public Class<E> getBindableJavaType() {
        return this.elementType.getJavaType();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MapAttributeImpl<X, K, V>
    extends PluralAttributeImpl<X, Map<K, V>, V>
    implements MapAttribute<X, K, V> {
        private final Type<K> keyType;

        MapAttributeImpl(Builder<X, Map<K, V>, V, K> xceBuilder) {
            super(xceBuilder);
            this.keyType = ((Builder)xceBuilder).keyType;
        }

        @Override
        public PluralAttribute.CollectionType getCollectionType() {
            return PluralAttribute.CollectionType.MAP;
        }

        public Class<K> getKeyJavaType() {
            return this.keyType.getJavaType();
        }

        public Type<K> getKeyType() {
            return this.keyType;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ListAttributeImpl<X, E>
    extends PluralAttributeImpl<X, List<E>, E>
    implements ListAttribute<X, E> {
        ListAttributeImpl(Builder<X, List<E>, E, ?> xceBuilder) {
            super(xceBuilder);
        }

        @Override
        public PluralAttribute.CollectionType getCollectionType() {
            return PluralAttribute.CollectionType.LIST;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CollectionAttributeImpl<X, E>
    extends PluralAttributeImpl<X, Collection<E>, E>
    implements CollectionAttribute<X, E> {
        CollectionAttributeImpl(Builder<X, Collection<E>, E, ?> xceBuilder) {
            super(xceBuilder);
        }

        @Override
        public PluralAttribute.CollectionType getCollectionType() {
            return PluralAttribute.CollectionType.COLLECTION;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SetAttributeImpl<X, E>
    extends PluralAttributeImpl<X, Set<E>, E>
    implements SetAttribute<X, E> {
        SetAttributeImpl(Builder<X, Set<E>, E, ?> xceBuilder) {
            super(xceBuilder);
        }

        @Override
        public PluralAttribute.CollectionType getCollectionType() {
            return PluralAttribute.CollectionType.SET;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder<X, C, E, K> {
        private final Type<E> attributeType;
        private final ManagedType<X> type;
        private Member member;
        private Attribute.PersistentAttributeType persistentAttributeType;
        private Property property;
        private Class<C> collectionClass;
        private Type<K> keyType;

        private Builder(ManagedType<X> ownerType, Type<E> attrType, Class<C> collectionClass, Type<K> keyType) {
            this.type = ownerType;
            this.attributeType = attrType;
            this.collectionClass = collectionClass;
            this.keyType = keyType;
        }

        public Builder<X, C, E, K> member(Member member) {
            this.member = member;
            return this;
        }

        public Builder<X, C, E, K> property(Property property) {
            this.property = property;
            return this;
        }

        public Builder<X, C, E, K> persistentAttributeType(Attribute.PersistentAttributeType attrType) {
            this.persistentAttributeType = attrType;
            return this;
        }

        public <K> PluralAttributeImpl<X, C, E> build() {
            if (Map.class.isAssignableFrom(this.collectionClass)) {
                Builder builder = this;
                MapAttributeImpl result = new MapAttributeImpl(builder);
                return result;
            }
            if (Set.class.isAssignableFrom(this.collectionClass)) {
                Builder builder = this;
                SetAttributeImpl result = new SetAttributeImpl(builder);
                return result;
            }
            if (List.class.isAssignableFrom(this.collectionClass)) {
                Builder builder = this;
                ListAttributeImpl result = new ListAttributeImpl(builder);
                return result;
            }
            if (Collection.class.isAssignableFrom(this.collectionClass)) {
                Builder builder = this;
                CollectionAttributeImpl result = new CollectionAttributeImpl(builder);
                return result;
            }
            throw new UnsupportedOperationException("Unkown collection: " + this.collectionClass);
        }
    }
}

