/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.metamodel;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.persistence.metamodel.EmbeddableType;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.Metamodel;
import org.hibernate.ejb.metamodel.EntityTypeImpl;
import org.hibernate.ejb.metamodel.MetadataContext;
import org.hibernate.mapping.PersistentClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetamodelImpl
implements Metamodel,
Serializable {
    private final Map<Class<?>, EntityType<?>> entities;
    private Map<Class<?>, EmbeddableType<?>> embeddables;

    public MetamodelImpl(Iterator<PersistentClass> classes) {
        HashMap localEntities = new HashMap();
        MetadataContext context = new MetadataContext();
        while (classes.hasNext()) {
            this.buildEntityType(classes, localEntities, context);
        }
        this.entities = Collections.unmodifiableMap(localEntities);
        this.embeddables = Collections.unmodifiableMap(context.getEmbeddableTypes());
        context.postProcess(this);
    }

    private <X> void buildEntityType(Iterator<PersistentClass> classes, Map<Class<?>, EntityType<?>> localEntities, MetadataContext context) {
        PersistentClass persistentClass = classes.next();
        Class clazz = persistentClass.getMappedClass();
        if (clazz != null) {
            localEntities.put(clazz, new EntityTypeImpl(clazz, persistentClass, context));
        }
    }

    public <X> EntityType<X> entity(Class<X> cls) {
        EntityType<?> entityType = this.entities.get(cls);
        if (entityType == null) {
            throw new IllegalArgumentException("Not an entity: " + cls);
        }
        return entityType;
    }

    public <X> ManagedType<X> type(Class<X> cls) {
        ManagedType type = null;
        type = (ManagedType)this.entities.get(cls);
        if (type == null) {
            throw new IllegalArgumentException("Not an managed type: " + cls);
        }
        return type;
    }

    public <X> EmbeddableType<X> embeddable(Class<X> cls) {
        EmbeddableType<?> embeddableType = this.embeddables.get(cls);
        if (embeddableType == null) {
            throw new IllegalArgumentException("Not an entity: " + cls);
        }
        return embeddableType;
    }

    public Set<ManagedType<?>> getManagedTypes() {
        HashSet managedTypes = new HashSet(this.entities.size() + this.embeddables.size());
        managedTypes.addAll(this.entities.values());
        managedTypes.addAll(this.embeddables.values());
        return managedTypes;
    }

    public Set<EntityType<?>> getEntities() {
        return new HashSet(this.entities.values());
    }

    public Set<EmbeddableType<?>> getEmbeddables() {
        return new HashSet(this.embeddables.values());
    }
}

