/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.metamodel;

import java.util.Iterator;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.Type;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.ejb.metamodel.BasicTypeImpl;
import org.hibernate.ejb.metamodel.EmbeddableTypeImpl;
import org.hibernate.ejb.metamodel.EntityTypeDelegator;
import org.hibernate.ejb.metamodel.MetadataContext;
import org.hibernate.ejb.metamodel.PluralAttributeImpl;
import org.hibernate.ejb.metamodel.SingularAttributeImpl;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Map;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MetamodelFactory {
    MetamodelFactory() {
    }

    static <X, Y, V, K> Attribute<X, Y> getAttribute(ManagedType<X> ownerType, Property property, MetadataContext metadataContext) {
        return MetamodelFactory.getAttribute(ownerType, property, metadataContext, false);
    }

    static <X, Y, V, K> Attribute<X, Y> getAttribute(ManagedType<X> ownerType, Property property, MetadataContext metadataContext, boolean isId) {
        Object attribute;
        AttributeContext attrContext = MetamodelFactory.getAttributeContext(property);
        if (attrContext.isCollection()) {
            Type<X> attrType = MetamodelFactory.getType(attrContext.getElementTypeStatus(), attrContext.getElementValue(), metadataContext);
            Class<?> collectionClass = attrContext.getCollectionClass();
            if (java.util.Map.class.isAssignableFrom(collectionClass)) {
                Type<X> keyType = MetamodelFactory.getType(attrContext.getKeyTypeStatus(), attrContext.getKeyValue(), metadataContext);
                attribute = PluralAttributeImpl.create(ownerType, attrType, collectionClass, keyType).property(property).persistentAttributeType(attrContext.getElementAttributeType()).build();
            } else {
                attribute = PluralAttributeImpl.create(ownerType, attrType, collectionClass, null).property(property).persistentAttributeType(attrContext.getElementAttributeType()).build();
            }
        } else {
            Type<X> attrType = MetamodelFactory.getType(attrContext.getElementTypeStatus(), attrContext.getElementValue(), metadataContext);
            SingularAttributeImpl.Builder<X, X> xyBuilder = SingularAttributeImpl.create(ownerType, attrType).property(property).persistentAttributeType(attrContext.getElementAttributeType());
            if (isId) {
                xyBuilder.id();
            }
            attribute = xyBuilder.build();
        }
        return attribute;
    }

    private static <X> Type<X> getType(AttributeContext.TypeStatus elementTypeStatus, Value value, MetadataContext metadataContext) {
        org.hibernate.type.Type type = value.getType();
        switch (elementTypeStatus) {
            case BASIC: {
                return MetamodelFactory.buildBasicType(type);
            }
            case EMBEDDABLE: {
                return MetamodelFactory.buildEmbeddableType(value, type, metadataContext);
            }
            case ENTITY: {
                return MetamodelFactory.buildEntityType(type, metadataContext);
            }
        }
        throw new AssertionFailure("Unknown AttributeContext.TypeStatus: " + (Object)((Object)elementTypeStatus));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static AttributeContext getAttributeContext(Property property) {
        Value value = property.getValue();
        org.hibernate.type.Type type = value.getType();
        if (type.isAnyType()) {
            throw new UnsupportedOperationException("any not supported yet");
        }
        if (type.isAssociationType()) {
            if (!type.isCollectionType()) return new AttributeContext(value, AttributeContext.TypeStatus.ENTITY, Attribute.PersistentAttributeType.MANY_TO_MANY, null, null, null);
            if (value instanceof Collection) {
                Attribute.PersistentAttributeType elementPAT;
                AttributeContext.TypeStatus elementTypeStatus;
                AttributeContext.TypeStatus keyTypeStatus;
                Value keyValue;
                Collection collValue = (Collection)value;
                Value elementValue = collValue.getElement();
                org.hibernate.type.Type elementType = elementValue.getType();
                Class collectionClass = collValue.getCollectionType().getReturnedClass();
                if (value instanceof Map) {
                    keyValue = ((Map)value).getIndex();
                    org.hibernate.type.Type keyType = keyValue.getType();
                    if (keyValue instanceof Component) {
                        keyTypeStatus = AttributeContext.TypeStatus.EMBEDDABLE;
                    } else {
                        if (keyType.isAnyType()) {
                            throw new UnsupportedOperationException("collection of any not supported yet");
                        }
                        keyTypeStatus = keyType.isAssociationType() ? AttributeContext.TypeStatus.ENTITY : AttributeContext.TypeStatus.BASIC;
                    }
                } else {
                    keyValue = null;
                    keyTypeStatus = null;
                }
                if (elementValue instanceof Component) {
                    elementTypeStatus = AttributeContext.TypeStatus.EMBEDDABLE;
                    elementPAT = Attribute.PersistentAttributeType.ELEMENT_COLLECTION;
                    return new AttributeContext(elementValue, elementTypeStatus, elementPAT, collectionClass, keyValue, keyTypeStatus);
                } else {
                    if (elementType.isAnyType()) {
                        throw new UnsupportedOperationException("collection of any not supported yet");
                    }
                    if (elementType.isAssociationType()) {
                        elementTypeStatus = AttributeContext.TypeStatus.ENTITY;
                        elementPAT = Attribute.PersistentAttributeType.MANY_TO_MANY;
                        return new AttributeContext(elementValue, elementTypeStatus, elementPAT, collectionClass, keyValue, keyTypeStatus);
                    } else {
                        elementTypeStatus = AttributeContext.TypeStatus.BASIC;
                        elementPAT = Attribute.PersistentAttributeType.ELEMENT_COLLECTION;
                    }
                }
                return new AttributeContext(elementValue, elementTypeStatus, elementPAT, collectionClass, keyValue, keyTypeStatus);
            }
            if (!(value instanceof OneToMany)) throw new UnsupportedOperationException("oops, we are missing something: " + property.toString());
            return new AttributeContext(value, AttributeContext.TypeStatus.ENTITY, Attribute.PersistentAttributeType.ONE_TO_MANY, null, null, null);
        }
        if (!property.isComposite()) return new AttributeContext(value, AttributeContext.TypeStatus.BASIC, Attribute.PersistentAttributeType.BASIC, null, null, null);
        return new AttributeContext(value, AttributeContext.TypeStatus.EMBEDDABLE, Attribute.PersistentAttributeType.EMBEDDED, null, null, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    static <X> Type<X> getType(Property property, MetadataContext context) {
        Value value = property.getValue();
        org.hibernate.type.Type type = value.getType();
        if (type.isAnyType()) {
            throw new UnsupportedOperationException("any not supported yet");
        }
        if (!type.isAssociationType()) {
            if (!property.isComposite()) return MetamodelFactory.buildBasicType(type);
            return MetamodelFactory.buildEmbeddableType(value, type, context);
        }
        if (!type.isCollectionType()) return MetamodelFactory.buildEntityType(type, context);
        if (!(value instanceof Collection)) {
            if (!(value instanceof OneToMany)) throw new UnsupportedOperationException("oops, we are missing something: " + property.toString());
            return MetamodelFactory.buildEntityType(value.getType(), context);
        }
        Collection collValue = (Collection)value;
        collValue.getCollectionType();
        Value elementValue = collValue.getElement();
        org.hibernate.type.Type elementType = elementValue.getType();
        if (elementValue instanceof Component) {
            return MetamodelFactory.buildEmbeddableType(elementValue, elementType, context);
        }
        if (elementType.isAnyType()) {
            throw new UnsupportedOperationException("collection of any not supported yet");
        }
        if (elementType.isAssociationType()) {
            return MetamodelFactory.buildEntityType(elementType, context);
        }
        MetamodelFactory.buildBasicType(elementType);
        throw new UnsupportedOperationException("oops, we are missing something: " + property.toString());
    }

    private static <X> Type<X> buildBasicType(org.hibernate.type.Type type) {
        Class clazz = type.getReturnedClass();
        return new BasicTypeImpl(clazz, Type.PersistenceType.BASIC);
    }

    private static <X> Type<X> buildEntityType(org.hibernate.type.Type type, MetadataContext context) {
        Class clazz = type.getReturnedClass();
        EntityTypeDelegator entityTypeDelegator = new EntityTypeDelegator();
        context.addDelegator(entityTypeDelegator, clazz);
        return entityTypeDelegator;
    }

    private static <X> Type<X> buildEmbeddableType(Value value, org.hibernate.type.Type type, MetadataContext context) {
        Class clazz = type.getReturnedClass();
        Component component = (Component)value;
        Iterator subProperties = component.getPropertyIterator();
        EmbeddableTypeImpl embeddableType = new EmbeddableTypeImpl(clazz, subProperties, context);
        context.addEmbeddableType(clazz, embeddableType);
        return embeddableType;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AttributeContext {
        private final Value elementValue;
        private final TypeStatus typeStatus;
        private final Class<?> collectionClass;
        private final Attribute.PersistentAttributeType attrType;
        private final Value keyValue;
        private final TypeStatus keyTypeStatus;

        AttributeContext(Value elementValue, TypeStatus elementTypeStatus, Attribute.PersistentAttributeType elementPAT, Class<?> collectionClass, Value keyValue, TypeStatus keyTypeStatus) {
            this.elementValue = elementValue;
            this.typeStatus = elementTypeStatus;
            this.collectionClass = collectionClass;
            this.attrType = elementPAT;
            this.keyValue = keyValue;
            this.keyTypeStatus = keyTypeStatus;
        }

        public Value getElementValue() {
            return this.elementValue;
        }

        public TypeStatus getElementTypeStatus() {
            return this.typeStatus;
        }

        public boolean isCollection() {
            return this.collectionClass != null;
        }

        public Class<?> getCollectionClass() {
            return this.collectionClass;
        }

        public Attribute.PersistentAttributeType getElementAttributeType() {
            return this.attrType;
        }

        public Value getKeyValue() {
            return this.keyValue;
        }

        public TypeStatus getKeyTypeStatus() {
            return this.keyTypeStatus;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum TypeStatus {
            EMBEDDABLE,
            ENTITY,
            BASIC;

        }
    }
}

