/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.metamodel;

import java.util.HashMap;
import java.util.Map;
import javax.persistence.metamodel.EmbeddableType;
import javax.persistence.metamodel.Metamodel;
import org.hibernate.ejb.metamodel.EntityTypeDelegator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MetadataContext {
    private Map<EntityTypeDelegator<?>, Class<?>> delegators = new HashMap();
    private Map<Class<?>, EmbeddableType<?>> embeddables = new HashMap();

    MetadataContext() {
    }

    void addDelegator(EntityTypeDelegator<?> type, Class<?> clazz) {
        this.delegators.put(type, clazz);
    }

    void postProcess(Metamodel model) {
        for (Map.Entry<EntityTypeDelegator<?>, Class<?>> entry : this.delegators.entrySet()) {
            this.setDelegate(model, entry);
        }
    }

    private <X> void setDelegate(Metamodel model, Map.Entry<EntityTypeDelegator<?>, Class<?>> entry) {
        Class<?> entityClass = entry.getValue();
        EntityTypeDelegator<?> delegator = entry.getKey();
        delegator.setDelegate(model.entity(entityClass));
    }

    <X> void addEmbeddableType(Class<X> clazz, EmbeddableType<X> embeddableType) {
        this.embeddables.put(clazz, embeddableType);
    }

    Map<Class<?>, EmbeddableType<?>> getEmbeddableTypes() {
        return this.embeddables;
    }
}

