/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.metamodel;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.Bindable;
import javax.persistence.metamodel.CollectionAttribute;
import javax.persistence.metamodel.ListAttribute;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.MapAttribute;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.SetAttribute;
import javax.persistence.metamodel.SingularAttribute;
import javax.persistence.metamodel.Type;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.ejb.metamodel.MetadataContext;
import org.hibernate.ejb.metamodel.MetamodelFactory;
import org.hibernate.mapping.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ManagedTypeImpl<X>
implements ManagedType<X>,
Serializable {
    private final Class<X> javaClass;
    private final Map<String, Attribute<X, ?>> declaredAttributes;
    private final Map<String, SingularAttribute<X, ?>> declaredSingularAttributes;
    private final Map<String, PluralAttribute<X, ?, ?>> declaredCollections;

    ManagedTypeImpl(Class<X> clazz, Iterator<Property> properties, MetadataContext context) {
        this.javaClass = clazz;
        HashMap localDeclAttr = new HashMap();
        HashMap localDeclSingAttr = new HashMap();
        HashMap localDeclPlurAttr = new HashMap();
        while (properties.hasNext()) {
            Property property = properties.next();
            this.addProperty(property, context, localDeclAttr, localDeclSingAttr, localDeclPlurAttr);
        }
        this.declaredAttributes = Collections.unmodifiableMap(localDeclAttr);
        this.declaredSingularAttributes = Collections.unmodifiableMap(localDeclSingAttr);
        this.declaredCollections = Collections.unmodifiableMap(localDeclPlurAttr);
    }

    private <T> void addProperty(Property property, MetadataContext context, Map<String, Attribute<X, ?>> localDeclAttr, Map<String, SingularAttribute<X, ?>> localDeclSingAttr, Map<String, PluralAttribute<X, ?, ?>> localDeclPlurAttr) {
        Attribute attribute = MetamodelFactory.getAttribute(this, property, context);
        localDeclAttr.put(attribute.getName(), attribute);
        Bindable.BindableType bindableType = ((Bindable)attribute).getBindableType();
        switch (bindableType) {
            case SINGULAR_ATTRIBUTE: {
                localDeclSingAttr.put(attribute.getName(), (SingularAttribute)attribute);
                break;
            }
            case PLURAL_ATTRIBUTE: {
                localDeclPlurAttr.put(attribute.getName(), (PluralAttribute)attribute);
                break;
            }
            default: {
                throw new AssertionFailure("unknown bindable type: " + bindableType);
            }
        }
    }

    public Set<Attribute<? super X, ?>> getAttributes() {
        return null;
    }

    public Set<Attribute<X, ?>> getDeclaredAttributes() {
        return new HashSet(this.declaredAttributes.values());
    }

    public <Y> SingularAttribute<? super X, Y> getSingularAttribute(String name, Class<Y> type) {
        return null;
    }

    public <Y> SingularAttribute<X, Y> getDeclaredSingularAttribute(String name, Class<Y> type) {
        SingularAttribute<X, ?> attr = this.declaredSingularAttributes.get(name);
        this.checkTypeForSingleAttribute("SingularAttribute ", attr, name, type);
        SingularAttribute<X, ?> result = attr;
        return result;
    }

    private <Y> void checkTypeForSingleAttribute(String error, SingularAttribute<?, ?> attr, String name, Class<Y> type) {
        if (attr == null || type != null && !attr.getBindableJavaType().equals(type)) {
            throw new IllegalArgumentException(error + " named " + name + (type != null ? " and of type " + type : "") + " is not present");
        }
    }

    private <Y> void checkTypeForPluralAttributes(String error, PluralAttribute<?, ?, ?> attr, String name, Class<Y> type, PluralAttribute.CollectionType collectionType) {
        if (attr == null || type != null && !attr.getBindableJavaType().equals(type) || attr.getCollectionType() != collectionType) {
            throw new IllegalArgumentException(error + " named " + name + (type != null ? " and of element type " + type : "") + " is not present");
        }
    }

    private <Y> void checkNotNull(String error, Attribute<?, ?> attr, String name) {
        if (attr == null) {
            throw new IllegalArgumentException(error + " named " + name + " is not present");
        }
    }

    public Set<SingularAttribute<? super X, ?>> getSingularAttributes() {
        return null;
    }

    public Set<SingularAttribute<X, ?>> getDeclaredSingularAttributes() {
        return new HashSet(this.declaredSingularAttributes.values());
    }

    public <E> CollectionAttribute<? super X, E> getCollection(String name, Class<E> elementType) {
        return null;
    }

    public <E> SetAttribute<? super X, E> getSet(String name, Class<E> elementType) {
        return null;
    }

    public <E> ListAttribute<? super X, E> getList(String name, Class<E> elementType) {
        return null;
    }

    public <K, V> MapAttribute<? super X, K, V> getMap(String name, Class<K> keyType, Class<V> valueType) {
        return null;
    }

    public <E> CollectionAttribute<X, E> getDeclaredCollection(String name, Class<E> elementType) {
        PluralAttribute<X, ?, ?> attr = this.declaredCollections.get(name);
        this.checkTypeForPluralAttributes("CollectionAttribute ", attr, name, elementType, PluralAttribute.CollectionType.COLLECTION);
        CollectionAttribute result = (CollectionAttribute)attr;
        return result;
    }

    public <E> SetAttribute<X, E> getDeclaredSet(String name, Class<E> elementType) {
        PluralAttribute<X, ?, ?> attr = this.declaredCollections.get(name);
        this.checkTypeForPluralAttributes("SetAttribute ", attr, name, elementType, PluralAttribute.CollectionType.SET);
        SetAttribute result = (SetAttribute)attr;
        return result;
    }

    public <E> ListAttribute<X, E> getDeclaredList(String name, Class<E> elementType) {
        PluralAttribute<X, ?, ?> attr = this.declaredCollections.get(name);
        this.checkTypeForPluralAttributes("ListAttribute ", attr, name, elementType, PluralAttribute.CollectionType.LIST);
        ListAttribute result = (ListAttribute)attr;
        return result;
    }

    public <K, V> MapAttribute<X, K, V> getDeclaredMap(String name, Class<K> keyType, Class<V> valueType) {
        PluralAttribute<X, ?, ?> attr = this.declaredCollections.get(name);
        String error = "MapAttribute ";
        this.checkTypeForPluralAttributes("MapAttribute ", attr, name, valueType, PluralAttribute.CollectionType.MAP);
        MapAttribute result = (MapAttribute)attr;
        if (result.getKeyJavaType() != keyType) {
            throw new IllegalArgumentException("MapAttribute  named " + name + " does not support a key of type " + keyType);
        }
        return result;
    }

    public Set<PluralAttribute<? super X, ?, ?>> getCollections() {
        return null;
    }

    public Set<PluralAttribute<X, ?, ?>> getDeclaredCollections() {
        return new HashSet(this.declaredCollections.values());
    }

    public Attribute<? super X, ?> getAttribute(String name) {
        return null;
    }

    public Attribute<X, ?> getDeclaredAttribute(String name) {
        Attribute attr = (Attribute)this.declaredSingularAttributes.get(name);
        this.checkNotNull("Attribute ", attr, name);
        return attr;
    }

    public SingularAttribute<? super X, ?> getSingularAttribute(String name) {
        return null;
    }

    public SingularAttribute<X, ?> getDeclaredSingularAttribute(String name) {
        SingularAttribute<X, ?> attr = this.declaredSingularAttributes.get(name);
        this.checkNotNull("SingularAttribute ", (Attribute<?, ?>)attr, name);
        return attr;
    }

    public CollectionAttribute<? super X, ?> getCollection(String name) {
        return null;
    }

    public SetAttribute<? super X, ?> getSet(String name) {
        return null;
    }

    public ListAttribute<? super X, ?> getList(String name) {
        return null;
    }

    public MapAttribute<? super X, ?, ?> getMap(String name) {
        return null;
    }

    public CollectionAttribute<X, ?> getDeclaredCollection(String name) {
        PluralAttribute<X, ?, ?> attr = this.declaredCollections.get(name);
        String error = "CollectionAttribute ";
        this.checkNotNull("CollectionAttribute ", (Attribute<?, ?>)attr, name);
        if (!CollectionAttribute.class.isAssignableFrom(attr.getClass())) {
            throw new IllegalArgumentException(name + " is not a " + "CollectionAttribute " + ": " + attr.getClass());
        }
        CollectionAttribute result = (CollectionAttribute)attr;
        return result;
    }

    public SetAttribute<X, ?> getDeclaredSet(String name) {
        PluralAttribute<X, ?, ?> attr = this.declaredCollections.get(name);
        String error = "SetAttribute ";
        this.checkNotNull("SetAttribute ", (Attribute<?, ?>)attr, name);
        if (!CollectionAttribute.class.isAssignableFrom(attr.getClass())) {
            throw new IllegalArgumentException(name + " is not a " + "SetAttribute " + ": " + attr.getClass());
        }
        SetAttribute result = (SetAttribute)attr;
        return result;
    }

    public ListAttribute<X, ?> getDeclaredList(String name) {
        PluralAttribute<X, ?, ?> attr = this.declaredCollections.get(name);
        String error = "ListAttribute ";
        this.checkNotNull("ListAttribute ", (Attribute<?, ?>)attr, name);
        if (!CollectionAttribute.class.isAssignableFrom(attr.getClass())) {
            throw new IllegalArgumentException(name + " is not a " + "ListAttribute " + ": " + attr.getClass());
        }
        ListAttribute result = (ListAttribute)attr;
        return result;
    }

    public MapAttribute<X, ?, ?> getDeclaredMap(String name) {
        PluralAttribute<X, ?, ?> attr = this.declaredCollections.get(name);
        String error = "MapAttribute ";
        this.checkNotNull("MapAttribute ", (Attribute<?, ?>)attr, name);
        if (!MapAttribute.class.isAssignableFrom(attr.getClass())) {
            throw new IllegalArgumentException(name + " is not a " + "MapAttribute " + ": " + attr.getClass());
        }
        MapAttribute result = (MapAttribute)attr;
        return result;
    }

    public abstract Type.PersistenceType getPersistenceType();

    public Class<X> getJavaType() {
        return this.javaClass;
    }
}

