/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.metamodel;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.persistence.metamodel.Bindable;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.IdentifiableType;
import javax.persistence.metamodel.SingularAttribute;
import javax.persistence.metamodel.Type;
import org.hibernate.ejb.metamodel.BasicTypeImpl;
import org.hibernate.ejb.metamodel.EntityTypeDelegator;
import org.hibernate.ejb.metamodel.ManagedTypeImpl;
import org.hibernate.ejb.metamodel.MetadataContext;
import org.hibernate.ejb.metamodel.MetamodelFactory;
import org.hibernate.ejb.metamodel.SingularAttributeImpl;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityTypeImpl<X>
extends ManagedTypeImpl<X>
implements EntityType<X>,
Serializable {
    private final SingularAttribute<X, ?> id;
    private final SingularAttribute<X, ?> version;
    private final String className;
    private final boolean hasIdentifierProperty;
    private final boolean isVersioned;
    private final Set<SingularAttribute<? super X, ?>> idClassAttributes;
    private final IdentifiableType<? super X> supertype;

    public EntityTypeImpl(Class<X> clazz, PersistentClass persistentClass, MetadataContext context) {
        super(clazz, persistentClass.getPropertyIterator(), context);
        this.className = persistentClass.getClassName();
        this.hasIdentifierProperty = persistentClass.hasIdentifierProperty();
        this.isVersioned = persistentClass.isVersioned();
        this.id = this.buildIdAttribute(persistentClass);
        this.version = this.buildVersionAttribute(persistentClass);
        Set<SingularAttribute<X, ?>> attributes = this.buildIdClassAttributes(persistentClass, context);
        this.idClassAttributes = attributes != null ? Collections.unmodifiableSet(attributes) : null;
        PersistentClass superPersistentClass = persistentClass.getSuperclass();
        if (superPersistentClass == null) {
            this.supertype = null;
        } else {
            Class superclass = superPersistentClass.getMappedClass();
            EntityTypeDelegator entityTypeDelegator = new EntityTypeDelegator();
            context.addDelegator(entityTypeDelegator, superclass);
            this.supertype = entityTypeDelegator;
        }
    }

    private <A> SingularAttribute<X, A> buildIdAttribute(PersistentClass persistentClass) {
        if (this.hasIdentifierProperty) {
            Property identifierProperty = persistentClass.getIdentifierProperty();
            Class idClass = identifierProperty.getType().getReturnedClass();
            BasicTypeImpl attrType = new BasicTypeImpl(idClass, identifierProperty.isComposite() ? Type.PersistenceType.EMBEDDABLE : Type.PersistenceType.BASIC);
            return SingularAttributeImpl.create(this, attrType).property(identifierProperty).id().build();
        }
        return null;
    }

    private <A> SingularAttribute<X, A> buildVersionAttribute(PersistentClass persistentClass) {
        if (persistentClass.isVersioned()) {
            Class versionClass = persistentClass.getVersion().getType().getReturnedClass();
            Property property = persistentClass.getVersion();
            BasicTypeImpl attrType = new BasicTypeImpl(versionClass, Type.PersistenceType.BASIC);
            return SingularAttributeImpl.create(this, attrType).property(property).version().build();
        }
        return null;
    }

    private Set<SingularAttribute<? super X, ?>> buildIdClassAttributes(PersistentClass persistentClass, MetadataContext context) {
        if (this.hasSingleIdAttribute()) {
            return null;
        }
        Iterator properties = persistentClass.getIdentifierMapper().getPropertyIterator();
        HashSet attributes = new HashSet();
        while (properties.hasNext()) {
            attributes.add((SingularAttribute)MetamodelFactory.getAttribute(this, (Property)properties.next(), context, true));
        }
        return attributes;
    }

    public String getName() {
        return this.className;
    }

    public <Y> SingularAttribute<? super X, Y> getId(Class<Y> type) {
        this.checkId();
        SingularAttribute<X, ?> result = this.id;
        return result;
    }

    private void checkId() {
        if (!this.hasSingleIdAttribute()) {
            throw new IllegalArgumentException("This is an @IdClass");
        }
    }

    public <Y> SingularAttribute<? super X, Y> getVersion(Class<Y> type) {
        SingularAttribute<X, ?> result = this.version;
        return result;
    }

    public <Y> SingularAttribute<X, Y> getDeclaredId(Class<Y> type) {
        this.checkId();
        SingularAttribute<X, ?> result = this.id;
        return result;
    }

    public <Y> SingularAttribute<X, Y> getDeclaredVersion(Class<Y> type) {
        SingularAttribute<X, ?> result = this.version;
        return result;
    }

    public IdentifiableType<? super X> getSupertype() {
        return this.supertype;
    }

    public boolean hasSingleIdAttribute() {
        return this.hasIdentifierProperty;
    }

    public boolean hasVersionAttribute() {
        return this.isVersioned;
    }

    public Set<SingularAttribute<? super X, ?>> getIdClassAttributes() {
        if (this.hasSingleIdAttribute()) {
            throw new IllegalArgumentException("This class does not use @IdClass: " + this.getName());
        }
        return this.idClassAttributes;
    }

    public Type<?> getIdType() {
        this.checkId();
        return this.id.getType();
    }

    public Bindable.BindableType getBindableType() {
        return Bindable.BindableType.ENTITY_TYPE;
    }

    public Class<X> getBindableJavaType() {
        return this.getJavaType();
    }

    @Override
    public Type.PersistenceType getPersistenceType() {
        return Type.PersistenceType.ENTITY;
    }
}

