/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.criteria.predicate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.QueryBuilder;
import org.hibernate.ejb.criteria.ParameterContainer;
import org.hibernate.ejb.criteria.ParameterRegistry;
import org.hibernate.ejb.criteria.QueryBuilderImpl;
import org.hibernate.ejb.criteria.expression.LiteralExpression;
import org.hibernate.ejb.criteria.predicate.AbstractSimplePredicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InPredicate<T>
extends AbstractSimplePredicate
implements QueryBuilder.In<T> {
    private final Expression<? extends T> expression;
    private final List<Expression<? extends T>> values;

    public InPredicate(QueryBuilderImpl queryBuilder, Expression<? extends T> expression) {
        this(queryBuilder, expression, (List<Expression<? extends T>>)new ArrayList<Expression<? extends T>>());
    }

    public InPredicate(QueryBuilderImpl queryBuilder, Expression<? extends T> expression, Expression<? extends T> ... values) {
        this(queryBuilder, expression, Arrays.asList(values));
    }

    public InPredicate(QueryBuilderImpl queryBuilder, Expression<? extends T> expression, List<Expression<? extends T>> values) {
        super(queryBuilder);
        this.expression = expression;
        this.values = values;
    }

    public InPredicate(QueryBuilderImpl queryBuilder, Expression<? extends T> expression, T ... values) {
        this(queryBuilder, expression, (Collection<? extends T>)Arrays.asList(values));
    }

    public InPredicate(QueryBuilderImpl queryBuilder, Expression<? extends T> expression, Collection<T> values) {
        super(queryBuilder);
        this.expression = expression;
        this.values = new ArrayList<Expression<? extends T>>();
        for (T value : values) {
            this.values.add(new LiteralExpression<T>(queryBuilder, value));
        }
    }

    public Expression<T> getExpression() {
        return this.expression;
    }

    public Expression<? extends T> getExpressionInternal() {
        return this.expression;
    }

    public List<Expression<? extends T>> getValues() {
        return this.values;
    }

    public InPredicate<T> value(T value) {
        return this.value(new LiteralExpression<T>(this.queryBuilder(), value));
    }

    public InPredicate<T> value(Expression<? extends T> value) {
        this.values.add(value);
        return this;
    }

    @Override
    public void registerParameters(ParameterRegistry registry) {
        ParameterContainer.Helper.possibleParameter(this.getExpressionInternal(), registry);
        for (Expression<T> value : this.getValues()) {
            ParameterContainer.Helper.possibleParameter(value, registry);
        }
    }
}

