/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.criteria.predicate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.hibernate.ejb.criteria.ParameterContainer;
import org.hibernate.ejb.criteria.ParameterRegistry;
import org.hibernate.ejb.criteria.QueryBuilderImpl;
import org.hibernate.ejb.criteria.predicate.AbstractPredicateImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompoundPredicate
extends AbstractPredicateImpl {
    private final Predicate.BooleanOperator operator;
    private final List<Expression<Boolean>> expressions = new ArrayList<Expression<Boolean>>();

    public CompoundPredicate(QueryBuilderImpl queryBuilder, Predicate.BooleanOperator operator) {
        super(queryBuilder);
        this.operator = operator;
    }

    public CompoundPredicate(QueryBuilderImpl queryBuilder, Predicate.BooleanOperator operator, Expression<Boolean> ... expressions) {
        this(queryBuilder, operator);
        this.applyExpressions(expressions);
    }

    public CompoundPredicate(QueryBuilderImpl queryBuilder, Predicate.BooleanOperator operator, List<Expression<Boolean>> expressions) {
        this(queryBuilder, operator);
        this.applyExpressions(expressions);
    }

    private void applyExpressions(Expression<Boolean> ... expressions) {
        this.applyExpressions(Arrays.asList(expressions));
    }

    private void applyExpressions(List<Expression<Boolean>> expressions) {
        this.expressions.clear();
        this.expressions.addAll(expressions);
    }

    public Predicate.BooleanOperator getOperator() {
        return this.operator;
    }

    public List<Expression<Boolean>> getExpressions() {
        return this.expressions;
    }

    @Override
    public void registerParameters(ParameterRegistry registry) {
        for (Expression<Boolean> expression : this.getExpressions()) {
            ParameterContainer.Helper.possibleParameter(expression, registry);
        }
    }
}

