/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.criteria.expression.function;

import javax.persistence.criteria.Expression;
import javax.persistence.criteria.QueryBuilder;
import org.hibernate.ejb.criteria.ParameterContainer;
import org.hibernate.ejb.criteria.ParameterRegistry;
import org.hibernate.ejb.criteria.QueryBuilderImpl;
import org.hibernate.ejb.criteria.expression.LiteralExpression;
import org.hibernate.ejb.criteria.expression.function.BasicFunctionExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrimFunction
extends BasicFunctionExpression<String> {
    public static final String NAME = "trim";
    public static final QueryBuilder.Trimspec DEFAULT_TRIMSPEC = QueryBuilder.Trimspec.BOTH;
    public static final char DEFAULT_TRIM_CHAR = ' ';
    private final QueryBuilder.Trimspec trimspec;
    private final Expression<Character> trimCharacter;
    private final Expression<String> trimSource;

    public TrimFunction(QueryBuilderImpl queryBuilder, QueryBuilder.Trimspec trimspec, Expression<Character> trimCharacter, Expression<String> trimSource) {
        super(queryBuilder, String.class, NAME);
        this.trimspec = trimspec;
        this.trimCharacter = trimCharacter;
        this.trimSource = trimSource;
    }

    public TrimFunction(QueryBuilderImpl queryBuilder, QueryBuilder.Trimspec trimspec, char trimCharacter, Expression<String> trimSource) {
        super(queryBuilder, String.class, NAME);
        this.trimspec = trimspec;
        this.trimCharacter = new LiteralExpression<Character>(queryBuilder, Character.valueOf(trimCharacter));
        this.trimSource = trimSource;
    }

    public TrimFunction(QueryBuilderImpl queryBuilder, Expression<String> trimSource) {
        this(queryBuilder, DEFAULT_TRIMSPEC, ' ', trimSource);
    }

    public TrimFunction(QueryBuilderImpl queryBuilder, Expression<Character> trimCharacter, Expression<String> trimSource) {
        this(queryBuilder, DEFAULT_TRIMSPEC, trimCharacter, trimSource);
    }

    public TrimFunction(QueryBuilderImpl queryBuilder, char trimCharacter, Expression<String> trimSource) {
        this(queryBuilder, DEFAULT_TRIMSPEC, trimCharacter, trimSource);
    }

    public TrimFunction(QueryBuilderImpl queryBuilder, QueryBuilder.Trimspec trimspec, Expression<String> trimSource) {
        this(queryBuilder, trimspec, ' ', trimSource);
    }

    public Expression<Character> getTrimCharacter() {
        return this.trimCharacter;
    }

    public Expression<String> getTrimSource() {
        return this.trimSource;
    }

    public QueryBuilder.Trimspec getTrimspec() {
        return this.trimspec;
    }

    @Override
    public void registerParameters(ParameterRegistry registry) {
        ParameterContainer.Helper.possibleParameter(this.getTrimCharacter(), registry);
        ParameterContainer.Helper.possibleParameter(this.getTrimSource(), registry);
    }
}

