/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.criteria.expression.function;

import javax.persistence.criteria.Expression;
import org.hibernate.ejb.criteria.ParameterContainer;
import org.hibernate.ejb.criteria.ParameterRegistry;
import org.hibernate.ejb.criteria.QueryBuilderImpl;
import org.hibernate.ejb.criteria.expression.LiteralExpression;
import org.hibernate.ejb.criteria.expression.function.BasicFunctionExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubstringFunction
extends BasicFunctionExpression<String> {
    public static final String NAME = "substring";
    private final Expression<String> value;
    private final Expression<Integer> start;
    private final Expression<Integer> length;

    public SubstringFunction(QueryBuilderImpl queryBuilder, Expression<String> value, Expression<Integer> start, Expression<Integer> length) {
        super(queryBuilder, String.class, NAME);
        this.value = value;
        this.start = start;
        this.length = length;
    }

    public SubstringFunction(QueryBuilderImpl queryBuilder, Expression<String> value, Expression<Integer> start) {
        this(queryBuilder, value, start, (Expression<Integer>)((Expression)null));
    }

    public SubstringFunction(QueryBuilderImpl queryBuilder, Expression<String> value, int start) {
        this(queryBuilder, value, new LiteralExpression<Integer>(queryBuilder, start));
    }

    public SubstringFunction(QueryBuilderImpl queryBuilder, Expression<String> value, int start, int length) {
        this(queryBuilder, value, new LiteralExpression<Integer>(queryBuilder, start), new LiteralExpression<Integer>(queryBuilder, length));
    }

    public Expression<Integer> getLength() {
        return this.length;
    }

    public Expression<Integer> getStart() {
        return this.start;
    }

    public Expression<String> getValue() {
        return this.value;
    }

    @Override
    public void registerParameters(ParameterRegistry registry) {
        ParameterContainer.Helper.possibleParameter(this.getLength(), registry);
        ParameterContainer.Helper.possibleParameter(this.getStart(), registry);
        ParameterContainer.Helper.possibleParameter(this.getValue(), registry);
    }
}

