/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.criteria.expression.function;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.persistence.criteria.Expression;
import org.hibernate.ejb.criteria.ParameterContainer;
import org.hibernate.ejb.criteria.ParameterRegistry;
import org.hibernate.ejb.criteria.QueryBuilderImpl;
import org.hibernate.ejb.criteria.expression.LiteralExpression;
import org.hibernate.ejb.criteria.expression.function.BasicFunctionExpression;
import org.hibernate.ejb.criteria.expression.function.FunctionExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterizedFunctionExpression<X>
extends BasicFunctionExpression<X>
implements FunctionExpression<X> {
    private final List<Expression<?>> argumentExpressions;

    public ParameterizedFunctionExpression(QueryBuilderImpl queryBuilder, Class<X> javaType, String functionName, List<Expression<?>> argumentExpressions) {
        super(queryBuilder, javaType, functionName);
        this.argumentExpressions = argumentExpressions;
    }

    public ParameterizedFunctionExpression(QueryBuilderImpl queryBuilder, Class<X> javaType, String functionName, Expression<?> ... argumentExpressions) {
        super(queryBuilder, javaType, functionName);
        this.argumentExpressions = Arrays.asList(argumentExpressions);
    }

    protected static List<Expression<?>> wrapAsLiterals(QueryBuilderImpl queryBuilder, Object ... literalArguments) {
        ArrayList arguments = new ArrayList(ParameterizedFunctionExpression.properSize(literalArguments.length));
        for (Object o : literalArguments) {
            arguments.add(new LiteralExpression<Object>(queryBuilder, o));
        }
        return arguments;
    }

    protected static int properSize(int number) {
        return number + (int)((double)number * 0.75) + 1;
    }

    public List<Expression<?>> getArgumentExpressions() {
        return this.argumentExpressions;
    }

    @Override
    public void registerParameters(ParameterRegistry registry) {
        for (Expression<?> argument : this.getArgumentExpressions()) {
            if (!ParameterContainer.class.isInstance(argument)) continue;
            ((ParameterContainer)argument).registerParameters(registry);
        }
    }
}

