/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.criteria.expression.function;

import javax.persistence.criteria.Expression;
import org.hibernate.ejb.criteria.QueryBuilderImpl;
import org.hibernate.ejb.criteria.expression.LiteralExpression;
import org.hibernate.ejb.criteria.expression.function.ParameterizedFunctionExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregationFunction<T>
extends ParameterizedFunctionExpression<T> {
    public AggregationFunction(QueryBuilderImpl queryBuilder, Class<T> returnType, String functionName, Object argument) {
        this(queryBuilder, returnType, functionName, (Expression<?>)new LiteralExpression<Object>(queryBuilder, argument));
    }

    public AggregationFunction(QueryBuilderImpl queryBuilder, Class<T> returnType, String functionName, Expression<?> argument) {
        super(queryBuilder, returnType, functionName, argument);
    }

    @Override
    public boolean isAggregation() {
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GREATEST<X extends Comparable<X>>
    extends AggregationFunction<X> {
        public static final String NAME = "max";

        public GREATEST(QueryBuilderImpl queryBuilder, Expression<X> expression) {
            super(queryBuilder, expression.getJavaType(), NAME, (Expression<?>)expression);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LEAST<X extends Comparable<X>>
    extends AggregationFunction<X> {
        public static final String NAME = "min";

        public LEAST(QueryBuilderImpl queryBuilder, Expression<X> expression) {
            super(queryBuilder, expression.getJavaType(), NAME, (Expression<?>)expression);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MAX<N extends Number>
    extends AggregationFunction<N> {
        public static final String NAME = "max";

        public MAX(QueryBuilderImpl queryBuilder, Expression<N> expression) {
            super(queryBuilder, expression.getJavaType(), NAME, (Expression<?>)expression);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MIN<N extends Number>
    extends AggregationFunction<N> {
        public static final String NAME = "min";

        public MIN(QueryBuilderImpl queryBuilder, Expression<N> expression) {
            super(queryBuilder, expression.getJavaType(), NAME, (Expression<?>)expression);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SUM<N extends Number>
    extends AggregationFunction<N> {
        public static final String NAME = "sum";

        public SUM(QueryBuilderImpl queryBuilder, Expression<N> expression) {
            super(queryBuilder, expression.getJavaType(), NAME, (Expression<?>)expression);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AVG
    extends AggregationFunction<Double> {
        public static final String NAME = "avg";

        public AVG(QueryBuilderImpl queryBuilder, Expression<? extends Number> expression) {
            super(queryBuilder, Double.class, NAME, (Expression<?>)expression);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class COUNT
    extends AggregationFunction<Long> {
        public static final String NAME = "count";
        private final boolean distinct;

        public COUNT(QueryBuilderImpl queryBuilder, Expression<?> expression, boolean distinct) {
            super(queryBuilder, Long.class, NAME, expression);
            this.distinct = distinct;
        }

        public boolean isDistinct() {
            return this.distinct;
        }
    }
}

