/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.criteria.expression;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.QueryBuilder;
import org.hibernate.ejb.criteria.ParameterContainer;
import org.hibernate.ejb.criteria.ParameterRegistry;
import org.hibernate.ejb.criteria.QueryBuilderImpl;
import org.hibernate.ejb.criteria.expression.ExpressionImpl;
import org.hibernate.ejb.criteria.expression.LiteralExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleCaseExpression<C, R>
extends ExpressionImpl<R>
implements QueryBuilder.SimpleCase<C, R> {
    private Class<R> javaType;
    private final Expression<? extends C> expression;
    private List<WhenClause> whenClauses = new ArrayList<WhenClause>();
    private Expression<? extends R> otherwiseResult;

    public SimpleCaseExpression(QueryBuilderImpl queryBuilder, Class<R> javaType, Expression<? extends C> expression) {
        super(queryBuilder, javaType);
        this.javaType = javaType;
        this.expression = expression;
    }

    public Expression<C> getExpression() {
        return this.expression;
    }

    public QueryBuilder.SimpleCase<C, R> when(C condition, R result) {
        return this.when(condition, (Expression<? extends R>)this.buildLiteral(result));
    }

    private LiteralExpression<R> buildLiteral(R result) {
        Class<Object> type = result != null ? result.getClass() : this.getJavaType();
        return new LiteralExpression(this.queryBuilder(), type, result);
    }

    public QueryBuilder.SimpleCase<C, R> when(C condition, Expression<? extends R> result) {
        WhenClause whenClause = new WhenClause(condition, result);
        this.whenClauses.add(whenClause);
        this.adjustJavaType(result);
        return this;
    }

    private void adjustJavaType(Expression<? extends R> exp) {
        if (this.javaType == null) {
            this.javaType = exp.getJavaType();
        }
    }

    public Expression<R> otherwise(R result) {
        return this.otherwise((Expression<? extends R>)this.buildLiteral(result));
    }

    public Expression<R> otherwise(Expression<? extends R> result) {
        this.otherwiseResult = result;
        this.adjustJavaType(result);
        return this;
    }

    public Expression<? extends R> getOtherwiseResult() {
        return this.otherwiseResult;
    }

    public List<WhenClause> getWhenClauses() {
        return this.whenClauses;
    }

    @Override
    public void registerParameters(ParameterRegistry registry) {
        ParameterContainer.Helper.possibleParameter(this.getExpression(), registry);
        for (WhenClause whenClause : this.getWhenClauses()) {
            ParameterContainer.Helper.possibleParameter(whenClause.getResult(), registry);
        }
        ParameterContainer.Helper.possibleParameter(this.getOtherwiseResult(), registry);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class WhenClause {
        private final C condition;
        private final Expression<? extends R> result;

        public WhenClause(C condition, Expression<? extends R> result) {
            this.condition = condition;
            this.result = result;
        }

        public C getCondition() {
            return this.condition;
        }

        public Expression<? extends R> getResult() {
            return this.result;
        }
    }
}

