/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.criteria.expression;

import javax.persistence.metamodel.PluralAttribute;
import org.hibernate.ejb.criteria.ParameterRegistry;
import org.hibernate.ejb.criteria.QueryBuilderImpl;
import org.hibernate.ejb.criteria.expression.ExpressionImpl;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.persister.collection.CollectionPersister;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionExpression<C>
extends ExpressionImpl<C> {
    private final CollectionPersister persister;
    private final PluralAttribute<?, C, ?> attribute;

    public CollectionExpression(QueryBuilderImpl queryBuilder, Class<C> javaType, PluralAttribute<?, C, ?> attribute) {
        this(queryBuilder, javaType, CollectionExpression.resolvePersister(queryBuilder, attribute), attribute);
    }

    private static CollectionPersister resolvePersister(QueryBuilderImpl queryBuilder, PluralAttribute attribute) {
        SessionFactoryImplementor sfi = (SessionFactoryImplementor)queryBuilder.getEntityManagerFactory().getSessionFactory();
        return sfi.getCollectionPersister(CollectionExpression.resolveRole(attribute));
    }

    private static String resolveRole(PluralAttribute attribute) {
        return attribute.getDeclaringType().getJavaType().getName() + '.' + attribute.getName();
    }

    public CollectionExpression(QueryBuilderImpl queryBuilder, Class<C> javaType, CollectionPersister persister, PluralAttribute<?, C, ?> attribute) {
        super(queryBuilder, javaType);
        this.persister = persister;
        this.attribute = attribute;
    }

    public PluralAttribute<?, C, ?> getAttribute() {
        return this.attribute;
    }

    public CollectionPersister getPersister() {
        return this.persister;
    }

    @Override
    public void registerParameters(ParameterRegistry registry) {
    }
}

