/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.criteria.expression;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.QueryBuilder;
import org.hibernate.ejb.criteria.ParameterContainer;
import org.hibernate.ejb.criteria.ParameterRegistry;
import org.hibernate.ejb.criteria.QueryBuilderImpl;
import org.hibernate.ejb.criteria.expression.ExpressionImpl;
import org.hibernate.ejb.criteria.expression.LiteralExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoalesceExpression<T>
extends ExpressionImpl<T>
implements QueryBuilder.Coalesce<T> {
    private final List<Expression<? extends T>> expressions;
    private Class<T> javaType;

    public CoalesceExpression(QueryBuilderImpl queryBuilder) {
        this(queryBuilder, (Class<T>)null);
    }

    public CoalesceExpression(QueryBuilderImpl queryBuilder, Class<T> javaType) {
        super(queryBuilder, javaType);
        this.javaType = javaType;
        this.expressions = new ArrayList<Expression<? extends T>>();
    }

    @Override
    public Class<T> getJavaType() {
        return this.javaType;
    }

    public QueryBuilder.Coalesce<T> value(T value) {
        return this.value((Expression<? extends T>)new LiteralExpression<T>(this.queryBuilder(), value));
    }

    public QueryBuilder.Coalesce<T> value(Expression<? extends T> value) {
        this.expressions.add(value);
        if (this.javaType == null) {
            this.javaType = value.getJavaType();
        }
        return this;
    }

    public List<Expression<? extends T>> getExpressions() {
        return this.expressions;
    }

    @Override
    public void registerParameters(ParameterRegistry registry) {
        for (Expression<T> expression : this.getExpressions()) {
            ParameterContainer.Helper.possibleParameter(expression, registry);
        }
    }
}

