/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.criteria.expression;

import javax.persistence.criteria.Expression;
import org.hibernate.ejb.criteria.ParameterContainer;
import org.hibernate.ejb.criteria.ParameterRegistry;
import org.hibernate.ejb.criteria.QueryBuilderImpl;
import org.hibernate.ejb.criteria.expression.BinaryOperatorExpression;
import org.hibernate.ejb.criteria.expression.ExpressionImpl;
import org.hibernate.ejb.criteria.expression.LiteralExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryArithmeticOperation<N extends Number>
extends ExpressionImpl<N>
implements BinaryOperatorExpression<N> {
    private final Operation operator;
    private final Expression<? extends N> rhs;
    private final Expression<? extends N> lhs;

    public static Class<? extends Number> determineReturnType(Class<? extends Number> defaultType, Expression<? extends Number> expression) {
        return expression == null || expression.getJavaType() == null ? defaultType : expression.getJavaType();
    }

    public static Class<? extends Number> determineReturnType(Class<? extends Number> defaultType, Number numberLiteral) {
        return numberLiteral == null ? defaultType : numberLiteral.getClass();
    }

    public BinaryArithmeticOperation(QueryBuilderImpl queryBuilder, Class<N> resultType, Operation operator, Expression<? extends N> rhs, Expression<? extends N> lhs) {
        super(queryBuilder, resultType);
        this.operator = operator;
        this.rhs = rhs;
        this.lhs = lhs;
    }

    public BinaryArithmeticOperation(QueryBuilderImpl queryBuilder, Class<N> javaType, Operation operator, Expression<? extends N> rhs, N lhs) {
        super(queryBuilder, javaType);
        this.operator = operator;
        this.rhs = rhs;
        this.lhs = new LiteralExpression<N>(queryBuilder, lhs);
    }

    public BinaryArithmeticOperation(QueryBuilderImpl queryBuilder, Class<N> javaType, Operation operator, N rhs, Expression<? extends N> lhs) {
        super(queryBuilder, javaType);
        this.operator = operator;
        this.rhs = new LiteralExpression<N>(queryBuilder, rhs);
        this.lhs = lhs;
    }

    public Operation getOperator() {
        return this.operator;
    }

    @Override
    public Expression<? extends N> getRightHandOperand() {
        return this.rhs;
    }

    @Override
    public Expression<? extends N> getLeftHandOperand() {
        return this.lhs;
    }

    @Override
    public void registerParameters(ParameterRegistry registry) {
        ParameterContainer.Helper.possibleParameter(this.getRightHandOperand(), registry);
        ParameterContainer.Helper.possibleParameter(this.getLeftHandOperand(), registry);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operation {
        ADD,
        SUBTRACT,
        MULTIPLY,
        DIVIDE,
        QUOT,
        MOD;

    }
}

