/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.criteria;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.criteria.AbstractQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.Subquery;
import javax.persistence.metamodel.EntityType;
import org.hibernate.ejb.criteria.CriteriaSubqueryImpl;
import org.hibernate.ejb.criteria.ParameterContainer;
import org.hibernate.ejb.criteria.ParameterRegistry;
import org.hibernate.ejb.criteria.QueryBuilderImpl;
import org.hibernate.ejb.criteria.RootImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryStructure<T> {
    private final AbstractQuery<T> owner;
    private final QueryBuilderImpl queryBuilder;
    private boolean distinction;
    private Selection<? extends T> selection;
    private Set<Root<?>> roots = new HashSet();
    private Predicate restriction;
    private List<Expression<?>> groupings = Collections.emptyList();
    private Predicate having;
    private List<Subquery<?>> subqueries;

    public QueryStructure(AbstractQuery<T> owner, QueryBuilderImpl queryBuilder) {
        this.owner = owner;
        this.queryBuilder = queryBuilder;
    }

    public Set<ParameterExpression<?>> getParameters() {
        final LinkedHashSet parameters = new LinkedHashSet();
        ParameterRegistry registry = new ParameterRegistry(){

            @Override
            public void registerParameter(ParameterExpression<?> parameter) {
                parameters.add(parameter);
            }
        };
        ParameterContainer.Helper.possibleParameter(this.selection, registry);
        ParameterContainer.Helper.possibleParameter((Selection)this.restriction, registry);
        ParameterContainer.Helper.possibleParameter((Selection)this.having, registry);
        if (this.subqueries != null) {
            for (Subquery<?> subquery : this.subqueries) {
                ParameterContainer.Helper.possibleParameter(subquery, registry);
            }
        }
        ParameterContainer.Helper.possibleParameter((Selection)this.having, registry);
        if (this.groupings != null) {
            for (Expression expression : this.groupings) {
                ParameterContainer.Helper.possibleParameter((Selection)expression, registry);
            }
        }
        return parameters;
    }

    public boolean isDistinction() {
        return this.distinction;
    }

    public void setDistinction(boolean distinction) {
        this.distinction = distinction;
    }

    public Selection<? extends T> getSelection() {
        return this.selection;
    }

    public void setSelection(Selection<? extends T> selection) {
        this.selection = selection;
    }

    public Set<Root<?>> getRoots() {
        return this.roots;
    }

    public <X> Root<X> from(Class<X> entityClass) {
        EntityType entityType = this.queryBuilder.getEntityManagerFactory().getMetamodel().entity(entityClass);
        if (entityType == null) {
            throw new IllegalArgumentException(entityClass + " is not an entity");
        }
        return this.from(entityType);
    }

    public <X> Root<X> from(EntityType<X> entityType) {
        RootImpl<X> root = new RootImpl<X>(this.queryBuilder, entityType);
        this.roots.add(root);
        return root;
    }

    public Predicate getRestriction() {
        return this.restriction;
    }

    public void setRestriction(Predicate restriction) {
        this.restriction = restriction;
    }

    public List<Expression<?>> getGroupings() {
        return this.groupings;
    }

    public void setGroupings(List<Expression<?>> groupings) {
        this.groupings = groupings;
    }

    public void setGroupings(Expression<?> ... groupings) {
        this.groupings = groupings != null && groupings.length > 0 ? Arrays.asList(groupings) : Collections.emptyList();
    }

    public Predicate getHaving() {
        return this.having;
    }

    public void setHaving(Predicate having) {
        this.having = having;
    }

    public List<Subquery<?>> getSubqueries() {
        return this.subqueries;
    }

    public List<Subquery<?>> internalGetSubqueries() {
        if (this.subqueries == null) {
            this.subqueries = new ArrayList();
        }
        return this.subqueries;
    }

    public <U> Subquery<U> subquery(Class<U> subqueryType) {
        CriteriaSubqueryImpl<U> subquery = new CriteriaSubqueryImpl<U>(this.queryBuilder, subqueryType, this.owner);
        this.internalGetSubqueries().add(subquery);
        return subquery;
    }
}

