/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.criteria;

import java.lang.reflect.Member;
import java.util.Map;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.MapJoin;
import javax.persistence.criteria.Path;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.Bindable;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.MapAttribute;
import javax.persistence.metamodel.SingularAttribute;
import javax.persistence.metamodel.Type;
import org.hibernate.ejb.criteria.JoinImpl;
import org.hibernate.ejb.criteria.ParameterRegistry;
import org.hibernate.ejb.criteria.PathImpl;
import org.hibernate.ejb.criteria.QueryBuilderImpl;
import org.hibernate.ejb.criteria.expression.ExpressionImpl;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.persister.collection.CollectionPersister;

public class MapKeyHelpers {
    private MapKeyHelpers() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MapEntryExpression<K, V>
    extends ExpressionImpl<Map.Entry<K, V>>
    implements Expression<Map.Entry<K, V>> {
        private final MapAttribute<?, K, V> attribute;

        public MapEntryExpression(QueryBuilderImpl queryBuilder, Class<Map.Entry<K, V>> javaType, MapAttribute<?, K, V> attribute) {
            super(queryBuilder, javaType);
            this.attribute = attribute;
        }

        public MapAttribute<?, K, V> getAttribute() {
            return this.attribute;
        }

        @Override
        public void registerParameters(ParameterRegistry registry) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MapKeyAttribute<K>
    implements SingularAttribute<Map<K, ?>, K> {
        private final MapAttribute<?, K, ?> attribute;
        private final CollectionPersister mapPersister;
        private final org.hibernate.type.Type mapKeyType;
        private final Type<K> jpaType;
        private final Bindable.BindableType jpaBindableType;
        private final Class<K> jpaBinableJavaType;

        public MapKeyAttribute(QueryBuilderImpl queryBuilder, MapAttribute<?, K, ?> attribute) {
            this.attribute = attribute;
            this.jpaType = attribute.getKeyType();
            this.jpaBinableJavaType = attribute.getKeyJavaType();
            this.jpaBindableType = Type.PersistenceType.ENTITY.equals((Object)this.jpaType.getPersistenceType()) ? Bindable.BindableType.ENTITY_TYPE : Bindable.BindableType.SINGULAR_ATTRIBUTE;
            String guessedRoleName = this.determineRole(attribute);
            SessionFactoryImplementor sfi = (SessionFactoryImplementor)queryBuilder.getEntityManagerFactory().getSessionFactory();
            this.mapPersister = sfi.getCollectionPersister(guessedRoleName);
            if (this.mapPersister == null) {
                throw new IllegalStateException("Could not locate collection persister [" + guessedRoleName + "]");
            }
            this.mapKeyType = this.mapPersister.getIndexType();
            if (this.mapKeyType == null) {
                throw new IllegalStateException("Could not determine map-key type [" + guessedRoleName + "]");
            }
        }

        private String determineRole(MapAttribute<?, K, ?> attribute) {
            return attribute.getDeclaringType().getJavaType().getName() + '.' + attribute.getName();
        }

        public String getName() {
            return "map-key";
        }

        public Attribute.PersistentAttributeType getPersistentAttributeType() {
            if (this.mapKeyType.isEntityType()) {
                return Attribute.PersistentAttributeType.MANY_TO_ONE;
            }
            if (this.mapKeyType.isComponentType()) {
                return Attribute.PersistentAttributeType.EMBEDDED;
            }
            return Attribute.PersistentAttributeType.BASIC;
        }

        public ManagedType<Map<K, ?>> getDeclaringType() {
            return null;
        }

        public Class<K> getJavaType() {
            return this.attribute.getKeyJavaType();
        }

        public Member getJavaMember() {
            return null;
        }

        public boolean isAssociation() {
            return this.mapKeyType.isEntityType();
        }

        public boolean isCollection() {
            return false;
        }

        public boolean isId() {
            return false;
        }

        public boolean isVersion() {
            return false;
        }

        public boolean isOptional() {
            return false;
        }

        public Type<K> getType() {
            return this.jpaType;
        }

        public Bindable.BindableType getBindableType() {
            return this.jpaBindableType;
        }

        public Class<K> getBindableJavaType() {
            return this.jpaBinableJavaType;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MapPath<K, V>
    extends PathImpl<Map<K, V>>
    implements Path<Map<K, V>> {
        private final MapJoin<?, K, V> mapJoin;

        public MapPath(QueryBuilderImpl queryBuilder, Class<Map<K, V>> javaType, MapJoin<?, K, V> mapJoin, MapAttribute<?, K, V> attribute, Object model) {
            super(queryBuilder, javaType, null, (Attribute<?, ?>)attribute, model);
            this.mapJoin = mapJoin;
        }

        public MapAttribute<?, K, V> getAttribute() {
            return (MapAttribute)super.getAttribute();
        }

        @Override
        public PathImpl<?> getParentPath() {
            return (PathImpl)this.mapJoin;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MapKeyPath<K>
    extends PathImpl<K>
    implements Path<K> {
        public MapKeyPath(QueryBuilderImpl queryBuilder, MapPath<K, ?> source, MapKeyAttribute<K> attribute) {
            super(queryBuilder, attribute.getJavaType(), (PathImpl<?>)source, (Attribute<?, ?>)attribute, attribute.getType());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MapKeyJoin<K, V>
    extends JoinImpl<Map<K, V>, K>
    implements Join<Map<K, V>, K> {
        public MapKeyJoin(QueryBuilderImpl queryBuilder, MapPath<K, V> source, MapKeyAttribute<K> attribute, JoinType jt) {
            super(queryBuilder, attribute.getJavaType(), source, attribute, jt);
        }
    }
}

