/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.util;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.persistence.PersistenceException;
import javax.persistence.spi.LoadState;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.intercept.FieldInterceptionHelper;
import org.hibernate.intercept.FieldInterceptor;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceUtilHelper {
    public static LoadState isLoadedWithoutReference(Object proxy, String property) {
        Object entity;
        boolean sureFromUs = false;
        if (proxy instanceof HibernateProxy) {
            LazyInitializer li = ((HibernateProxy)proxy).getHibernateLazyInitializer();
            if (li.isUninitialized()) {
                return LoadState.NOT_LOADED;
            }
            entity = li.getImplementation();
            sureFromUs = true;
        } else {
            entity = proxy;
        }
        if (FieldInterceptionHelper.isInstrumented((Object)entity)) {
            LoadState state;
            boolean isInitialized;
            FieldInterceptor interceptor = FieldInterceptionHelper.extractFieldInterceptor((Object)entity);
            boolean bl = isInitialized = interceptor == null || interceptor.isInitialized(property);
            if (isInitialized && interceptor != null) {
                state = PersistenceUtilHelper.isLoaded(PersistenceUtilHelper.get(entity, property));
                if (state == LoadState.UNKNOWN) {
                    state = LoadState.LOADED;
                }
            } else if (interceptor != null && !isInitialized) {
                state = LoadState.NOT_LOADED;
            } else if (sureFromUs) {
                state = PersistenceUtilHelper.isLoaded(PersistenceUtilHelper.get(entity, property));
                if (state == LoadState.UNKNOWN) {
                    state = LoadState.LOADED;
                }
            } else {
                state = LoadState.UNKNOWN;
            }
            return state;
        }
        return LoadState.UNKNOWN;
    }

    public static LoadState isLoadedWithReference(Object proxy, String property) {
        Object object = PersistenceUtilHelper.get(proxy, property);
        return PersistenceUtilHelper.isLoaded(object);
    }

    private static Object get(Object proxy, String property) {
        Class<?> clazz = proxy.getClass();
        try {
            try {
                Field field = clazz.getField(property);
                PersistenceUtilHelper.setAccessibility(field);
                return field.get(proxy);
            }
            catch (NoSuchFieldException e) {
                Method method = PersistenceUtilHelper.getMethod(clazz, property);
                if (method != null) {
                    PersistenceUtilHelper.setAccessibility(method);
                    return method.invoke(proxy, new Object[0]);
                }
                throw new PersistenceException("Unable to find field or method: " + clazz + "#" + property);
            }
        }
        catch (IllegalAccessException e) {
            throw new PersistenceException("Unable to access field or method: " + clazz + "#" + property, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new PersistenceException("Unable to access field or method: " + clazz + "#" + property, (Throwable)e);
        }
    }

    private static Method getMethod(Class<?> clazz, String methodName) {
        try {
            char[] string = methodName.toCharArray();
            string[0] = Character.toUpperCase(string[0]);
            methodName = new String(string);
            try {
                return clazz.getMethod("get" + methodName, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                return clazz.getMethod("is" + methodName, new Class[0]);
            }
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private static void setAccessibility(Member member) {
        if (!Modifier.isPublic(member.getModifiers())) {
            ((AccessibleObject)((Object)member)).setAccessible(true);
        }
    }

    public static LoadState isLoaded(Object o) {
        if (o instanceof HibernateProxy) {
            boolean isInitialized = !((HibernateProxy)o).getHibernateLazyInitializer().isUninitialized();
            return isInitialized ? LoadState.LOADED : LoadState.NOT_LOADED;
        }
        if (o instanceof PersistentCollection) {
            boolean isInitialized = ((PersistentCollection)o).wasInitialized();
            return isInitialized ? LoadState.LOADED : LoadState.NOT_LOADED;
        }
        return LoadState.UNKNOWN;
    }
}

