/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.Parameter;
import javax.persistence.PersistenceException;
import javax.persistence.TransactionRequiredException;
import javax.persistence.TypedQuery;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.TypeMismatchException;
import org.hibernate.ejb.HibernateEntityManagerImplementor;
import org.hibernate.ejb.QueryHints;
import org.hibernate.ejb.util.ConfigurationHelper;
import org.hibernate.hql.QueryExecutionRequestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractQueryImpl<X>
implements TypedQuery<X> {
    private static final Logger log = LoggerFactory.getLogger(AbstractQueryImpl.class);
    private final HibernateEntityManagerImplementor entityManager;
    private int maxResults = -1;
    private int firstResult;
    private Map<String, Object> hints;
    private FlushModeType jpaFlushMode;
    private Map parameterBindings;

    public AbstractQueryImpl(HibernateEntityManagerImplementor entityManager) {
        this.entityManager = entityManager;
    }

    protected HibernateEntityManagerImplementor getEntityManager() {
        return this.entityManager;
    }

    protected abstract int internalExecuteUpdate();

    public int executeUpdate() {
        try {
            if (!this.entityManager.isTransactionInProgress()) {
                this.entityManager.throwPersistenceException((PersistenceException)new TransactionRequiredException("Executing an update/delete query"));
                return 0;
            }
            return this.internalExecuteUpdate();
        }
        catch (QueryExecutionRequestException he) {
            throw new IllegalStateException(he);
        }
        catch (TypeMismatchException e) {
            throw new IllegalArgumentException(e);
        }
        catch (HibernateException he) {
            this.entityManager.throwPersistenceException(he);
            return 0;
        }
    }

    protected abstract void applyMaxResults(int var1);

    public TypedQuery<X> setMaxResults(int maxResult) {
        if (maxResult < 0) {
            throw new IllegalArgumentException("Negative value (" + maxResult + ") passed to setMaxResults");
        }
        this.maxResults = maxResult;
        this.applyMaxResults(maxResult);
        return this;
    }

    public int getSpecifiedMaxResults() {
        return this.maxResults;
    }

    public int getMaxResults() {
        return this.maxResults == -1 ? Integer.MAX_VALUE : this.maxResults;
    }

    protected abstract void applyFirstResult(int var1);

    public TypedQuery<X> setFirstResult(int firstResult) {
        if (firstResult < 0) {
            throw new IllegalArgumentException("Negative value (" + firstResult + ") passed to setFirstResult");
        }
        this.firstResult = firstResult;
        this.applyFirstResult(firstResult);
        return this;
    }

    public int getFirstResult() {
        return this.firstResult;
    }

    public Map<String, Object> getHints() {
        return this.hints;
    }

    protected abstract void applyTimeout(int var1);

    protected abstract void applyComment(String var1);

    protected abstract void applyFetchSize(int var1);

    protected abstract void applyCacheable(boolean var1);

    protected abstract void applyCacheRegion(String var1);

    protected abstract void applyReadOnly(boolean var1);

    protected abstract void applyCacheMode(CacheMode var1);

    protected abstract void applyFlushMode(FlushMode var1);

    public TypedQuery<X> setHint(String hintName, Object value) {
        boolean skipped = false;
        try {
            if ("org.hibernate.timeout".equals(hintName)) {
                this.applyTimeout(ConfigurationHelper.getInteger(value));
            } else if ("org.hibernate.comment".equals(hintName)) {
                this.applyComment((String)value);
            } else if ("org.hibernate.fetchSize".equals(hintName)) {
                this.applyFetchSize(ConfigurationHelper.getInteger(value));
            } else if ("org.hibernate.cacheable".equals(hintName)) {
                this.applyCacheable(ConfigurationHelper.getBoolean(value));
            } else if ("org.hibernate.cacheRegion".equals(hintName)) {
                this.applyCacheRegion((String)value);
            } else if ("org.hibernate.readOnly".equals(hintName)) {
                this.applyReadOnly(ConfigurationHelper.getBoolean(value));
            } else if ("org.hibernate.cacheMode".equals(hintName)) {
                this.applyCacheMode(ConfigurationHelper.getCacheMode(value));
            } else if ("org.hibernate.flushMode".equals(hintName)) {
                this.applyFlushMode(ConfigurationHelper.getFlushMode(value));
            } else {
                skipped = true;
                log.info("Ignoring unrecognized query hint [" + hintName + "]");
            }
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Value for hint");
        }
        if (!skipped) {
            if (this.hints == null) {
                this.hints = new HashMap<String, Object>();
            }
            this.hints.put(hintName, value);
        }
        return this;
    }

    public Set<String> getSupportedHints() {
        return QueryHints.getDefinedHints();
    }

    public abstract TypedQuery<X> setLockMode(LockModeType var1);

    public abstract LockModeType getLockMode();

    public TypedQuery<X> setFlushMode(FlushModeType jpaFlushMode) {
        this.jpaFlushMode = jpaFlushMode;
        if (jpaFlushMode == FlushModeType.AUTO) {
            this.applyFlushMode(FlushMode.AUTO);
        } else if (jpaFlushMode == FlushModeType.COMMIT) {
            this.applyFlushMode(FlushMode.COMMIT);
        }
        return this;
    }

    protected FlushModeType getSpecifiedFlushMode() {
        return this.jpaFlushMode;
    }

    public FlushModeType getFlushMode() {
        return this.jpaFlushMode != null ? this.jpaFlushMode : this.entityManager.getFlushMode();
    }

    protected void registerParameterBinding(Parameter parameter, Object value) {
        if (value != null && parameter.getParameterType() != null) {
            if (Collection.class.isInstance(value)) {
                Collection collection = (Collection)value;
                for (Object element : collection) {
                    if (parameter.getParameterType().isInstance(element)) continue;
                    throw new IllegalArgumentException("Parameter value [" + element + "] was not matching type [" + parameter.getParameterType().getName() + "]");
                }
            } else if (value.getClass().isArray()) {
                Object[] array;
                for (Object element : array = (Object[])value) {
                    if (parameter.getParameterType().isInstance(element)) continue;
                    throw new IllegalArgumentException("Parameter value [" + element + "] was not matching type [" + parameter.getParameterType().getName() + "]");
                }
            } else if (!parameter.getParameterType().isInstance(value)) {
                throw new IllegalArgumentException("Parameter value [" + value + "] was not matching type [" + parameter.getParameterType().getName() + "]");
            }
        }
        if (this.parameterBindings == null) {
            this.parameterBindings = new HashMap();
        }
        this.parameterBindings.put(parameter, value);
    }

    public boolean isBound(Parameter<?> param) {
        return this.parameterBindings != null && this.parameterBindings.containsKey(param);
    }

    public <T> T getParameterValue(Parameter<T> param) {
        if (this.parameterBindings == null) {
            throw new IllegalStateException("No parameters have been bound");
        }
        try {
            Object value = this.parameterBindings.get(param);
            if (value == null) {
                throw new IllegalStateException("Parameter has not been bound");
            }
            return (T)value;
        }
        catch (ClassCastException cce) {
            throw new IllegalStateException("Encountered a parameter value type exception");
        }
    }

    public Object getParameterValue(String name) {
        return this.getParameterValue(this.getParameter(name));
    }

    public Object getParameterValue(int position) {
        return this.getParameterValue(this.getParameter(position));
    }
}

