/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.ActionQueue;
import org.hibernate.event.internal.AbstractFlushingEventListener;
import org.hibernate.event.spi.AutoFlushEvent;
import org.hibernate.event.spi.AutoFlushEventListener;
import org.hibernate.event.spi.EventSource;
import org.hibernate.internal.CoreMessageLogger;
import org.jboss.logging.Logger;

public class DefaultAutoFlushEventListener
extends AbstractFlushingEventListener
implements AutoFlushEventListener {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)DefaultAutoFlushEventListener.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onAutoFlush(AutoFlushEvent event) throws HibernateException {
        EventSource source = event.getSession();
        try {
            source.getEventListenerManager().partialFlushStart();
            if (this.flushMightBeNeeded(source)) {
                ActionQueue actionQueue = source.getActionQueue();
                int oldSize = actionQueue.numberOfCollectionRemovals();
                this.flushEverythingToExecutions(event);
                if (this.flushIsReallyNeeded(event, source)) {
                    LOG.trace("Need to execute flush");
                    event.setFlushRequired(true);
                    this.performExecutions(source);
                    this.postFlush(source);
                    this.postPostFlush(source);
                    if (source.getFactory().getStatistics().isStatisticsEnabled()) {
                        source.getFactory().getStatistics().flush();
                    }
                } else {
                    LOG.trace("Don't need to execute flush");
                    event.setFlushRequired(false);
                    actionQueue.clearFromFlushNeededCheck(oldSize);
                }
            }
        }
        finally {
            source.getEventListenerManager().partialFlushEnd(event.getNumberOfEntitiesProcessed(), event.getNumberOfEntitiesProcessed());
        }
    }

    private boolean flushIsReallyNeeded(AutoFlushEvent event, EventSource source) {
        return source.getHibernateFlushMode() == FlushMode.ALWAYS || source.getActionQueue().areTablesToBeUpdated(event.getQuerySpaces());
    }

    private boolean flushMightBeNeeded(EventSource source) {
        return !source.getHibernateFlushMode().lessThan(FlushMode.AUTO) && source.getDontFlushFromFind() == 0 && (source.getPersistenceContext().getNumberOfManagedEntities() > 0 || source.getPersistenceContext().getCollectionEntries().size() > 0);
    }
}

