/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import java.io.Serializable;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.persistence.PersistenceException;
import org.hibernate.Cache;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.cache.internal.CacheDataDescriptionImpl;
import org.hibernate.cache.internal.StandardQueryCache;
import org.hibernate.cache.spi.CacheDataDescription;
import org.hibernate.cache.spi.CollectionRegion;
import org.hibernate.cache.spi.EntityRegion;
import org.hibernate.cache.spi.NaturalIdRegion;
import org.hibernate.cache.spi.QueryCache;
import org.hibernate.cache.spi.QueryResultsRegion;
import org.hibernate.cache.spi.Region;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cache.spi.TimestampsRegion;
import org.hibernate.cache.spi.UpdateTimestampsCache;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.cache.spi.access.CollectionRegionAccessStrategy;
import org.hibernate.cache.spi.access.EntityRegionAccessStrategy;
import org.hibernate.cache.spi.access.NaturalIdRegionAccessStrategy;
import org.hibernate.engine.spi.CacheImplementor;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;

public class CacheImpl
implements CacheImplementor {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(CacheImpl.class);
    private final SessionFactoryImplementor sessionFactory;
    private final SessionFactoryOptions settings;
    private final transient RegionFactory regionFactory;
    private final String cacheRegionPrefix;
    private final transient ConcurrentHashMap<String, Region> allRegionsMap = new ConcurrentHashMap();
    private final transient ConcurrentHashMap<String, EntityRegionAccessStrategy> entityRegionAccessStrategyMap = new ConcurrentHashMap();
    private final transient ConcurrentHashMap<String, CollectionRegionAccessStrategy> collectionRegionAccessStrategyMap = new ConcurrentHashMap();
    private final transient ConcurrentHashMap<String, NaturalIdRegionAccessStrategy> naturalIdRegionAccessStrategyMap = new ConcurrentHashMap();
    private final transient UpdateTimestampsCache updateTimestampsCache;
    private final transient QueryCache defaultQueryCache;
    private final transient ConcurrentMap<String, QueryCache> queryCaches;

    public CacheImpl(SessionFactoryImplementor sessionFactory) {
        this.sessionFactory = sessionFactory;
        this.settings = sessionFactory.getSessionFactoryOptions();
        this.regionFactory = this.settings.getServiceRegistry().getService(RegionFactory.class);
        this.regionFactory.start(this.settings, sessionFactory.getProperties());
        String string = this.cacheRegionPrefix = StringHelper.isEmpty(sessionFactory.getSessionFactoryOptions().getCacheRegionPrefix()) ? "" : sessionFactory.getSessionFactoryOptions().getCacheRegionPrefix() + ".";
        if (this.settings.isQueryCacheEnabled()) {
            TimestampsRegion timestampsRegion = this.regionFactory.buildTimestampsRegion(this.qualifyRegionName(UpdateTimestampsCache.REGION_NAME), sessionFactory.getProperties());
            this.updateTimestampsCache = new UpdateTimestampsCache(sessionFactory, timestampsRegion);
            QueryResultsRegion queryResultsRegion = this.regionFactory.buildQueryResultsRegion(StandardQueryCache.class.getName(), sessionFactory.getProperties());
            this.defaultQueryCache = this.settings.getQueryCacheFactory().buildQueryCache(queryResultsRegion, this);
            this.queryCaches = new ConcurrentHashMap<String, QueryCache>();
        } else {
            this.updateTimestampsCache = null;
            this.defaultQueryCache = null;
            this.queryCaches = null;
        }
    }

    @Override
    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    @Override
    public RegionFactory getRegionFactory() {
        return this.regionFactory;
    }

    @Override
    public String qualifyRegionName(String regionName) {
        return StringHelper.isEmpty(regionName) ? null : this.cacheRegionPrefix + regionName;
    }

    @Override
    public boolean containsEntity(Class entityClass, Serializable identifier) {
        return this.containsEntity(entityClass.getName(), identifier);
    }

    @Override
    public boolean containsEntity(String entityName, Serializable identifier) {
        EntityPersister p = this.sessionFactory.getMetamodel().entityPersister(entityName);
        if (p.hasCache()) {
            EntityRegionAccessStrategy cache = p.getCacheAccessStrategy();
            Object key = cache.generateCacheKey(identifier, p, this.sessionFactory, null);
            return cache.getRegion().contains(key);
        }
        return false;
    }

    @Override
    public void evictEntity(Class entityClass, Serializable identifier) {
        this.evictEntity(entityClass.getName(), identifier);
    }

    @Override
    public void evictEntity(String entityName, Serializable identifier) {
        EntityPersister p = this.sessionFactory.getMetamodel().entityPersister(entityName);
        if (p.hasCache()) {
            if (LOG.isDebugEnabled()) {
                LOG.debugf("Evicting second-level cache: %s", MessageHelper.infoString(p, identifier, this.sessionFactory));
            }
            EntityRegionAccessStrategy cache = p.getCacheAccessStrategy();
            Object key = cache.generateCacheKey(identifier, p, this.sessionFactory, null);
            cache.evict(key);
        }
    }

    @Override
    public void evictEntityRegion(Class entityClass) {
        this.evictEntityRegion(entityClass.getName());
    }

    @Override
    public void evictEntityRegion(String entityName) {
        EntityPersister p = this.sessionFactory.getMetamodel().entityPersister(entityName);
        if (p.hasCache()) {
            if (LOG.isDebugEnabled()) {
                LOG.debugf("Evicting second-level cache: %s", p.getEntityName());
            }
            p.getCacheAccessStrategy().evictAll();
        }
    }

    @Override
    public void evictEntityRegions() {
        this.sessionFactory.getMetamodel().entityPersisters().keySet().forEach(this::evictEntityRegion);
    }

    @Override
    public void evictNaturalIdRegion(Class entityClass) {
        this.evictNaturalIdRegion(entityClass.getName());
    }

    @Override
    public void evictNaturalIdRegion(String entityName) {
        EntityPersister p = this.sessionFactory.getMetamodel().entityPersister(entityName);
        if (p.hasNaturalIdCache()) {
            if (LOG.isDebugEnabled()) {
                LOG.debugf("Evicting natural-id cache: %s", p.getEntityName());
            }
            p.getNaturalIdCacheAccessStrategy().evictAll();
        }
    }

    @Override
    public void evictNaturalIdRegions() {
        this.sessionFactory.getMetamodel().entityPersisters().keySet().forEach(this::evictNaturalIdRegion);
    }

    @Override
    public boolean containsCollection(String role, Serializable ownerIdentifier) {
        CollectionPersister p = this.sessionFactory.getMetamodel().collectionPersister(role);
        if (p.hasCache()) {
            CollectionRegionAccessStrategy cache = p.getCacheAccessStrategy();
            Object key = cache.generateCacheKey(ownerIdentifier, p, this.sessionFactory, null);
            return cache.getRegion().contains(key);
        }
        return false;
    }

    @Override
    public void evictCollection(String role, Serializable ownerIdentifier) {
        CollectionPersister p = this.sessionFactory.getMetamodel().collectionPersister(role);
        if (p.hasCache()) {
            if (LOG.isDebugEnabled()) {
                LOG.debugf("Evicting second-level cache: %s", MessageHelper.collectionInfoString(p, ownerIdentifier, this.sessionFactory));
            }
            CollectionRegionAccessStrategy cache = p.getCacheAccessStrategy();
            Object key = cache.generateCacheKey(ownerIdentifier, p, this.sessionFactory, null);
            cache.evict(key);
        }
    }

    @Override
    public void evictCollectionRegion(String role) {
        CollectionPersister p = this.sessionFactory.getMetamodel().collectionPersister(role);
        if (p.hasCache()) {
            if (LOG.isDebugEnabled()) {
                LOG.debugf("Evicting second-level cache: %s", p.getRole());
            }
            p.getCacheAccessStrategy().evictAll();
        }
    }

    @Override
    public void evictCollectionRegions() {
        this.sessionFactory.getMetamodel().collectionPersisters().keySet().forEach(this::evictCollectionRegion);
    }

    @Override
    public boolean containsQuery(String regionName) {
        return this.sessionFactory.getSessionFactoryOptions().isQueryCacheEnabled() && this.queryCaches.containsKey(regionName);
    }

    @Override
    public void evictDefaultQueryRegion() {
        if (this.sessionFactory.getSessionFactoryOptions().isQueryCacheEnabled()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Evicting default query region cache.");
            }
            this.getDefaultQueryCache().clear();
        }
    }

    @Override
    public void evictQueryRegion(String regionName) {
        QueryCache namedQueryCache;
        if (regionName == null) {
            throw new NullPointerException("Region-name cannot be null (use Cache#evictDefaultQueryRegion to evict the default query cache)");
        }
        if (this.sessionFactory.getSessionFactoryOptions().isQueryCacheEnabled() && (namedQueryCache = (QueryCache)this.queryCaches.get(regionName)) != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debugf("Evicting query cache, region: %s", regionName);
            }
            namedQueryCache.clear();
        }
    }

    @Override
    public void evictQueryRegions() {
        this.evictDefaultQueryRegion();
        if (CollectionHelper.isEmpty(this.queryCaches)) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Evicting cache of all query regions.");
        }
        this.queryCaches.values().forEach(QueryCache::clear);
    }

    @Override
    public void close() {
        for (EntityRegionAccessStrategy entityRegionAccessStrategy : this.entityRegionAccessStrategyMap.values()) {
            entityRegionAccessStrategy.getRegion().destroy();
        }
        for (CollectionRegionAccessStrategy collectionRegionAccessStrategy : this.collectionRegionAccessStrategyMap.values()) {
            collectionRegionAccessStrategy.getRegion().destroy();
        }
        if (this.settings.isQueryCacheEnabled()) {
            this.defaultQueryCache.destroy();
            for (QueryCache queryCache : this.queryCaches.values()) {
                queryCache.destroy();
            }
            this.updateTimestampsCache.destroy();
        }
        this.regionFactory.stop();
    }

    @Override
    public QueryCache getDefaultQueryCache() {
        return this.defaultQueryCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueryCache getQueryCache(String regionName) throws HibernateException {
        if (!this.settings.isQueryCacheEnabled()) {
            return null;
        }
        if (regionName == null) {
            return this.getDefaultQueryCache();
        }
        QueryCache queryCache = (QueryCache)this.queryCaches.get(regionName);
        if (queryCache == null) {
            ConcurrentMap<String, QueryCache> concurrentMap = this.queryCaches;
            synchronized (concurrentMap) {
                queryCache = (QueryCache)this.queryCaches.get(regionName);
                if (queryCache == null) {
                    QueryResultsRegion region = this.regionFactory.buildQueryResultsRegion(this.qualifyRegionName(regionName), this.sessionFactory.getProperties());
                    queryCache = this.settings.getQueryCacheFactory().buildQueryCache(region, this);
                    this.queryCaches.put(regionName, queryCache);
                }
            }
        }
        return queryCache;
    }

    @Override
    public UpdateTimestampsCache getUpdateTimestampsCache() {
        return this.updateTimestampsCache;
    }

    @Override
    public void evictQueries() throws HibernateException {
        if (this.settings.isQueryCacheEnabled()) {
            this.defaultQueryCache.clear();
        }
    }

    @Override
    public String[] getSecondLevelCacheRegionNames() {
        HashSet<String> names = new HashSet<String>();
        names.addAll(this.entityRegionAccessStrategyMap.keySet());
        names.addAll(this.collectionRegionAccessStrategyMap.keySet());
        names.addAll(this.naturalIdRegionAccessStrategyMap.keySet());
        if (this.settings.isQueryCacheEnabled()) {
            names.add(this.updateTimestampsCache.getRegion().getName());
            names.addAll(this.queryCaches.keySet());
        }
        return ArrayHelper.toStringArray(names);
    }

    @Override
    public EntityRegionAccessStrategy getEntityRegionAccess(String regionName) {
        return this.entityRegionAccessStrategyMap.get(regionName);
    }

    @Override
    public CollectionRegionAccessStrategy getCollectionRegionAccess(String regionName) {
        return this.collectionRegionAccessStrategyMap.get(regionName);
    }

    @Override
    public NaturalIdRegionAccessStrategy getNaturalIdCacheRegionAccessStrategy(String regionName) {
        return this.naturalIdRegionAccessStrategyMap.get(regionName);
    }

    @Override
    public void evictAllRegions() {
        this.evictCollectionRegions();
        this.evictDefaultQueryRegion();
        this.evictEntityRegions();
        this.evictQueryRegions();
        this.evictNaturalIdRegions();
    }

    public boolean contains(Class cls, Object primaryKey) {
        return this.containsEntity(cls, (Serializable)primaryKey);
    }

    public void evict(Class cls, Object primaryKey) {
        this.evictEntity(cls, (Serializable)primaryKey);
    }

    public void evict(Class cls) {
        this.evictEntityRegion(cls);
    }

    public void evictAll() {
        this.evictEntityRegions();
    }

    public <T> T unwrap(Class<T> cls) {
        if (Cache.class.isAssignableFrom(cls)) {
            return (T)this;
        }
        if (RegionFactory.class.isAssignableFrom(cls)) {
            return (T)this.regionFactory;
        }
        throw new PersistenceException("Hibernate cannot unwrap Cache as " + cls.getName());
    }

    @Override
    public EntityRegionAccessStrategy determineEntityRegionAccessStrategy(PersistentClass model) {
        AccessType accessType;
        String cacheRegionName = this.cacheRegionPrefix + model.getRootClass().getCacheRegionName();
        EntityRegionAccessStrategy accessStrategy = this.entityRegionAccessStrategyMap.get(cacheRegionName);
        if (accessStrategy == null && this.settings.isSecondLevelCacheEnabled() && (accessType = AccessType.fromExternalName(model.getCacheConcurrencyStrategy())) != null) {
            LOG.tracef("Building shared cache region for entity data [%s]", model.getEntityName());
            EntityRegion entityRegion = this.regionFactory.buildEntityRegion(cacheRegionName, this.sessionFactory.getProperties(), (CacheDataDescription)CacheDataDescriptionImpl.decode(model));
            accessStrategy = entityRegion.buildAccessStrategy(accessType);
            this.entityRegionAccessStrategyMap.put(cacheRegionName, accessStrategy);
        }
        return accessStrategy;
    }

    @Override
    public NaturalIdRegionAccessStrategy determineNaturalIdRegionAccessStrategy(PersistentClass model) {
        String naturalIdCacheRegionName;
        NaturalIdRegionAccessStrategy naturalIdAccessStrategy = null;
        if (model.hasNaturalId() && model.getNaturalIdCacheRegionName() != null && (naturalIdAccessStrategy = this.naturalIdRegionAccessStrategyMap.get(naturalIdCacheRegionName = this.cacheRegionPrefix + model.getNaturalIdCacheRegionName())) == null && this.settings.isSecondLevelCacheEnabled()) {
            CacheDataDescriptionImpl cacheDataDescription = CacheDataDescriptionImpl.decode(model);
            NaturalIdRegion naturalIdRegion = null;
            try {
                naturalIdRegion = this.regionFactory.buildNaturalIdRegion(naturalIdCacheRegionName, this.sessionFactory.getProperties(), (CacheDataDescription)cacheDataDescription);
            }
            catch (UnsupportedOperationException e) {
                LOG.warnf("Shared cache region factory [%s] does not support natural id caching; shared NaturalId caching will be disabled for not be enabled for %s", this.regionFactory.getClass().getName(), model.getEntityName());
            }
            if (naturalIdRegion != null) {
                naturalIdAccessStrategy = naturalIdRegion.buildAccessStrategy(this.regionFactory.getDefaultAccessType());
                this.naturalIdRegionAccessStrategyMap.put(naturalIdCacheRegionName, naturalIdAccessStrategy);
            }
        }
        return naturalIdAccessStrategy;
    }

    @Override
    public CollectionRegionAccessStrategy determineCollectionRegionAccessStrategy(Collection model) {
        AccessType accessType;
        String cacheRegionName = this.cacheRegionPrefix + model.getCacheRegionName();
        CollectionRegionAccessStrategy accessStrategy = this.collectionRegionAccessStrategyMap.get(cacheRegionName);
        if (accessStrategy == null && this.settings.isSecondLevelCacheEnabled() && (accessType = AccessType.fromExternalName(model.getCacheConcurrencyStrategy())) != null) {
            LOG.tracev("Building shared cache region for collection data [{0}]", model.getRole());
            CollectionRegion collectionRegion = this.regionFactory.buildCollectionRegion(cacheRegionName, this.sessionFactory.getProperties(), (CacheDataDescription)CacheDataDescriptionImpl.decode(model));
            accessStrategy = collectionRegion.buildAccessStrategy(accessType);
            this.collectionRegionAccessStrategyMap.put(cacheRegionName, accessStrategy);
        }
        return accessStrategy;
    }
}

