/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.internal;

import java.io.Serializable;
import org.hibernate.EmptyInterceptor;
import org.hibernate.Interceptor;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.SessionFactory;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.metamodel.SessionFactoryBuilder;
import org.hibernate.metamodel.source.spi.MetadataImplementor;
import org.hibernate.proxy.EntityNotFoundDelegate;

public class SessionFactoryBuilderImpl
implements SessionFactoryBuilder {
    SessionFactoryOptionsImpl options;
    private final MetadataImplementor metadata;

    SessionFactoryBuilderImpl(MetadataImplementor metadata) {
        this.metadata = metadata;
        this.options = new SessionFactoryOptionsImpl();
    }

    @Override
    public SessionFactoryBuilder with(Interceptor interceptor) {
        this.options.interceptor = interceptor;
        return this;
    }

    @Override
    public SessionFactoryBuilder with(EntityNotFoundDelegate entityNotFoundDelegate) {
        this.options.entityNotFoundDelegate = entityNotFoundDelegate;
        return this;
    }

    @Override
    public SessionFactory buildSessionFactory() {
        return new SessionFactoryImpl(this.metadata, this.options, null);
    }

    private static class SessionFactoryOptionsImpl
    implements SessionFactory.SessionFactoryOptions {
        private Interceptor interceptor = EmptyInterceptor.INSTANCE;
        private EntityNotFoundDelegate entityNotFoundDelegate = new EntityNotFoundDelegate(){

            @Override
            public void handleEntityNotFound(String entityName, Serializable id) {
                throw new ObjectNotFoundException(id, entityName);
            }
        };

        private SessionFactoryOptionsImpl() {
        }

        @Override
        public Interceptor getInterceptor() {
            return this.interceptor;
        }

        @Override
        public EntityNotFoundDelegate getEntityNotFoundDelegate() {
            return this.entityNotFoundDelegate;
        }
    }
}

