/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.DuplicateMappingException;
import org.hibernate.MappingException;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.engine.ResultSetMappingDefinition;
import org.hibernate.engine.spi.FilterDefinition;
import org.hibernate.engine.spi.NamedQueryDefinition;
import org.hibernate.engine.spi.NamedSQLQueryDefinition;
import org.hibernate.id.factory.DefaultIdentifierGeneratorFactory;
import org.hibernate.id.factory.IdentifierGeneratorFactory;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.metamodel.Metadata;
import org.hibernate.metamodel.MetadataSources;
import org.hibernate.metamodel.SessionFactoryBuilder;
import org.hibernate.metamodel.SourceProcessingOrder;
import org.hibernate.metamodel.binding.AttributeBinding;
import org.hibernate.metamodel.binding.EntityBinding;
import org.hibernate.metamodel.binding.FetchProfile;
import org.hibernate.metamodel.binding.IdGenerator;
import org.hibernate.metamodel.binding.PluralAttributeBinding;
import org.hibernate.metamodel.binding.SimpleAttributeBinding;
import org.hibernate.metamodel.binding.TypeDef;
import org.hibernate.metamodel.domain.JavaType;
import org.hibernate.metamodel.relational.AuxiliaryDatabaseObject;
import org.hibernate.metamodel.relational.Database;
import org.hibernate.metamodel.source.annotations.AnnotationBinder;
import org.hibernate.metamodel.source.hbm.HbmBinder;
import org.hibernate.metamodel.source.internal.EntityReferenceResolver;
import org.hibernate.metamodel.source.internal.SessionFactoryBuilderImpl;
import org.hibernate.metamodel.source.spi.Binder;
import org.hibernate.metamodel.source.spi.MappingDefaults;
import org.hibernate.metamodel.source.spi.MetaAttributeContext;
import org.hibernate.metamodel.source.spi.MetadataImplementor;
import org.hibernate.service.BasicServiceRegistry;
import org.hibernate.service.classloading.spi.ClassLoaderService;
import org.hibernate.type.Type;
import org.hibernate.type.TypeResolver;
import org.jboss.logging.Logger;

public class MetadataImpl
implements MetadataImplementor,
Serializable {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)MetadataImpl.class.getName());
    private final BasicServiceRegistry serviceRegistry;
    private final Metadata.Options options;
    private ClassLoaderService classLoaderService;
    private TypeResolver typeResolver = new TypeResolver();
    private SessionFactoryBuilder sessionFactoryBuilder = new SessionFactoryBuilderImpl(this);
    private DefaultIdentifierGeneratorFactory identifierGeneratorFactory = new DefaultIdentifierGeneratorFactory();
    private final Database database = new Database();
    private final MappingDefaults mappingDefaults;
    private Map<String, EntityBinding> entityBindingMap = new HashMap<String, EntityBinding>();
    private Map<String, EntityBinding> rootEntityBindingMap = new HashMap<String, EntityBinding>();
    private Map<String, PluralAttributeBinding> collectionBindingMap = new HashMap<String, PluralAttributeBinding>();
    private Map<String, FetchProfile> fetchProfiles = new HashMap<String, FetchProfile>();
    private Map<String, String> imports = new HashMap<String, String>();
    private Map<String, TypeDef> typeDefs = new HashMap<String, TypeDef>();
    private Map<String, IdGenerator> idGenerators = new HashMap<String, IdGenerator>();
    private Map<String, NamedQueryDefinition> namedQueryDefs = new HashMap<String, NamedQueryDefinition>();
    private Map<String, NamedSQLQueryDefinition> namedNativeQueryDefs = new HashMap<String, NamedSQLQueryDefinition>();
    private Map<String, ResultSetMappingDefinition> resultSetMappings = new HashMap<String, ResultSetMappingDefinition>();
    private Map<String, FilterDefinition> filterDefs = new HashMap<String, FilterDefinition>();
    private List<AuxiliaryDatabaseObject> auxiliaryDatabaseObjects = new ArrayList<AuxiliaryDatabaseObject>();
    private final MetaAttributeContext globalMetaAttributeContext = new MetaAttributeContext();
    private static final String DEFAULT_IDENTIFIER_COLUMN_NAME = "id";
    private static final String DEFAULT_DISCRIMINATOR_COLUMN_NAME = "class";
    private static final String DEFAULT_CASCADE = "none";
    private static final String DEFAULT_PROPERTY_ACCESS = "property";

    public MetadataImpl(MetadataSources metadataSources, Metadata.Options options) {
        this.serviceRegistry = metadataSources.getServiceRegistry();
        this.options = options;
        this.mappingDefaults = new MappingDefaultsImpl();
        Binder[] binders = options.getSourceProcessingOrder() == SourceProcessingOrder.HBM_FIRST ? new Binder[]{new HbmBinder(this), new AnnotationBinder(this)} : new Binder[]{new AnnotationBinder(this), new HbmBinder(this)};
        ArrayList<String> processedEntityNames = new ArrayList<String>();
        this.prepare(binders, metadataSources);
        this.bindIndependentMetadata(binders, metadataSources);
        this.bindTypeDependentMetadata(binders, metadataSources);
        this.bindMappingMetadata(binders, metadataSources, processedEntityNames);
        this.bindMappingDependentMetadata(binders, metadataSources);
        new EntityReferenceResolver(this).resolve();
    }

    private void prepare(Binder[] binders, MetadataSources metadataSources) {
        for (Binder binder : binders) {
            binder.prepare(metadataSources);
        }
    }

    private void bindIndependentMetadata(Binder[] binders, MetadataSources metadataSources) {
        for (Binder binder : binders) {
            binder.bindIndependentMetadata(metadataSources);
        }
    }

    private void bindTypeDependentMetadata(Binder[] binders, MetadataSources metadataSources) {
        for (Binder binder : binders) {
            binder.bindTypeDependentMetadata(metadataSources);
        }
    }

    private void bindMappingMetadata(Binder[] binders, MetadataSources metadataSources, List<String> processedEntityNames) {
        for (Binder binder : binders) {
            binder.bindMappingMetadata(metadataSources, processedEntityNames);
        }
    }

    private void bindMappingDependentMetadata(Binder[] binders, MetadataSources metadataSources) {
        for (Binder binder : binders) {
            binder.bindMappingDependentMetadata(metadataSources);
        }
    }

    @Override
    public void addFetchProfile(FetchProfile profile) {
        if (profile == null || profile.getName() == null) {
            throw new IllegalArgumentException("Fetch profile object or name is null: " + profile);
        }
        this.fetchProfiles.put(profile.getName(), profile);
    }

    @Override
    public void addFilterDefinition(FilterDefinition def) {
        if (def == null || def.getFilterName() == null) {
            throw new IllegalArgumentException("Filter definition object or name is null: " + def);
        }
        this.filterDefs.put(def.getFilterName(), def);
    }

    @Override
    public Iterable<FilterDefinition> getFilterDefinitions() {
        return this.filterDefs.values();
    }

    @Override
    public void addIdGenerator(IdGenerator generator) {
        if (generator == null || generator.getName() == null) {
            throw new IllegalArgumentException("ID generator object or name is null.");
        }
        this.idGenerators.put(generator.getName(), generator);
    }

    @Override
    public IdGenerator getIdGenerator(String name) {
        if (name == null) {
            throw new IllegalArgumentException("null is not a valid generator name");
        }
        return this.idGenerators.get(name);
    }

    @Override
    public void registerIdentifierGenerator(String name, String generatorClassName) {
        this.identifierGeneratorFactory.register(name, this.classLoaderService().classForName(generatorClassName));
    }

    @Override
    public void addAuxiliaryDatabaseObject(AuxiliaryDatabaseObject auxiliaryDatabaseObject) {
        if (auxiliaryDatabaseObject == null) {
            throw new IllegalArgumentException("Auxiliary database object is null.");
        }
        this.auxiliaryDatabaseObjects.add(auxiliaryDatabaseObject);
    }

    @Override
    public void addNamedNativeQuery(NamedSQLQueryDefinition def) {
        if (def == null || def.getName() == null) {
            throw new IllegalArgumentException("Named native query definition object or name is null: " + def.getQueryString());
        }
        this.namedNativeQueryDefs.put(def.getName(), def);
    }

    public NamedSQLQueryDefinition getNamedNativeQuery(String name) {
        if (name == null) {
            throw new IllegalArgumentException("null is not a valid native query name");
        }
        return this.namedNativeQueryDefs.get(name);
    }

    @Override
    public Iterable<NamedSQLQueryDefinition> getNamedNativeQueryDefinitions() {
        return this.namedNativeQueryDefs.values();
    }

    @Override
    public void addNamedQuery(NamedQueryDefinition def) {
        if (def == null || def.getName() == null) {
            throw new IllegalArgumentException("Named query definition object or name is null: " + def.getQueryString());
        }
        this.namedQueryDefs.put(def.getName(), def);
    }

    public NamedQueryDefinition getNamedQuery(String name) {
        if (name == null) {
            throw new IllegalArgumentException("null is not a valid query name");
        }
        return this.namedQueryDefs.get(name);
    }

    @Override
    public Iterable<NamedQueryDefinition> getNamedQueryDefinitions() {
        return this.namedQueryDefs.values();
    }

    @Override
    public void addResultSetMapping(ResultSetMappingDefinition resultSetMappingDefinition) {
        if (resultSetMappingDefinition == null || resultSetMappingDefinition.getName() == null) {
            throw new IllegalArgumentException("Resultset mappping object or name is null: " + resultSetMappingDefinition);
        }
        this.resultSetMappings.put(resultSetMappingDefinition.getName(), resultSetMappingDefinition);
    }

    @Override
    public Iterable<ResultSetMappingDefinition> getResultSetMappingDefinitions() {
        return this.resultSetMappings.values();
    }

    @Override
    public void addTypeDefinition(TypeDef typeDef) {
        if (typeDef == null || typeDef.getName() == null) {
            throw new IllegalArgumentException("Type definition object or name is null: " + typeDef.getTypeClass());
        }
        TypeDef previous = this.typeDefs.put(typeDef.getName(), typeDef);
        if (previous != null) {
            LOG.debugf("Duplicate typedef name [%s] now -> %s", typeDef.getName(), typeDef.getTypeClass());
        }
    }

    @Override
    public Iterable<TypeDef> getTypeDefinitions() {
        return this.typeDefs.values();
    }

    public TypeDef getTypeDef(String name) {
        return this.typeDefs.get(name);
    }

    private ClassLoaderService classLoaderService() {
        if (this.classLoaderService == null) {
            this.classLoaderService = this.serviceRegistry.getService(ClassLoaderService.class);
        }
        return this.classLoaderService;
    }

    @Override
    public Metadata.Options getOptions() {
        return this.options;
    }

    @Override
    public SessionFactory buildSessionFactory() {
        return this.sessionFactoryBuilder.buildSessionFactory();
    }

    @Override
    public BasicServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    @Override
    public <T> Class<T> locateClassByName(String name) {
        return this.classLoaderService().classForName(name);
    }

    @Override
    public JavaType makeJavaType(String className) {
        return new JavaType(className, this.classLoaderService());
    }

    @Override
    public Database getDatabase() {
        return this.database;
    }

    @Override
    public EntityBinding getEntityBinding(String entityName) {
        return this.entityBindingMap.get(entityName);
    }

    @Override
    public EntityBinding getRootEntityBinding(String entityName) {
        EntityBinding rootEntityBinding = this.rootEntityBindingMap.get(entityName);
        if (rootEntityBinding == null) {
            EntityBinding entityBinding = this.entityBindingMap.get(entityName);
            if (entityBinding == null) {
                throw new IllegalStateException("Unknown entity binding: " + entityName);
            }
            if (entityBinding.isRoot()) {
                rootEntityBinding = entityBinding;
            } else {
                if (entityBinding.getEntity().getSuperType() == null) {
                    throw new IllegalStateException("Entity binding has no root: " + entityName);
                }
                rootEntityBinding = this.getRootEntityBinding(entityBinding.getEntity().getSuperType().getName());
            }
            this.rootEntityBindingMap.put(entityName, rootEntityBinding);
        }
        return rootEntityBinding;
    }

    @Override
    public Iterable<EntityBinding> getEntityBindings() {
        return this.entityBindingMap.values();
    }

    @Override
    public void addEntity(EntityBinding entityBinding) {
        String entityName = entityBinding.getEntity().getName();
        if (this.entityBindingMap.containsKey(entityName)) {
            throw new DuplicateMappingException(DuplicateMappingException.Type.ENTITY, entityName);
        }
        this.entityBindingMap.put(entityName, entityBinding);
    }

    public PluralAttributeBinding getCollection(String collectionRole) {
        return this.collectionBindingMap.get(collectionRole);
    }

    @Override
    public Iterable<PluralAttributeBinding> getCollectionBindings() {
        return this.collectionBindingMap.values();
    }

    @Override
    public void addCollection(PluralAttributeBinding pluralAttributeBinding) {
        String owningEntityName = pluralAttributeBinding.getEntityBinding().getEntity().getName();
        String attributeName = pluralAttributeBinding.getAttribute().getName();
        String collectionRole = owningEntityName + '.' + attributeName;
        if (this.collectionBindingMap.containsKey(collectionRole)) {
            throw new DuplicateMappingException(DuplicateMappingException.Type.ENTITY, collectionRole);
        }
        this.collectionBindingMap.put(collectionRole, pluralAttributeBinding);
    }

    @Override
    public void addImport(String importName, String entityName) {
        if (importName == null || entityName == null) {
            throw new IllegalArgumentException("Import name or entity name is null");
        }
        LOG.trace("Import: " + importName + " -> " + entityName);
        String old = this.imports.put(importName, entityName);
        if (old != null) {
            LOG.debug("import name [" + importName + "] overrode previous [{" + old + "}]");
        }
    }

    @Override
    public Iterable<Map.Entry<String, String>> getImports() {
        return this.imports.entrySet();
    }

    public Iterable<FetchProfile> getFetchProfiles() {
        return this.fetchProfiles.values();
    }

    @Override
    public TypeResolver getTypeResolver() {
        return this.typeResolver;
    }

    @Override
    public SessionFactoryBuilder getSessionFactoryBuilder() {
        return this.sessionFactoryBuilder;
    }

    @Override
    public NamingStrategy getNamingStrategy() {
        return this.options.getNamingStrategy();
    }

    @Override
    public MappingDefaults getMappingDefaults() {
        return this.mappingDefaults;
    }

    @Override
    public MetaAttributeContext getMetaAttributeContext() {
        return this.globalMetaAttributeContext;
    }

    @Override
    public MetadataImplementor getMetadataImplementor() {
        return this;
    }

    @Override
    public IdentifierGeneratorFactory getIdentifierGeneratorFactory() {
        return this.identifierGeneratorFactory;
    }

    @Override
    public Type getIdentifierType(String entityName) throws MappingException {
        EntityBinding entityBinding = this.getEntityBinding(entityName);
        if (entityBinding == null) {
            throw new MappingException("Entity binding not known: " + entityName);
        }
        return entityBinding.getEntityIdentifier().getValueBinding().getHibernateTypeDescriptor().getExplicitType();
    }

    @Override
    public String getIdentifierPropertyName(String entityName) throws MappingException {
        EntityBinding entityBinding = this.getEntityBinding(entityName);
        if (entityBinding == null) {
            throw new MappingException("Entity binding not known: " + entityName);
        }
        SimpleAttributeBinding idBinding = entityBinding.getEntityIdentifier().getValueBinding();
        return idBinding == null ? null : idBinding.getAttribute().getName();
    }

    @Override
    public Type getReferencedPropertyType(String entityName, String propertyName) throws MappingException {
        EntityBinding entityBinding = this.getEntityBinding(entityName);
        if (entityBinding == null) {
            throw new MappingException("Entity binding not known: " + entityName);
        }
        AttributeBinding attributeBinding = entityBinding.getAttributeBinding(propertyName);
        if (attributeBinding == null) {
            throw new MappingException("unknown property: " + entityName + '.' + propertyName);
        }
        return attributeBinding.getHibernateTypeDescriptor().getExplicitType();
    }

    private class MappingDefaultsImpl
    implements MappingDefaults {
        private MappingDefaultsImpl() {
        }

        @Override
        public String getPackageName() {
            return null;
        }

        @Override
        public String getSchemaName() {
            return MetadataImpl.this.options.getDefaultSchemaName();
        }

        @Override
        public String getCatalogName() {
            return MetadataImpl.this.options.getDefaultCatalogName();
        }

        @Override
        public String getIdColumnName() {
            return MetadataImpl.DEFAULT_IDENTIFIER_COLUMN_NAME;
        }

        @Override
        public String getDiscriminatorColumnName() {
            return MetadataImpl.DEFAULT_DISCRIMINATOR_COLUMN_NAME;
        }

        @Override
        public String getCascadeStyle() {
            return MetadataImpl.DEFAULT_CASCADE;
        }

        @Override
        public String getPropertyAccessorName() {
            return MetadataImpl.DEFAULT_PROPERTY_ACCESS;
        }

        @Override
        public boolean areAssociationsLazy() {
            return true;
        }
    }
}

