/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.hbm.state.binding;

import java.util.HashSet;
import java.util.Set;
import org.hibernate.EntityMode;
import org.hibernate.MappingException;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.metamodel.binding.Caching;
import org.hibernate.metamodel.binding.CustomSQL;
import org.hibernate.metamodel.binding.InheritanceType;
import org.hibernate.metamodel.binding.state.EntityBindingState;
import org.hibernate.metamodel.domain.Hierarchical;
import org.hibernate.metamodel.source.hbm.HbmBindingContext;
import org.hibernate.metamodel.source.hbm.HbmHelper;
import org.hibernate.metamodel.source.hbm.util.MappingHelper;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLCacheElement;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLHibernateMapping;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLSqlDeleteElement;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLSqlInsertElement;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLSqlUpdateElement;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLSynchronizeElement;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLTuplizerElement;
import org.hibernate.metamodel.source.spi.MetaAttributeContext;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.tuple.entity.EntityTuplizer;

public class HbmEntityBindingState
implements EntityBindingState {
    private final String entityName;
    private final EntityMode entityMode;
    private final String className;
    private final String proxyInterfaceName;
    private final Class<EntityPersister> entityPersisterClass;
    private final Class<EntityTuplizer> tuplizerClass;
    private final MetaAttributeContext metaAttributeContext;
    private final Hierarchical superType;
    private final boolean isRoot;
    private final InheritanceType entityInheritanceType;
    private final Caching caching;
    private final boolean lazy;
    private final boolean mutable;
    private final boolean explicitPolymorphism;
    private final String whereFilter;
    private final String rowId;
    private final boolean dynamicUpdate;
    private final boolean dynamicInsert;
    private final int batchSize;
    private final boolean selectBeforeUpdate;
    private final int optimisticLockMode;
    private final Boolean isAbstract;
    private final CustomSQL customInsert;
    private final CustomSQL customUpdate;
    private final CustomSQL customDelete;
    private final Set<String> synchronizedTableNames;

    public HbmEntityBindingState(Hierarchical superType, XMLHibernateMapping.XMLClass entityClazz, boolean isRoot, InheritanceType inheritanceType, HbmBindingContext bindingContext) {
        this.superType = superType;
        this.entityName = bindingContext.extractEntityName(entityClazz);
        String verbatimClassName = entityClazz.getName();
        EntityMode entityMode = this.entityMode = verbatimClassName == null ? EntityMode.MAP : EntityMode.POJO;
        if (this.entityMode == EntityMode.POJO) {
            this.className = bindingContext.getClassName(verbatimClassName);
            this.proxyInterfaceName = entityClazz.getProxy();
        } else {
            this.className = null;
            this.proxyInterfaceName = null;
        }
        String customTuplizerClassName = this.extractCustomTuplizerClassName(entityClazz, this.entityMode);
        this.tuplizerClass = customTuplizerClassName != null ? bindingContext.locateClassByName(customTuplizerClassName) : null;
        this.isRoot = isRoot;
        this.entityInheritanceType = inheritanceType;
        this.caching = HbmEntityBindingState.createCaching(entityClazz, bindingContext.extractEntityName(entityClazz));
        this.metaAttributeContext = HbmHelper.extractMetaAttributeContext(entityClazz.getMeta(), true, bindingContext.getMetaAttributeContext());
        this.lazy = MappingHelper.getBooleanValue(entityClazz.isLazy(), bindingContext.getMappingDefaults().areAssociationsLazy());
        this.mutable = entityClazz.isMutable();
        this.explicitPolymorphism = "explicit".equals(entityClazz.getPolymorphism());
        this.whereFilter = entityClazz.getWhere();
        this.rowId = entityClazz.getRowid();
        this.dynamicUpdate = entityClazz.isDynamicUpdate();
        this.dynamicInsert = entityClazz.isDynamicInsert();
        this.batchSize = MappingHelper.getIntValue(entityClazz.getBatchSize(), 0);
        this.selectBeforeUpdate = entityClazz.isSelectBeforeUpdate();
        this.optimisticLockMode = this.getOptimisticLockMode();
        this.entityPersisterClass = entityClazz.getPersister() == null ? null : bindingContext.locateClassByName(entityClazz.getPersister());
        XMLSqlInsertElement sqlInsert = entityClazz.getSqlInsert();
        this.customInsert = sqlInsert != null ? HbmHelper.getCustomSql(sqlInsert.getValue(), sqlInsert.isCallable(), sqlInsert.getCheck().value()) : null;
        XMLSqlDeleteElement sqlDelete = entityClazz.getSqlDelete();
        this.customDelete = sqlDelete != null ? HbmHelper.getCustomSql(sqlDelete.getValue(), sqlDelete.isCallable(), sqlDelete.getCheck().value()) : null;
        XMLSqlUpdateElement sqlUpdate = entityClazz.getSqlUpdate();
        this.customUpdate = sqlUpdate != null ? HbmHelper.getCustomSql(sqlUpdate.getValue(), sqlUpdate.isCallable(), sqlUpdate.getCheck().value()) : null;
        if (entityClazz.getSynchronize() != null) {
            this.synchronizedTableNames = new HashSet<String>(entityClazz.getSynchronize().size());
            for (XMLSynchronizeElement synchronize : entityClazz.getSynchronize()) {
                this.synchronizedTableNames.add(synchronize.getTable());
            }
        } else {
            this.synchronizedTableNames = null;
        }
        this.isAbstract = entityClazz.isAbstract();
    }

    private String extractCustomTuplizerClassName(XMLHibernateMapping.XMLClass entityClazz, EntityMode entityMode) {
        if (entityClazz.getTuplizer() == null) {
            return null;
        }
        for (XMLTuplizerElement tuplizerElement : entityClazz.getTuplizer()) {
            if (entityMode != EntityMode.parse(tuplizerElement.getEntityMode())) continue;
            return tuplizerElement.getClazz();
        }
        return null;
    }

    private static Caching createCaching(XMLHibernateMapping.XMLClass entityClazz, String entityName) {
        XMLCacheElement cache = entityClazz.getCache();
        if (cache == null) {
            return null;
        }
        String region = cache.getRegion() != null ? cache.getRegion() : entityName;
        AccessType accessType = Enum.valueOf(AccessType.class, cache.getUsage());
        boolean cacheLazyProps = !"non-lazy".equals(cache.getInclude());
        return new Caching(region, accessType, cacheLazyProps);
    }

    private static int createOptimisticLockMode(XMLHibernateMapping.XMLClass entityClazz) {
        int optimisticLockMode;
        String optimisticLockModeString = MappingHelper.getStringValue(entityClazz.getOptimisticLock(), "version");
        if ("version".equals(optimisticLockModeString)) {
            optimisticLockMode = 0;
        } else if ("dirty".equals(optimisticLockModeString)) {
            optimisticLockMode = 1;
        } else if ("all".equals(optimisticLockModeString)) {
            optimisticLockMode = 2;
        } else if ("none".equals(optimisticLockModeString)) {
            optimisticLockMode = -1;
        } else {
            throw new MappingException("Unsupported optimistic-lock style: " + optimisticLockModeString);
        }
        return optimisticLockMode;
    }

    @Override
    public String getEntityName() {
        return this.entityName;
    }

    @Override
    public String getJpaEntityName() {
        return null;
    }

    @Override
    public EntityMode getEntityMode() {
        return this.entityMode;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public String getProxyInterfaceName() {
        return this.proxyInterfaceName;
    }

    @Override
    public Class<EntityPersister> getCustomEntityPersisterClass() {
        return this.entityPersisterClass;
    }

    @Override
    public Class<EntityTuplizer> getCustomEntityTuplizerClass() {
        return this.tuplizerClass;
    }

    @Override
    public Hierarchical getSuperType() {
        return this.superType;
    }

    @Override
    public boolean isRoot() {
        return this.isRoot;
    }

    @Override
    public InheritanceType getEntityInheritanceType() {
        return this.entityInheritanceType;
    }

    @Override
    public Caching getCaching() {
        return this.caching;
    }

    @Override
    public MetaAttributeContext getMetaAttributeContext() {
        return this.metaAttributeContext;
    }

    @Override
    public boolean isLazy() {
        return this.lazy;
    }

    @Override
    public boolean isMutable() {
        return this.mutable;
    }

    @Override
    public boolean isExplicitPolymorphism() {
        return this.explicitPolymorphism;
    }

    @Override
    public String getWhereFilter() {
        return this.whereFilter;
    }

    @Override
    public String getRowId() {
        return this.rowId;
    }

    @Override
    public boolean isDynamicUpdate() {
        return this.dynamicUpdate;
    }

    @Override
    public boolean isDynamicInsert() {
        return this.dynamicInsert;
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    @Override
    public boolean isSelectBeforeUpdate() {
        return this.selectBeforeUpdate;
    }

    @Override
    public int getOptimisticLockMode() {
        return this.optimisticLockMode;
    }

    @Override
    public Boolean isAbstract() {
        return this.isAbstract;
    }

    @Override
    public CustomSQL getCustomInsert() {
        return this.customInsert;
    }

    @Override
    public CustomSQL getCustomUpdate() {
        return this.customUpdate;
    }

    @Override
    public CustomSQL getCustomDelete() {
        return this.customDelete;
    }

    @Override
    public Set<String> getSynchronizedTableNames() {
        return this.synchronizedTableNames;
    }
}

