/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.hbm;

import org.hibernate.InvalidMappingException;
import org.hibernate.MappingException;
import org.hibernate.metamodel.binding.EntityBinding;
import org.hibernate.metamodel.binding.InheritanceType;
import org.hibernate.metamodel.relational.Identifier;
import org.hibernate.metamodel.relational.InLineView;
import org.hibernate.metamodel.relational.Schema;
import org.hibernate.metamodel.relational.Table;
import org.hibernate.metamodel.relational.state.ValueRelationalState;
import org.hibernate.metamodel.source.hbm.AbstractEntityBinder;
import org.hibernate.metamodel.source.hbm.HbmBindingContext;
import org.hibernate.metamodel.source.hbm.state.binding.HbmDiscriminatorBindingState;
import org.hibernate.metamodel.source.hbm.state.binding.HbmSimpleAttributeBindingState;
import org.hibernate.metamodel.source.hbm.state.relational.HbmSimpleValueRelationalStateContainer;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLHibernateMapping;
import org.hibernate.metamodel.source.spi.BindingContext;

class RootEntityBinder
extends AbstractEntityBinder {
    RootEntityBinder(HbmBindingContext bindingContext, XMLHibernateMapping.XMLClass xmlClazz) {
        super(bindingContext, xmlClazz);
    }

    @Override
    public boolean isRoot() {
        return true;
    }

    @Override
    public InheritanceType getInheritanceType() {
        return InheritanceType.SINGLE_TABLE;
    }

    public void process(XMLHibernateMapping.XMLClass xmlClazz) {
        String entityName = this.getBindingContext().extractEntityName(xmlClazz);
        if (entityName == null) {
            throw new MappingException("Unable to determine entity name");
        }
        EntityBinding entityBinding = new EntityBinding();
        this.basicEntityBinding(xmlClazz, entityBinding, null);
        this.basicTableBinding(xmlClazz, entityBinding);
        this.bindIdentifier(xmlClazz, entityBinding);
        this.bindDiscriminator(xmlClazz, entityBinding);
        this.bindVersionOrTimestamp(xmlClazz, entityBinding);
        this.buildAttributeBindings(xmlClazz, entityBinding);
        this.getMetadata().addEntity(entityBinding);
    }

    private void basicTableBinding(XMLHibernateMapping.XMLClass xmlClazz, EntityBinding entityBinding) {
        String subSelect;
        Schema schema = this.getMetadata().getDatabase().getSchema(this.getSchemaName());
        String string = subSelect = xmlClazz.getSubselectAttribute() == null ? xmlClazz.getSubselect() : xmlClazz.getSubselectAttribute();
        if (subSelect != null) {
            String logicalName = entityBinding.getEntity().getName();
            InLineView inLineView = schema.getInLineView(logicalName);
            if (inLineView == null) {
                inLineView = schema.createInLineView(logicalName, subSelect);
            }
            entityBinding.setBaseTable(inLineView);
        } else {
            String check;
            Identifier tableName = Identifier.toIdentifier(this.getClassTableName(xmlClazz, entityBinding, null));
            Table table = schema.getTable(tableName);
            if (table == null) {
                table = schema.createTable(tableName);
            }
            entityBinding.setBaseTable(table);
            String comment = xmlClazz.getComment();
            if (comment != null) {
                table.addComment(comment.trim());
            }
            if ((check = xmlClazz.getCheck()) != null) {
                table.addCheckConstraint(check);
            }
        }
    }

    private void bindIdentifier(XMLHibernateMapping.XMLClass xmlClazz, EntityBinding entityBinding) {
        if (xmlClazz.getId() != null) {
            this.bindSimpleId(xmlClazz.getId(), entityBinding);
            return;
        }
        if (xmlClazz.getCompositeId() != null) {
            RootEntityBinder.bindCompositeId(xmlClazz.getCompositeId(), entityBinding);
        }
        throw new InvalidMappingException("Entity [" + entityBinding.getEntity().getName() + "] did not contain identifier mapping", this.getBindingContext().getOrigin());
    }

    private void bindSimpleId(XMLHibernateMapping.XMLClass.XMLId id, EntityBinding entityBinding) {
        HbmSimpleAttributeBindingState bindingState = new HbmSimpleAttributeBindingState(entityBinding.getEntity().getJavaType().getName(), (BindingContext)this.getBindingContext(), entityBinding.getMetaAttributeContext(), id);
        HbmSimpleValueRelationalStateContainer relationalStateContainer = new HbmSimpleValueRelationalStateContainer((BindingContext)this.getBindingContext(), true, id);
        if (relationalStateContainer.getRelationalStates().size() > 1) {
            throw new MappingException("ID is expected to be a single column, but has more than 1 value");
        }
        entityBinding.getEntity().getOrCreateSingularAttribute(bindingState.getAttributeName());
        entityBinding.makeSimpleIdAttributeBinding(bindingState.getAttributeName()).initialize(bindingState).initialize(relationalStateContainer.getRelationalStates().get(0));
    }

    private static void bindCompositeId(XMLHibernateMapping.XMLClass.XMLCompositeId compositeId, EntityBinding entityBinding) {
        String explicitName = compositeId.getName();
    }

    private void bindDiscriminator(XMLHibernateMapping.XMLClass xmlEntityClazz, EntityBinding entityBinding) {
        if (xmlEntityClazz.getDiscriminator() == null) {
            return;
        }
        HbmDiscriminatorBindingState bindingState = new HbmDiscriminatorBindingState(entityBinding.getEntity().getJavaType().getName(), entityBinding.getEntity().getName(), this.getBindingContext(), xmlEntityClazz);
        ValueRelationalState relationalState = RootEntityBinder.convertToSimpleValueRelationalStateIfPossible(new HbmSimpleValueRelationalStateContainer((BindingContext)this.getBindingContext(), true, xmlEntityClazz.getDiscriminator()));
        entityBinding.getEntity().getOrCreateSingularAttribute(bindingState.getAttributeName());
        entityBinding.makeEntityDiscriminator(bindingState.getAttributeName()).initialize(bindingState).initialize(relationalState);
    }

    private void bindVersionOrTimestamp(XMLHibernateMapping.XMLClass xmlEntityClazz, EntityBinding entityBinding) {
        if (xmlEntityClazz.getVersion() != null) {
            this.bindVersion(xmlEntityClazz.getVersion(), entityBinding);
        } else if (xmlEntityClazz.getTimestamp() != null) {
            this.bindTimestamp(xmlEntityClazz.getTimestamp(), entityBinding);
        }
    }

    protected void bindVersion(XMLHibernateMapping.XMLClass.XMLVersion version, EntityBinding entityBinding) {
        HbmSimpleAttributeBindingState bindingState = new HbmSimpleAttributeBindingState(entityBinding.getEntity().getJavaType().getName(), (BindingContext)this.getBindingContext(), entityBinding.getMetaAttributeContext(), version);
        ValueRelationalState relationalState = RootEntityBinder.convertToSimpleValueRelationalStateIfPossible(new HbmSimpleValueRelationalStateContainer((BindingContext)this.getBindingContext(), true, version));
        entityBinding.getEntity().getOrCreateSingularAttribute(bindingState.getAttributeName());
        entityBinding.makeVersionBinding(bindingState.getAttributeName()).initialize(bindingState).initialize(relationalState);
    }

    protected void bindTimestamp(XMLHibernateMapping.XMLClass.XMLTimestamp timestamp, EntityBinding entityBinding) {
        HbmSimpleAttributeBindingState bindingState = new HbmSimpleAttributeBindingState(entityBinding.getEntity().getJavaType().getName(), (BindingContext)this.getBindingContext(), entityBinding.getMetaAttributeContext(), timestamp);
        ValueRelationalState relationalState = RootEntityBinder.convertToSimpleValueRelationalStateIfPossible(new HbmSimpleValueRelationalStateContainer((BindingContext)this.getBindingContext(), true, timestamp));
        entityBinding.makeVersionBinding(bindingState.getAttributeName()).initialize(bindingState).initialize(relationalState);
    }
}

