/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.hbm;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.metamodel.MetadataSources;
import org.hibernate.metamodel.source.hbm.HibernateMappingProcessor;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLHibernateMapping;
import org.hibernate.metamodel.source.internal.JaxbRoot;
import org.hibernate.metamodel.source.spi.Binder;
import org.hibernate.metamodel.source.spi.MetadataImplementor;

public class HbmBinder
implements Binder {
    private final MetadataImplementor metadata;
    private List<HibernateMappingProcessor> processors;

    public HbmBinder(MetadataImplementor metadata) {
        this.metadata = metadata;
    }

    @Override
    public void prepare(MetadataSources sources) {
        this.processors = new ArrayList<HibernateMappingProcessor>();
        for (JaxbRoot jaxbRoot : sources.getJaxbRootList()) {
            if (!(jaxbRoot.getRoot() instanceof XMLHibernateMapping)) continue;
            this.processors.add(new HibernateMappingProcessor(this.metadata, jaxbRoot));
        }
    }

    @Override
    public void bindIndependentMetadata(MetadataSources sources) {
        for (HibernateMappingProcessor processor : this.processors) {
            processor.bindIndependentMetadata();
        }
    }

    @Override
    public void bindTypeDependentMetadata(MetadataSources sources) {
        for (HibernateMappingProcessor processor : this.processors) {
            processor.bindTypeDependentMetadata();
        }
    }

    @Override
    public void bindMappingMetadata(MetadataSources sources, List<String> processedEntityNames) {
        for (HibernateMappingProcessor processor : this.processors) {
            processor.bindMappingMetadata(processedEntityNames);
        }
    }

    @Override
    public void bindMappingDependentMetadata(MetadataSources sources) {
        for (HibernateMappingProcessor processor : this.processors) {
            processor.bindMappingDependentMetadata();
        }
    }
}

