/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations.entity.state.binding;

import java.util.HashSet;
import java.util.Set;
import org.hibernate.EntityMode;
import org.hibernate.annotations.OptimisticLockType;
import org.hibernate.metamodel.binding.Caching;
import org.hibernate.metamodel.binding.CustomSQL;
import org.hibernate.metamodel.binding.InheritanceType;
import org.hibernate.metamodel.binding.state.EntityBindingState;
import org.hibernate.metamodel.domain.Hierarchical;
import org.hibernate.metamodel.source.annotations.entity.ConfiguredClass;
import org.hibernate.metamodel.source.spi.MetaAttributeContext;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.tuple.entity.EntityTuplizer;

public class EntityBindingStateImpl
implements EntityBindingState {
    private String entityName;
    private final String className;
    private String proxyInterfaceName;
    private final Hierarchical superType;
    private final boolean isRoot;
    private final InheritanceType inheritanceType;
    private Caching caching;
    private boolean mutable;
    private boolean explicitPolymorphism;
    private String whereFilter;
    private String rowId;
    private boolean dynamicUpdate;
    private boolean dynamicInsert;
    private int batchSize;
    private boolean selectBeforeUpdate;
    private OptimisticLockType optimisticLock;
    private Class<EntityPersister> persisterClass;
    private boolean lazy;
    private CustomSQL customInsert;
    private CustomSQL customUpdate;
    private CustomSQL customDelete;
    private Set<String> synchronizedTableNames;

    public EntityBindingStateImpl(Hierarchical superType, ConfiguredClass configuredClass) {
        this.className = configuredClass.getName();
        this.superType = superType;
        this.isRoot = configuredClass.isRoot();
        this.inheritanceType = configuredClass.getInheritanceType();
        this.synchronizedTableNames = new HashSet<String>();
        this.batchSize = -1;
    }

    @Override
    public String getJpaEntityName() {
        return this.entityName;
    }

    public void setJpaEntityName(String entityName) {
        this.entityName = entityName;
    }

    @Override
    public EntityMode getEntityMode() {
        return EntityMode.POJO;
    }

    @Override
    public String getEntityName() {
        return this.className;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public Class<EntityTuplizer> getCustomEntityTuplizerClass() {
        return null;
    }

    @Override
    public Hierarchical getSuperType() {
        return this.superType;
    }

    public void setCaching(Caching caching) {
        this.caching = caching;
    }

    public void setMutable(boolean mutable) {
        this.mutable = mutable;
    }

    public void setExplicitPolymorphism(boolean explicitPolymorphism) {
        this.explicitPolymorphism = explicitPolymorphism;
    }

    public void setWhereFilter(String whereFilter) {
        this.whereFilter = whereFilter;
    }

    public void setDynamicUpdate(boolean dynamicUpdate) {
        this.dynamicUpdate = dynamicUpdate;
    }

    public void setDynamicInsert(boolean dynamicInsert) {
        this.dynamicInsert = dynamicInsert;
    }

    public void setSelectBeforeUpdate(boolean selectBeforeUpdate) {
        this.selectBeforeUpdate = selectBeforeUpdate;
    }

    public void setOptimisticLock(OptimisticLockType optimisticLock) {
        this.optimisticLock = optimisticLock;
    }

    public void setPersisterClass(Class<EntityPersister> persisterClass) {
        this.persisterClass = persisterClass;
    }

    public void setLazy(boolean lazy) {
        this.lazy = lazy;
    }

    public void setProxyInterfaceName(String proxyInterfaceName) {
        this.proxyInterfaceName = proxyInterfaceName;
    }

    public void setRowId(String rowId) {
        this.rowId = rowId;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void addSynchronizedTableName(String tableName) {
        this.synchronizedTableNames.add(tableName);
    }

    public void setCustomInsert(CustomSQL customInsert) {
        this.customInsert = customInsert;
    }

    public void setCustomUpdate(CustomSQL customUpdate) {
        this.customUpdate = customUpdate;
    }

    public void setCustomDelete(CustomSQL customDelete) {
        this.customDelete = customDelete;
    }

    @Override
    public boolean isRoot() {
        return this.isRoot;
    }

    @Override
    public InheritanceType getEntityInheritanceType() {
        return this.inheritanceType;
    }

    @Override
    public Caching getCaching() {
        return this.caching;
    }

    @Override
    public MetaAttributeContext getMetaAttributeContext() {
        return null;
    }

    @Override
    public String getProxyInterfaceName() {
        return this.proxyInterfaceName;
    }

    @Override
    public boolean isLazy() {
        return this.lazy;
    }

    @Override
    public boolean isMutable() {
        return this.mutable;
    }

    @Override
    public boolean isExplicitPolymorphism() {
        return this.explicitPolymorphism;
    }

    @Override
    public String getWhereFilter() {
        return this.whereFilter;
    }

    @Override
    public String getRowId() {
        return this.rowId;
    }

    @Override
    public boolean isDynamicUpdate() {
        return this.dynamicUpdate;
    }

    @Override
    public boolean isDynamicInsert() {
        return this.dynamicInsert;
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    @Override
    public boolean isSelectBeforeUpdate() {
        return this.selectBeforeUpdate;
    }

    @Override
    public int getOptimisticLockMode() {
        return this.optimisticLock.ordinal();
    }

    public Class getCustomEntityPersisterClass() {
        return this.persisterClass;
    }

    @Override
    public Boolean isAbstract() {
        return false;
    }

    @Override
    public CustomSQL getCustomInsert() {
        return this.customInsert;
    }

    @Override
    public CustomSQL getCustomUpdate() {
        return this.customUpdate;
    }

    @Override
    public CustomSQL getCustomDelete() {
        return this.customDelete;
    }

    @Override
    public Set<String> getSynchronizedTableNames() {
        return this.synchronizedTableNames;
    }
}

