/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations.entity;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.AssertionFailure;
import org.hibernate.metamodel.source.annotations.HibernateDotNames;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;

public abstract class MappedAttribute
implements Comparable<MappedAttribute> {
    private final Map<DotName, List<AnnotationInstance>> annotations;
    private final String name;
    private final Map<String, String> typeParameters;
    private final String type;

    MappedAttribute(String name, String type, Map<DotName, List<AnnotationInstance>> annotations) {
        this.annotations = annotations;
        this.name = name;
        this.typeParameters = new HashMap<String, String>();
        this.type = this.determineType(type, this.typeParameters);
    }

    public String getName() {
        return this.name;
    }

    public final String getType() {
        return this.type;
    }

    public Map<String, String> getTypeParameters() {
        return this.typeParameters;
    }

    public final AnnotationInstance getIfExists(DotName annotationDotName) {
        if (this.annotations.containsKey(annotationDotName)) {
            List<AnnotationInstance> instanceList = this.annotations.get(annotationDotName);
            if (instanceList.size() > 1) {
                throw new AssertionFailure("There cannot be more than one @" + annotationDotName.toString() + " annotation per mapped attribute");
            }
            return instanceList.get(0);
        }
        return null;
    }

    @Override
    public int compareTo(MappedAttribute mappedProperty) {
        return this.name.compareTo(mappedProperty.getName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MappedAttribute");
        sb.append("{type='").append(this.type).append('\'');
        sb.append(", typeParameters=").append(this.typeParameters);
        sb.append(", name='").append(this.name).append('\'');
        sb.append('}');
        return sb.toString();
    }

    private String determineType(String type, Map<String, String> typeParameters) {
        AnnotationInstance typeAnnotation = this.getIfExists(HibernateDotNames.TYPE);
        if (typeAnnotation == null) {
            return type;
        }
        AnnotationValue parameterAnnotationValue = typeAnnotation.value("parameters");
        if (parameterAnnotationValue != null) {
            AnnotationInstance[] parameterAnnotations;
            for (AnnotationInstance parameterAnnotationInstance : parameterAnnotations = parameterAnnotationValue.asNestedArray()) {
                typeParameters.put(parameterAnnotationInstance.value("name").asString(), parameterAnnotationInstance.value("value").asString());
            }
        }
        return typeAnnotation.value("type").asString();
    }
}

