/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations.entity;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.GenerationType;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.MappingException;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.OptimisticLockType;
import org.hibernate.annotations.PolymorphismType;
import org.hibernate.annotations.ResultCheckStyle;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.engine.spi.ExecuteUpdateResultCheckStyle;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.binding.Caching;
import org.hibernate.metamodel.binding.CustomSQL;
import org.hibernate.metamodel.binding.EntityBinding;
import org.hibernate.metamodel.binding.EntityDiscriminator;
import org.hibernate.metamodel.binding.IdGenerator;
import org.hibernate.metamodel.binding.ManyToOneAttributeBinding;
import org.hibernate.metamodel.binding.SimpleAttributeBinding;
import org.hibernate.metamodel.domain.Hierarchical;
import org.hibernate.metamodel.relational.Identifier;
import org.hibernate.metamodel.relational.Schema;
import org.hibernate.metamodel.relational.Table;
import org.hibernate.metamodel.relational.TableSpecification;
import org.hibernate.metamodel.relational.UniqueKey;
import org.hibernate.metamodel.source.annotations.HibernateDotNames;
import org.hibernate.metamodel.source.annotations.JPADotNames;
import org.hibernate.metamodel.source.annotations.entity.AssociationAttribute;
import org.hibernate.metamodel.source.annotations.entity.ConfiguredClass;
import org.hibernate.metamodel.source.annotations.entity.DiscriminatorColumnValues;
import org.hibernate.metamodel.source.annotations.entity.MappedAttribute;
import org.hibernate.metamodel.source.annotations.entity.SimpleAttribute;
import org.hibernate.metamodel.source.annotations.entity.state.binding.AttributeBindingStateImpl;
import org.hibernate.metamodel.source.annotations.entity.state.binding.DiscriminatorBindingStateImpl;
import org.hibernate.metamodel.source.annotations.entity.state.binding.EntityBindingStateImpl;
import org.hibernate.metamodel.source.annotations.entity.state.binding.ManyToOneBindingStateImpl;
import org.hibernate.metamodel.source.annotations.entity.state.relational.ColumnRelationalStateImpl;
import org.hibernate.metamodel.source.annotations.entity.state.relational.ManyToOneRelationalStateImpl;
import org.hibernate.metamodel.source.annotations.entity.state.relational.TupleRelationalStateImpl;
import org.hibernate.metamodel.source.annotations.global.IdGeneratorBinder;
import org.hibernate.metamodel.source.annotations.util.JandexHelper;
import org.hibernate.metamodel.source.spi.MetadataImplementor;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;

public class EntityBinder {
    private final ConfiguredClass configuredClass;
    private final MetadataImplementor meta;
    private Schema.Name schemaName;

    public EntityBinder(MetadataImplementor metadata, ConfiguredClass configuredClass) {
        this.configuredClass = configuredClass;
        this.meta = metadata;
    }

    public void bind() {
        EntityBinding entityBinding = new EntityBinding();
        EntityBindingStateImpl entityBindingState = new EntityBindingStateImpl(this.getSuperType(), this.configuredClass);
        this.bindJpaEntityAnnotation(entityBindingState);
        this.bindHibernateEntityAnnotation(entityBindingState);
        this.schemaName = this.createSchemaName();
        this.bindTable(entityBinding);
        this.bindWhereFilter(entityBindingState);
        this.bindJpaCaching(entityBindingState);
        this.bindHibernateCaching(entityBindingState);
        this.bindProxy(entityBindingState);
        this.bindSynchronize(entityBindingState);
        this.bindCustomSQL(entityBindingState);
        this.bindRowId(entityBindingState);
        this.bindBatchSize(entityBindingState);
        entityBinding.initialize(this.meta, entityBindingState);
        this.bindInheritance(entityBinding);
        if (this.configuredClass.isRoot()) {
            this.bindId(entityBinding);
        }
        this.bindAttributes(entityBinding);
        this.bindTableUniqueConstraints(entityBinding);
        this.meta.addEntity(entityBinding);
    }

    private void bindTableUniqueConstraints(EntityBinding entityBinding) {
        AnnotationInstance tableAnnotation = JandexHelper.getSingleAnnotation(this.configuredClass.getClassInfo(), JPADotNames.TABLE);
        if (tableAnnotation == null) {
            return;
        }
        TableSpecification table = entityBinding.getBaseTable();
        this.bindUniqueConstraints(tableAnnotation, table);
    }

    private void bindUniqueConstraints(AnnotationInstance tableAnnotation, TableSpecification table) {
        AnnotationInstance[] uniqueConstraints;
        AnnotationValue value = tableAnnotation.value("uniqueConstraints");
        if (value == null) {
            return;
        }
        for (AnnotationInstance unique : uniqueConstraints = value.asNestedArray()) {
            String name = unique.value("name").asString();
            UniqueKey uniqueKey = table.getOrCreateUniqueKey(name);
            String[] columnNames = unique.value("columnNames").asStringArray();
            if (columnNames.length == 0) {
                // empty if block
            }
            for (String columnName : columnNames) {
                uniqueKey.addColumn(table.getOrCreateColumn(columnName));
            }
        }
    }

    private void bindInheritance(EntityBinding entityBinding) {
        entityBinding.setInheritanceType(this.configuredClass.getInheritanceType());
        switch (this.configuredClass.getInheritanceType()) {
            case SINGLE_TABLE: {
                this.bindDiscriminatorColumn(entityBinding);
                break;
            }
            case JOINED: {
                break;
            }
            case TABLE_PER_CLASS: {
                break;
            }
        }
    }

    private void bindDiscriminatorColumn(EntityBinding entityBinding) {
        Map<DotName, List<AnnotationInstance>> typeAnnotations = JandexHelper.getTypeAnnotations(this.configuredClass.getClassInfo());
        SimpleAttribute discriminatorAttribute = SimpleAttribute.createDiscriminatorAttribute(typeAnnotations);
        this.bindSingleMappedAttribute(entityBinding, discriminatorAttribute);
        if (!(discriminatorAttribute.getColumnValues() instanceof DiscriminatorColumnValues)) {
            throw new AssertionFailure("Expected discriminator column values");
        }
    }

    private void bindWhereFilter(EntityBindingStateImpl entityBindingState) {
        AnnotationInstance whereAnnotation = JandexHelper.getSingleAnnotation(this.configuredClass.getClassInfo(), HibernateDotNames.WHERE);
        if (whereAnnotation != null) {
            String clause = whereAnnotation.value("clause").asString();
            entityBindingState.setWhereFilter(clause);
        }
    }

    private void bindHibernateCaching(EntityBindingStateImpl entityBindingState) {
        AnnotationInstance cacheAnnotation = JandexHelper.getSingleAnnotation(this.configuredClass.getClassInfo(), HibernateDotNames.CACHE);
        if (cacheAnnotation == null) {
            return;
        }
        String region = cacheAnnotation.value("region") != null ? cacheAnnotation.value("region").asString() : entityBindingState.getEntityName();
        boolean cacheLazyProperties = true;
        if (cacheAnnotation.value("include") != null) {
            String tmp = cacheAnnotation.value("include").asString();
            if ("all".equalsIgnoreCase(tmp)) {
                cacheLazyProperties = true;
            } else if ("non-lazy".equalsIgnoreCase(tmp)) {
                cacheLazyProperties = false;
            } else {
                throw new AnnotationException("Unknown lazy property annotations: " + tmp);
            }
        }
        CacheConcurrencyStrategy strategy = CacheConcurrencyStrategy.valueOf(cacheAnnotation.value("usage").asEnum());
        Caching caching = new Caching(region, strategy.toAccessType(), cacheLazyProperties);
        entityBindingState.setCaching(caching);
    }

    private void bindJpaCaching(EntityBindingStateImpl entityBindingState) {
        AnnotationInstance cacheAnnotation = JandexHelper.getSingleAnnotation(this.configuredClass.getClassInfo(), JPADotNames.CACHEABLE);
        boolean cacheable = true;
        if (cacheAnnotation != null && cacheAnnotation.value() != null) {
            cacheable = cacheAnnotation.value().asBoolean();
        }
        Caching caching = null;
        switch (this.meta.getOptions().getSharedCacheMode()) {
            case ALL: {
                caching = this.createCachingForCacheableAnnotation(entityBindingState);
                break;
            }
            case ENABLE_SELECTIVE: {
                if (!cacheable) break;
                caching = this.createCachingForCacheableAnnotation(entityBindingState);
                break;
            }
            case DISABLE_SELECTIVE: {
                if (cacheAnnotation != null && !cacheable) break;
                caching = this.createCachingForCacheableAnnotation(entityBindingState);
                break;
            }
        }
        if (caching != null) {
            entityBindingState.setCaching(caching);
        }
    }

    private void bindProxy(EntityBindingStateImpl entityBindingState) {
        AnnotationInstance proxyAnnotation = JandexHelper.getSingleAnnotation(this.configuredClass.getClassInfo(), HibernateDotNames.PROXY);
        boolean lazy = true;
        String proxyInterfaceClass = null;
        if (proxyAnnotation != null) {
            AnnotationValue proxyClassValue;
            AnnotationValue lazyValue = proxyAnnotation.value("lazy");
            if (lazyValue != null) {
                lazy = lazyValue.asBoolean();
            }
            if ((proxyClassValue = proxyAnnotation.value("proxyClass")) != null) {
                proxyInterfaceClass = proxyClassValue.asString();
            }
        }
        entityBindingState.setLazy(lazy);
        entityBindingState.setProxyInterfaceName(proxyInterfaceClass);
    }

    private void bindSynchronize(EntityBindingStateImpl entityBindingState) {
        AnnotationInstance synchronizeAnnotation = JandexHelper.getSingleAnnotation(this.configuredClass.getClassInfo(), HibernateDotNames.SYNCHRONIZE);
        if (synchronizeAnnotation != null) {
            String[] tableNames;
            for (String tableName : tableNames = synchronizeAnnotation.value().asStringArray()) {
                entityBindingState.addSynchronizedTableName(tableName);
            }
        }
    }

    private void bindCustomSQL(EntityBindingStateImpl entityBindingState) {
        AnnotationInstance sqlInsertAnnotation = JandexHelper.getSingleAnnotation(this.configuredClass.getClassInfo(), HibernateDotNames.SQL_INSERT);
        entityBindingState.setCustomInsert(this.createCustomSQL(sqlInsertAnnotation));
        AnnotationInstance sqlUpdateAnnotation = JandexHelper.getSingleAnnotation(this.configuredClass.getClassInfo(), HibernateDotNames.SQL_UPDATE);
        entityBindingState.setCustomUpdate(this.createCustomSQL(sqlUpdateAnnotation));
        AnnotationInstance sqlDeleteAnnotation = JandexHelper.getSingleAnnotation(this.configuredClass.getClassInfo(), HibernateDotNames.SQL_DELETE);
        entityBindingState.setCustomDelete(this.createCustomSQL(sqlDeleteAnnotation));
        AnnotationInstance sqlDeleteAllAnnotation = JandexHelper.getSingleAnnotation(this.configuredClass.getClassInfo(), HibernateDotNames.SQL_DELETE_ALL);
        if (sqlDeleteAllAnnotation != null) {
            entityBindingState.setCustomDelete(this.createCustomSQL(sqlDeleteAllAnnotation));
        }
    }

    private CustomSQL createCustomSQL(AnnotationInstance customSQLAnnotation) {
        if (customSQLAnnotation == null) {
            return null;
        }
        String sql = customSQLAnnotation.value("sql").asString();
        boolean isCallable = false;
        AnnotationValue callableValue = customSQLAnnotation.value("callable");
        if (callableValue != null) {
            isCallable = callableValue.asBoolean();
        }
        ResultCheckStyle checkStyle = ResultCheckStyle.NONE;
        AnnotationValue checkStyleValue = customSQLAnnotation.value("check");
        if (checkStyleValue != null) {
            checkStyle = Enum.valueOf(ResultCheckStyle.class, checkStyleValue.asEnum());
        }
        return new CustomSQL(sql, isCallable, Enum.valueOf(ExecuteUpdateResultCheckStyle.class, checkStyle.toString()));
    }

    private void bindRowId(EntityBindingStateImpl entityBindingState) {
        AnnotationInstance rowIdAnnotation = JandexHelper.getSingleAnnotation(this.configuredClass.getClassInfo(), HibernateDotNames.ROW_ID);
        if (rowIdAnnotation != null) {
            entityBindingState.setRowId(rowIdAnnotation.value().asString());
        }
    }

    private void bindBatchSize(EntityBindingStateImpl entityBindingState) {
        AnnotationInstance batchSizeAnnotation = JandexHelper.getSingleAnnotation(this.configuredClass.getClassInfo(), HibernateDotNames.BATCH_SIZE);
        if (batchSizeAnnotation != null) {
            entityBindingState.setBatchSize(batchSizeAnnotation.value("size").asInt());
        }
    }

    private Caching createCachingForCacheableAnnotation(EntityBindingStateImpl entityBindingState) {
        String region = entityBindingState.getEntityName();
        RegionFactory regionFactory = this.meta.getServiceRegistry().getService(RegionFactory.class);
        AccessType defaultAccessType = regionFactory.getDefaultAccessType();
        return new Caching(region, defaultAccessType, true);
    }

    private Schema.Name createSchemaName() {
        String schema = null;
        String catalog = null;
        AnnotationInstance tableAnnotation = JandexHelper.getSingleAnnotation(this.configuredClass.getClassInfo(), JPADotNames.TABLE);
        if (tableAnnotation != null) {
            AnnotationValue schemaValue = tableAnnotation.value("schema");
            AnnotationValue catalogValue = tableAnnotation.value("catalog");
            schema = schemaValue != null ? schemaValue.asString() : null;
            catalog = catalogValue != null ? catalogValue.asString() : null;
        }
        return new Schema.Name(schema, catalog);
    }

    private void bindTable(EntityBinding entityBinding) {
        Identifier tableName;
        Schema schema = this.meta.getDatabase().getSchema(this.schemaName);
        Table table = schema.getTable(tableName = Identifier.toIdentifier(this.configuredClass.getPrimaryTableName()));
        if (table == null) {
            table = schema.createTable(tableName);
        }
        entityBinding.setBaseTable(table);
        AnnotationInstance checkAnnotation = JandexHelper.getSingleAnnotation(this.configuredClass.getClassInfo(), HibernateDotNames.CHECK);
        if (checkAnnotation != null) {
            table.addCheckConstraint(checkAnnotation.value("constraints").asString());
        }
    }

    private void bindId(EntityBinding entityBinding) {
        switch (this.configuredClass.getIdType()) {
            case SIMPLE: {
                this.bindSingleIdAnnotation(entityBinding);
                break;
            }
            case COMPOSED: {
                break;
            }
            case EMBEDDED: {
                break;
            }
        }
    }

    private void bindJpaEntityAnnotation(EntityBindingStateImpl entityBindingState) {
        AnnotationInstance jpaEntityAnnotation = JandexHelper.getSingleAnnotation(this.configuredClass.getClassInfo(), JPADotNames.ENTITY);
        String name = jpaEntityAnnotation.value("name") == null ? this.configuredClass.getName() : jpaEntityAnnotation.value("name").asString();
        entityBindingState.setJpaEntityName(name);
    }

    private void bindSingleIdAnnotation(EntityBinding entityBinding) {
        AnnotationInstance idAnnotation = JandexHelper.getSingleAnnotation(this.configuredClass.getClassInfo(), JPADotNames.ID);
        String idName = JandexHelper.getPropertyName(idAnnotation.target());
        MappedAttribute idAttribute = this.configuredClass.getMappedProperty(idName);
        if (!(idAttribute instanceof SimpleAttribute)) {
            throw new AssertionFailure("Unexpected attribute type for id attribute");
        }
        entityBinding.getEntity().getOrCreateSingularAttribute(idName);
        SimpleAttributeBinding attributeBinding = entityBinding.makeSimpleIdAttributeBinding(idName);
        attributeBinding.initialize(new AttributeBindingStateImpl((SimpleAttribute)idAttribute));
        attributeBinding.initialize(new ColumnRelationalStateImpl((SimpleAttribute)idAttribute, this.meta));
        this.bindSingleIdGeneratedValue(entityBinding, idName);
    }

    private void bindSingleIdGeneratedValue(EntityBinding entityBinding, String idPropertyName) {
        AnnotationInstance generatedValueAnn = JandexHelper.getSingleAnnotation(this.configuredClass.getClassInfo(), JPADotNames.GENERATED_VALUE);
        if (generatedValueAnn == null) {
            return;
        }
        String idName = JandexHelper.getPropertyName(generatedValueAnn.target());
        if (!idPropertyName.equals(idName)) {
            throw new AssertionFailure(String.format("Attribute[%s.%s] with @GeneratedValue doesn't have a @Id.", this.configuredClass.getName(), idPropertyName));
        }
        String generator = JandexHelper.getValueAsString(generatedValueAnn, "generator");
        IdGenerator idGenerator = null;
        if (StringHelper.isNotEmpty(generator)) {
            idGenerator = this.meta.getIdGenerator(generator);
            if (idGenerator == null) {
                throw new MappingException(String.format("@GeneratedValue on %s.%s refering an undefined generator [%s]", this.configuredClass.getName(), idName, generator));
            }
            entityBinding.getEntityIdentifier().setIdGenerator(idGenerator);
        }
        GenerationType generationType = JandexHelper.getValueAsEnum(generatedValueAnn, "strategy", GenerationType.class);
        String strategy = IdGeneratorBinder.generatorType(generationType, this.meta.getOptions().useNewIdentifierGenerators());
        if (idGenerator != null && !strategy.equals(idGenerator.getStrategy())) {
            throw new MappingException(String.format("Inconsistent Id Generation strategy of @GeneratedValue on %s.%s", this.configuredClass.getName(), idName));
        }
        idGenerator = new IdGenerator("NAME", strategy, new HashMap<String, String>());
        entityBinding.getEntityIdentifier().setIdGenerator(idGenerator);
    }

    private void bindAttributes(EntityBinding entityBinding) {
        for (MappedAttribute mappedAttribute : this.configuredClass.getMappedAttributes()) {
            if (mappedAttribute instanceof AssociationAttribute) {
                this.bindAssociationAttribute(entityBinding, (AssociationAttribute)mappedAttribute);
                continue;
            }
            this.bindSingleMappedAttribute(entityBinding, (SimpleAttribute)mappedAttribute);
        }
    }

    private void bindAssociationAttribute(EntityBinding entityBinding, AssociationAttribute associationAttribute) {
        switch (associationAttribute.getAssociationType()) {
            case MANY_TO_ONE: {
                entityBinding.getEntity().getOrCreateSingularAttribute(associationAttribute.getName());
                ManyToOneAttributeBinding manyToOneAttributeBinding = entityBinding.makeManyToOneAttributeBinding(associationAttribute.getName());
                ManyToOneBindingStateImpl bindingState = new ManyToOneBindingStateImpl(associationAttribute);
                manyToOneAttributeBinding.initialize(bindingState);
                ManyToOneRelationalStateImpl relationalState = new ManyToOneRelationalStateImpl();
                if (this.configuredClass.hasOwnTable()) {
                    ColumnRelationalStateImpl columnRelationsState = new ColumnRelationalStateImpl(associationAttribute, this.meta);
                    relationalState.addValueState(columnRelationsState);
                }
                manyToOneAttributeBinding.initialize(relationalState);
                break;
            }
        }
    }

    private void bindSingleMappedAttribute(EntityBinding entityBinding, SimpleAttribute simpleAttribute) {
        AttributeBindingStateImpl bindingState;
        SimpleAttributeBinding attributeBinding;
        if (simpleAttribute.isId()) {
            return;
        }
        String attributeName = simpleAttribute.getName();
        entityBinding.getEntity().getOrCreateSingularAttribute(attributeName);
        if (simpleAttribute.isDiscriminator()) {
            EntityDiscriminator entityDiscriminator = entityBinding.makeEntityDiscriminator(attributeName);
            DiscriminatorBindingStateImpl bindingState2 = new DiscriminatorBindingStateImpl(simpleAttribute);
            entityDiscriminator.initialize(bindingState2);
            attributeBinding = entityDiscriminator.getValueBinding();
        } else if (simpleAttribute.isVersioned()) {
            attributeBinding = entityBinding.makeVersionBinding(attributeName);
            bindingState = new AttributeBindingStateImpl(simpleAttribute);
            attributeBinding.initialize(bindingState);
        } else {
            attributeBinding = entityBinding.makeSimpleAttributeBinding(attributeName);
            bindingState = new AttributeBindingStateImpl(simpleAttribute);
            attributeBinding.initialize(bindingState);
        }
        if (this.configuredClass.hasOwnTable()) {
            ColumnRelationalStateImpl columnRelationsState = new ColumnRelationalStateImpl(simpleAttribute, this.meta);
            TupleRelationalStateImpl relationalState = new TupleRelationalStateImpl();
            relationalState.addValueState(columnRelationsState);
            attributeBinding.initialize(relationalState);
        }
    }

    private void bindHibernateEntityAnnotation(EntityBindingStateImpl entityBindingState) {
        AnnotationInstance immutableAnnotation;
        boolean mutable = true;
        boolean dynamicInsert = false;
        boolean dynamicUpdate = false;
        boolean selectBeforeUpdate = false;
        PolymorphismType polymorphism = PolymorphismType.IMPLICIT;
        OptimisticLockType optimisticLock = OptimisticLockType.VERSION;
        AnnotationInstance hibernateEntityAnnotation = JandexHelper.getSingleAnnotation(this.configuredClass.getClassInfo(), HibernateDotNames.ENTITY);
        if (hibernateEntityAnnotation != null) {
            if (hibernateEntityAnnotation.value("mutable") != null) {
                mutable = hibernateEntityAnnotation.value("mutable").asBoolean();
            }
            if (hibernateEntityAnnotation.value("dynamicInsert") != null) {
                dynamicInsert = hibernateEntityAnnotation.value("dynamicInsert").asBoolean();
            }
            if (hibernateEntityAnnotation.value("dynamicUpdate") != null) {
                dynamicUpdate = hibernateEntityAnnotation.value("dynamicUpdate").asBoolean();
            }
            if (hibernateEntityAnnotation.value("selectBeforeUpdate") != null) {
                selectBeforeUpdate = hibernateEntityAnnotation.value("selectBeforeUpdate").asBoolean();
            }
            if (hibernateEntityAnnotation.value("polymorphism") != null) {
                polymorphism = PolymorphismType.valueOf(hibernateEntityAnnotation.value("polymorphism").asEnum());
            }
            if (hibernateEntityAnnotation.value("optimisticLock") != null) {
                optimisticLock = OptimisticLockType.valueOf(hibernateEntityAnnotation.value("optimisticLock").asEnum());
            }
            if (hibernateEntityAnnotation.value("persister") != null) {
                String persisterClassName = hibernateEntityAnnotation.value("persister").toString();
                entityBindingState.setPersisterClass(this.meta.locateClassByName(persisterClassName));
            }
        }
        if ((immutableAnnotation = JandexHelper.getSingleAnnotation(this.configuredClass.getClassInfo(), HibernateDotNames.IMMUTABLE)) != null) {
            mutable = false;
        }
        entityBindingState.setMutable(mutable);
        entityBindingState.setDynamicInsert(dynamicInsert);
        entityBindingState.setDynamicUpdate(dynamicUpdate);
        entityBindingState.setSelectBeforeUpdate(selectBeforeUpdate);
        entityBindingState.setExplicitPolymorphism(PolymorphismType.EXPLICIT.equals((Object)polymorphism));
        entityBindingState.setOptimisticLock(optimisticLock);
    }

    private Hierarchical getSuperType() {
        ConfiguredClass parent = this.configuredClass.getParent();
        if (parent == null) {
            return null;
        }
        EntityBinding parentBinding = this.meta.getEntityBinding(parent.getName());
        if (parentBinding == null) {
            throw new AssertionFailure("Parent entity " + parent.getName() + " of entity " + this.configuredClass.getName() + " not yet created!");
        }
        return parentBinding.getEntity();
    }
}

