/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations.entity;

import com.fasterxml.classmate.ResolvedTypeWithMembers;
import com.fasterxml.classmate.members.HierarchicType;
import com.fasterxml.classmate.members.ResolvedMember;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.AccessType;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.metamodel.binding.InheritanceType;
import org.hibernate.metamodel.source.annotations.JPADotNames;
import org.hibernate.metamodel.source.annotations.entity.AnnotationBindingContext;
import org.hibernate.metamodel.source.annotations.entity.AssociationAttribute;
import org.hibernate.metamodel.source.annotations.entity.AttributeType;
import org.hibernate.metamodel.source.annotations.entity.ConfiguredClassType;
import org.hibernate.metamodel.source.annotations.entity.IdType;
import org.hibernate.metamodel.source.annotations.entity.MappedAttribute;
import org.hibernate.metamodel.source.annotations.entity.SimpleAttribute;
import org.hibernate.metamodel.source.annotations.util.JandexHelper;
import org.hibernate.metamodel.source.annotations.util.ReflectionHelper;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;

public class ConfiguredClass {
    private final ConfiguredClass parent;
    private final ClassInfo classInfo;
    private final Class<?> clazz;
    private final boolean isRoot;
    private final AccessType classAccessType;
    private final AccessType hierarchyAccessType;
    private final InheritanceType inheritanceType;
    private final boolean hasOwnTable;
    private final String primaryTableName;
    private final ConfiguredClassType configuredClassType;
    private final IdType idType;
    private final Map<String, MappedAttribute> mappedAttributes;
    private final Set<String> transientFieldNames = new HashSet<String>();
    private final Set<String> transientMethodNames = new HashSet<String>();
    private final AnnotationBindingContext context;

    public ConfiguredClass(ClassInfo info, ConfiguredClass parent, AccessType hierarchyAccessType, InheritanceType inheritanceType, ResolvedTypeWithMembers resolvedType, AnnotationBindingContext context) {
        this.context = context;
        this.classInfo = info;
        this.parent = parent;
        this.isRoot = parent == null;
        this.hierarchyAccessType = hierarchyAccessType;
        this.inheritanceType = inheritanceType;
        this.clazz = context.classLoaderService().classForName(info.toString());
        this.configuredClassType = this.determineType();
        this.classAccessType = this.determineClassAccessType();
        this.idType = this.determineIdType();
        this.hasOwnTable = this.definesItsOwnTable();
        this.primaryTableName = this.determinePrimaryTableName();
        this.findTransientFieldAndMethodNames();
        List<MappedAttribute> simpleProps = this.collectAttributes(resolvedType);
        Collections.sort(simpleProps);
        LinkedHashMap<String, MappedAttribute> tmpMap = new LinkedHashMap<String, MappedAttribute>();
        for (MappedAttribute property : simpleProps) {
            tmpMap.put(property.getName(), property);
        }
        this.mappedAttributes = Collections.unmodifiableMap(tmpMap);
    }

    public String getName() {
        return this.clazz.getName();
    }

    public ClassInfo getClassInfo() {
        return this.classInfo;
    }

    public ConfiguredClass getParent() {
        return this.parent;
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public ConfiguredClassType getConfiguredClassType() {
        return this.configuredClassType;
    }

    public InheritanceType getInheritanceType() {
        return this.inheritanceType;
    }

    public IdType getIdType() {
        return this.idType;
    }

    public boolean hasOwnTable() {
        return this.hasOwnTable;
    }

    public String getPrimaryTableName() {
        return this.primaryTableName;
    }

    public Iterable<MappedAttribute> getMappedAttributes() {
        return this.mappedAttributes.values();
    }

    public MappedAttribute getMappedProperty(String propertyName) {
        return this.mappedAttributes.get(propertyName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ConfiguredClass");
        sb.append("{clazz=").append(this.clazz.getSimpleName());
        sb.append(", type=").append((Object)this.configuredClassType);
        sb.append(", classAccessType=").append(this.classAccessType);
        sb.append(", isRoot=").append(this.isRoot);
        sb.append(", inheritanceType=").append((Object)this.inheritanceType);
        sb.append('}');
        return sb.toString();
    }

    private ConfiguredClassType determineType() {
        AnnotationInstance entityAnnotation = JandexHelper.getSingleAnnotation(this.classInfo, JPADotNames.ENTITY);
        if (entityAnnotation != null) {
            return ConfiguredClassType.ENTITY;
        }
        AnnotationInstance mappedSuperClassAnnotation = JandexHelper.getSingleAnnotation(this.classInfo, JPADotNames.MAPPED_SUPERCLASS);
        if (mappedSuperClassAnnotation != null) {
            return ConfiguredClassType.MAPPED_SUPERCLASS;
        }
        AnnotationInstance embeddableAnnotation = JandexHelper.getSingleAnnotation(this.classInfo, JPADotNames.EMBEDDABLE);
        if (embeddableAnnotation != null) {
            return ConfiguredClassType.EMBEDDABLE;
        }
        return ConfiguredClassType.NON_ENTITY;
    }

    private AccessType determineClassAccessType() {
        AccessType accessType = this.hierarchyAccessType;
        AnnotationInstance accessAnnotation = JandexHelper.getSingleAnnotation(this.classInfo, JPADotNames.ACCESS);
        if (accessAnnotation != null) {
            accessType = JandexHelper.getValueAsEnum(accessAnnotation, "value", AccessType.class);
        }
        return accessType;
    }

    private List<MappedAttribute> collectAttributes(ResolvedTypeWithMembers resolvedTypes) {
        ResolvedTypeWithMembers resolvedType = null;
        for (HierarchicType hierarchicType : resolvedTypes.allTypesAndOverrides()) {
            if (!hierarchicType.getType().getErasedType().equals(this.clazz)) continue;
            resolvedType = ReflectionHelper.resolveMemberTypes(hierarchicType.getType());
            break;
        }
        if (resolvedType == null) {
            throw new AssertionFailure("Unable to resolve types for " + this.clazz.getName());
        }
        ArrayList<MappedAttribute> properties = new ArrayList<MappedAttribute>();
        Set<String> explicitlyConfiguredMemberNames = this.createExplicitlyConfiguredAccessProperties(properties, resolvedType);
        if (AccessType.FIELD.equals((Object)this.classAccessType)) {
            AccessibleObject[] fields = this.clazz.getDeclaredFields();
            Field.setAccessible(fields, true);
            for (AccessibleObject field : fields) {
                if (!this.isPersistentMember(this.transientFieldNames, explicitlyConfiguredMemberNames, (Member)((Object)field))) continue;
                properties.add(this.createMappedProperty((Member)((Object)field), resolvedType));
            }
        } else {
            AccessibleObject[] methods = this.clazz.getDeclaredMethods();
            Method.setAccessible(methods, true);
            for (AccessibleObject method : methods) {
                if (!this.isPersistentMember(this.transientMethodNames, explicitlyConfiguredMemberNames, (Member)((Object)method))) continue;
                properties.add(this.createMappedProperty((Member)((Object)method), resolvedType));
            }
        }
        return properties;
    }

    private boolean isPersistentMember(Set<String> transientNames, Set<String> explicitlyConfiguredMemberNames, Member member) {
        if (!ReflectionHelper.isProperty(member)) {
            return false;
        }
        if (transientNames.contains(member.getName())) {
            return false;
        }
        return !explicitlyConfiguredMemberNames.contains(member.getName());
    }

    private Set<String> createExplicitlyConfiguredAccessProperties(List<MappedAttribute> mappedProperties, ResolvedTypeWithMembers resolvedMembers) {
        HashSet<String> explicitAccessMembers = new HashSet<String>();
        List accessAnnotations = (List)this.classInfo.annotations().get(JPADotNames.ACCESS);
        if (accessAnnotations == null) {
            return explicitAccessMembers;
        }
        for (AnnotationInstance accessAnnotation : accessAnnotations) {
            AccessibleObject member;
            AnnotationTarget annotationTarget = accessAnnotation.target();
            if (!annotationTarget.getClass().equals(MethodInfo.class) && !annotationTarget.getClass().equals(FieldInfo.class)) continue;
            AccessType accessType = JandexHelper.getValueAsEnum(accessAnnotation, "value", AccessType.class);
            if (AccessType.FIELD.equals((Object)this.classAccessType) && (!(annotationTarget instanceof MethodInfo) || !AccessType.PROPERTY.equals((Object)accessType)) || AccessType.PROPERTY.equals((Object)this.classAccessType) && (!(annotationTarget instanceof FieldInfo) || !AccessType.FIELD.equals((Object)accessType))) continue;
            if (annotationTarget instanceof MethodInfo) {
                Method m;
                try {
                    m = this.clazz.getMethod(((MethodInfo)annotationTarget).name(), new Class[0]);
                }
                catch (NoSuchMethodException e) {
                    throw new HibernateException("Unable to load method " + ((MethodInfo)annotationTarget).name() + " of class " + this.clazz.getName());
                }
                member = m;
            } else {
                Field f;
                try {
                    f = this.clazz.getField(((FieldInfo)annotationTarget).name());
                }
                catch (NoSuchFieldException e) {
                    throw new HibernateException("Unable to load field " + ((FieldInfo)annotationTarget).name() + " of class " + this.clazz.getName());
                }
                member = f;
            }
            if (!ReflectionHelper.isProperty((Member)((Object)member))) continue;
            mappedProperties.add(this.createMappedProperty((Member)((Object)member), resolvedMembers));
            explicitAccessMembers.add(member.getName());
        }
        return explicitAccessMembers;
    }

    private MappedAttribute createMappedProperty(Member member, ResolvedTypeWithMembers resolvedType) {
        SimpleAttribute attribute;
        String name = ReflectionHelper.getPropertyName(member);
        Object[] resolvedMembers = member instanceof Field ? resolvedType.getMemberFields() : resolvedType.getMemberMethods();
        Type type = this.findResolvedType(member.getName(), (ResolvedMember[])resolvedMembers);
        Map<DotName, List<AnnotationInstance>> annotations = JandexHelper.getMemberAnnotations(this.classInfo, member.getName());
        AttributeType attributeType = this.determineAttributeType(annotations);
        switch (attributeType) {
            case BASIC: {
                attribute = SimpleAttribute.createSimpleAttribute(name, ((Class)type).getName(), annotations);
                break;
            }
            case EMBEDDED: {
                throw new HibernateException("foo");
            }
            default: {
                attribute = AssociationAttribute.createAssociationAttribute(name, ((Class)type).getName(), attributeType, annotations);
            }
        }
        return attribute;
    }

    private AttributeType determineAttributeType(Map<DotName, List<AnnotationInstance>> annotations) {
        AnnotationInstance embedded;
        AnnotationInstance manyToMany;
        AnnotationInstance manyToOne;
        AnnotationInstance oneToMany;
        EnumMap<AttributeType, AnnotationInstance> discoveredAttributeTypes = new EnumMap<AttributeType, AnnotationInstance>(AttributeType.class);
        AnnotationInstance oneToOne = JandexHelper.getSingleAnnotation(annotations, JPADotNames.ONE_TO_ONE);
        if (oneToOne != null) {
            discoveredAttributeTypes.put(AttributeType.ONE_TO_ONE, oneToOne);
        }
        if ((oneToMany = JandexHelper.getSingleAnnotation(annotations, JPADotNames.ONE_TO_MANY)) != null) {
            discoveredAttributeTypes.put(AttributeType.ONE_TO_MANY, oneToMany);
        }
        if ((manyToOne = JandexHelper.getSingleAnnotation(annotations, JPADotNames.MANY_TO_ONE)) != null) {
            discoveredAttributeTypes.put(AttributeType.MANY_TO_ONE, manyToOne);
        }
        if ((manyToMany = JandexHelper.getSingleAnnotation(annotations, JPADotNames.MANY_TO_MANY)) != null) {
            discoveredAttributeTypes.put(AttributeType.MANY_TO_MANY, manyToMany);
        }
        if ((embedded = JandexHelper.getSingleAnnotation(annotations, JPADotNames.EMBEDDED)) != null) {
            discoveredAttributeTypes.put(AttributeType.EMBEDDED, embedded);
        }
        if (discoveredAttributeTypes.size() == 0) {
            return AttributeType.BASIC;
        }
        if (discoveredAttributeTypes.size() == 1) {
            return discoveredAttributeTypes.keySet().iterator().next();
        }
        throw new AnnotationException("More than one association type configured for property  " + this.getName() + " of class " + this.getName());
    }

    private Type findResolvedType(String name, ResolvedMember[] resolvedMembers) {
        for (ResolvedMember resolvedMember : resolvedMembers) {
            if (!resolvedMember.getName().equals(name)) continue;
            return resolvedMember.getType().getErasedType();
        }
        return null;
    }

    private void findTransientFieldAndMethodNames() {
        List transientMembers = (List)this.classInfo.annotations().get(JPADotNames.TRANSIENT);
        if (transientMembers == null) {
            return;
        }
        for (AnnotationInstance transientMember : transientMembers) {
            AnnotationTarget target = transientMember.target();
            if (target instanceof FieldInfo) {
                this.transientFieldNames.add(((FieldInfo)target).name());
                continue;
            }
            this.transientMethodNames.add(((MethodInfo)target).name());
        }
    }

    private boolean definesItsOwnTable() {
        if (ConfiguredClassType.MAPPED_SUPERCLASS.equals((Object)this.getConfiguredClassType()) || ConfiguredClassType.EMBEDDABLE.equals((Object)this.getConfiguredClassType())) {
            return false;
        }
        if (InheritanceType.SINGLE_TABLE.equals((Object)this.inheritanceType)) {
            return this.isRoot();
        }
        return true;
    }

    private String determinePrimaryTableName() {
        String tableName = null;
        if (this.hasOwnTable()) {
            tableName = this.clazz.getSimpleName();
            AnnotationInstance tableAnnotation = JandexHelper.getSingleAnnotation(this.classInfo, JPADotNames.TABLE);
            if (tableAnnotation != null) {
                String tmp;
                AnnotationValue value = tableAnnotation.value("name");
                String string = tmp = value == null ? null : value.asString();
                if (tmp != null && !tmp.isEmpty()) {
                    tableName = tmp;
                }
            }
        } else if (this.parent != null && !this.parent.getConfiguredClassType().equals((Object)ConfiguredClassType.MAPPED_SUPERCLASS) && !this.parent.getConfiguredClassType().equals((Object)ConfiguredClassType.EMBEDDABLE)) {
            tableName = this.parent.getPrimaryTableName();
        }
        return tableName;
    }

    private IdType determineIdType() {
        List idAnnotations = (List)this.getClassInfo().annotations().get(JPADotNames.ENTITY);
        List embeddedIdAnnotations = (List)this.getClassInfo().annotations().get(JPADotNames.EMBEDDED_ID);
        if (idAnnotations != null && embeddedIdAnnotations != null) {
            throw new MappingException("@EmbeddedId and @Id cannot be used together. Check the configuration for " + this.getName() + ".");
        }
        if (embeddedIdAnnotations != null) {
            if (embeddedIdAnnotations.size() == 1) {
                return IdType.EMBEDDED;
            }
            throw new AnnotationException("Multiple @EmbeddedId annotations are not allowed");
        }
        if (idAnnotations != null) {
            if (idAnnotations.size() == 1) {
                return IdType.SIMPLE;
            }
            return IdType.COMPOSED;
        }
        return IdType.NONE;
    }
}

