/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.relational.state;

import org.hibernate.MappingException;
import org.hibernate.metamodel.relational.Column;
import org.hibernate.metamodel.relational.DerivedValue;
import org.hibernate.metamodel.relational.SimpleValue;
import org.hibernate.metamodel.relational.TableSpecification;
import org.hibernate.metamodel.relational.Tuple;
import org.hibernate.metamodel.relational.Value;
import org.hibernate.metamodel.relational.state.ColumnRelationalState;
import org.hibernate.metamodel.relational.state.DerivedValueRelationalState;
import org.hibernate.metamodel.relational.state.SimpleValueRelationalState;
import org.hibernate.metamodel.relational.state.TupleRelationalState;
import org.hibernate.metamodel.relational.state.ValueRelationalState;

public class ValueCreator {
    public static Column createColumn(TableSpecification table, String attributeName, ColumnRelationalState state, boolean forceNonNullable, boolean forceUnique) {
        String columnName;
        String explicitName = state.getExplicitColumnName();
        String logicalColumnName = state.getNamingStrategy().logicalColumnName(explicitName, attributeName);
        String string = columnName = explicitName == null ? state.getNamingStrategy().propertyToColumnName(attributeName) : state.getNamingStrategy().columnName(explicitName);
        if (columnName == null) {
            throw new IllegalArgumentException("columnName must be non-null.");
        }
        Column value = table.getOrCreateColumn(columnName);
        value.initialize(state, forceNonNullable, forceUnique);
        return value;
    }

    public static DerivedValue createDerivedValue(TableSpecification table, DerivedValueRelationalState state) {
        return table.getOrCreateDerivedValue(state.getFormula());
    }

    public static SimpleValue createSimpleValue(TableSpecification table, String attributeName, SimpleValueRelationalState state, boolean forceNonNullable, boolean forceUnique) {
        if (state instanceof ColumnRelationalState) {
            ColumnRelationalState columnRelationalState = (ColumnRelationalState)ColumnRelationalState.class.cast(state);
            return ValueCreator.createColumn(table, attributeName, columnRelationalState, forceNonNullable, forceUnique);
        }
        if (state instanceof DerivedValueRelationalState) {
            return ValueCreator.createDerivedValue(table, (DerivedValueRelationalState)DerivedValueRelationalState.class.cast(state));
        }
        throw new MappingException("unknown relational state:" + state.getClass().getName());
    }

    public static Tuple createTuple(TableSpecification table, String attributeName, TupleRelationalState state, boolean forceNonNullable, boolean forceUnique) {
        Tuple tuple = table.createTuple("[" + attributeName + "]");
        for (SimpleValueRelationalState valueState : state.getRelationalStates()) {
            tuple.addValue(ValueCreator.createSimpleValue(table, attributeName, valueState, forceNonNullable, forceUnique));
        }
        return tuple;
    }

    public static Value createValue(TableSpecification table, String attributeName, ValueRelationalState state, boolean forceNonNullable, boolean forceUnique) {
        Value value = null;
        if (SimpleValueRelationalState.class.isInstance(state)) {
            value = ValueCreator.createSimpleValue(table, attributeName, (SimpleValueRelationalState)SimpleValueRelationalState.class.cast(state), forceNonNullable, forceUnique);
        } else if (TupleRelationalState.class.isInstance(state)) {
            value = ValueCreator.createTuple(table, attributeName, (TupleRelationalState)TupleRelationalState.class.cast(state), forceNonNullable, forceUnique);
        } else {
            throw new MappingException("Unexpected type of RelationalState" + state.getClass().getName());
        }
        return value;
    }
}

