/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.binding;

import java.util.Properties;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.factory.IdentifierGeneratorFactory;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.metamodel.binding.EntityBinding;
import org.hibernate.metamodel.binding.IdGenerator;
import org.hibernate.metamodel.binding.SimpleAttributeBinding;
import org.jboss.logging.Logger;

public class EntityIdentifier {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)EntityIdentifier.class.getName());
    private final EntityBinding entityBinding;
    private SimpleAttributeBinding attributeBinding;
    private IdentifierGenerator identifierGenerator;
    private IdGenerator idGenerator;
    private boolean isEmbedded;
    private boolean isIdentifierMapper;

    public EntityIdentifier(EntityBinding entityBinding) {
        this.entityBinding = entityBinding;
    }

    public SimpleAttributeBinding getValueBinding() {
        return this.attributeBinding;
    }

    public void setValueBinding(SimpleAttributeBinding attributeBinding) {
        if (this.attributeBinding != null) {
            LOG.entityIdentifierValueBindingExists(this.entityBinding.getEntity().getName());
        }
        this.attributeBinding = attributeBinding;
    }

    public void setIdGenerator(IdGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    public boolean isEmbedded() {
        return this.isEmbedded;
    }

    public boolean isIdentifierMapper() {
        return this.isIdentifierMapper;
    }

    public IdentifierGenerator createIdentifierGenerator(IdentifierGeneratorFactory factory) {
        if (this.identifierGenerator == null) {
            Properties props = new Properties();
            if (this.idGenerator != null) {
                props.putAll(this.idGenerator.getParameters());
            }
            this.identifierGenerator = factory.createIdentifierGenerator(this.idGenerator.getStrategy(), this.getValueBinding().getHibernateTypeDescriptor().getExplicitType(), props);
        }
        return this.identifierGenerator;
    }

    public IdentifierGenerator getIdentifierGenerator() {
        return this.identifierGenerator;
    }
}

