/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.binding;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.AssertionFailure;
import org.hibernate.EntityMode;
import org.hibernate.MappingException;
import org.hibernate.metamodel.binding.AttributeBinding;
import org.hibernate.metamodel.binding.BagBinding;
import org.hibernate.metamodel.binding.Caching;
import org.hibernate.metamodel.binding.CollectionElementType;
import org.hibernate.metamodel.binding.CustomSQL;
import org.hibernate.metamodel.binding.EntityDiscriminator;
import org.hibernate.metamodel.binding.EntityIdentifier;
import org.hibernate.metamodel.binding.EntityReferencingAttributeBinding;
import org.hibernate.metamodel.binding.InheritanceType;
import org.hibernate.metamodel.binding.ManyToOneAttributeBinding;
import org.hibernate.metamodel.binding.SimpleAttributeBinding;
import org.hibernate.metamodel.binding.state.EntityBindingState;
import org.hibernate.metamodel.domain.Entity;
import org.hibernate.metamodel.domain.JavaType;
import org.hibernate.metamodel.relational.Column;
import org.hibernate.metamodel.relational.TableSpecification;
import org.hibernate.metamodel.source.spi.BindingContext;
import org.hibernate.metamodel.source.spi.MetaAttributeContext;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.tuple.entity.EntityTuplizer;

public class EntityBinding {
    private Entity entity;
    private TableSpecification baseTable;
    private EntityMode entityMode;
    private JavaType proxyInterfaceType;
    private String jpaEntityName;
    private Class<EntityPersister> entityPersisterClass;
    private Class<EntityTuplizer> entityTuplizerClass;
    private boolean isRoot;
    private InheritanceType entityInheritanceType;
    private final EntityIdentifier entityIdentifier = new EntityIdentifier(this);
    private EntityDiscriminator entityDiscriminator;
    private SimpleAttributeBinding versionBinding;
    private Map<String, AttributeBinding> attributeBindingMap = new HashMap<String, AttributeBinding>();
    private Set<EntityReferencingAttributeBinding> entityReferencingAttributeBindings = new HashSet<EntityReferencingAttributeBinding>();
    private Caching caching;
    private MetaAttributeContext metaAttributeContext;
    private boolean lazy;
    private boolean mutable;
    private boolean explicitPolymorphism;
    private String whereFilter;
    private String rowId;
    private boolean dynamicUpdate;
    private boolean dynamicInsert;
    private int batchSize;
    private boolean selectBeforeUpdate;
    private boolean hasSubselectLoadableCollections;
    private int optimisticLockMode;
    private Boolean isAbstract;
    private CustomSQL customInsert;
    private CustomSQL customUpdate;
    private CustomSQL customDelete;
    private Set<String> synchronizedTableNames = new HashSet<String>();
    private String loaderName;

    public EntityBinding initialize(BindingContext bindingContext, EntityBindingState state) {
        this.entity = new Entity(state.getEntityName(), state.getSuperType(), bindingContext.makeJavaType(state.getClassName()));
        this.isRoot = state.isRoot();
        this.entityInheritanceType = state.getEntityInheritanceType();
        this.entityMode = state.getEntityMode();
        this.jpaEntityName = state.getJpaEntityName();
        this.entityPersisterClass = state.getCustomEntityPersisterClass();
        this.entityTuplizerClass = state.getCustomEntityTuplizerClass();
        this.caching = state.getCaching();
        this.metaAttributeContext = state.getMetaAttributeContext();
        if (this.entityMode == EntityMode.POJO) {
            if (state.getProxyInterfaceName() != null) {
                this.proxyInterfaceType = bindingContext.makeJavaType(state.getProxyInterfaceName());
                this.lazy = true;
            } else if (state.isLazy()) {
                this.proxyInterfaceType = this.entity.getJavaType();
                this.lazy = true;
            }
        } else {
            this.proxyInterfaceType = new JavaType(Map.class);
            this.lazy = state.isLazy();
        }
        this.mutable = state.isMutable();
        this.explicitPolymorphism = state.isExplicitPolymorphism();
        this.whereFilter = state.getWhereFilter();
        this.rowId = state.getRowId();
        this.dynamicUpdate = state.isDynamicUpdate();
        this.dynamicInsert = state.isDynamicInsert();
        this.batchSize = state.getBatchSize();
        this.selectBeforeUpdate = state.isSelectBeforeUpdate();
        this.optimisticLockMode = state.getOptimisticLockMode();
        this.isAbstract = state.isAbstract();
        this.customInsert = state.getCustomInsert();
        this.customUpdate = state.getCustomUpdate();
        this.customDelete = state.getCustomDelete();
        if (state.getSynchronizedTableNames() != null) {
            for (String synchronizedTableName : state.getSynchronizedTableNames()) {
                this.addSynchronizedTable(synchronizedTableName);
            }
        }
        return this;
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public void setRoot(boolean isRoot) {
        this.isRoot = isRoot;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public void setEntity(Entity entity) {
        this.entity = entity;
    }

    public TableSpecification getBaseTable() {
        return this.baseTable;
    }

    public void setBaseTable(TableSpecification baseTable) {
        this.baseTable = baseTable;
    }

    public EntityIdentifier getEntityIdentifier() {
        return this.entityIdentifier;
    }

    public void bindEntityIdentifier(SimpleAttributeBinding attributeBinding) {
        if (!Column.class.isInstance(attributeBinding.getValue())) {
            throw new MappingException("Identifier value must be a Column; instead it is: " + attributeBinding.getValue().getClass());
        }
        this.entityIdentifier.setValueBinding(attributeBinding);
        this.baseTable.getPrimaryKey().addColumn((Column)Column.class.cast(attributeBinding.getValue()));
    }

    public EntityDiscriminator getEntityDiscriminator() {
        return this.entityDiscriminator;
    }

    public void setInheritanceType(InheritanceType entityInheritanceType) {
        this.entityInheritanceType = entityInheritanceType;
    }

    public InheritanceType getInheritanceType() {
        return this.entityInheritanceType;
    }

    public boolean isVersioned() {
        return this.versionBinding != null;
    }

    public SimpleAttributeBinding getVersioningValueBinding() {
        return this.versionBinding;
    }

    public Iterable<AttributeBinding> getAttributeBindings() {
        return this.attributeBindingMap.values();
    }

    public AttributeBinding getAttributeBinding(String name) {
        return this.attributeBindingMap.get(name);
    }

    public Iterable<EntityReferencingAttributeBinding> getEntityReferencingAttributeBindings() {
        return this.entityReferencingAttributeBindings;
    }

    public SimpleAttributeBinding makeSimpleIdAttributeBinding(String name) {
        SimpleAttributeBinding binding = this.makeSimpleAttributeBinding(name, true, true);
        this.getEntityIdentifier().setValueBinding(binding);
        return binding;
    }

    public EntityDiscriminator makeEntityDiscriminator(String attributeName) {
        if (this.entityDiscriminator != null) {
            throw new AssertionFailure("Creation of entity discriminator was called more than once");
        }
        this.entityDiscriminator = new EntityDiscriminator();
        this.entityDiscriminator.setValueBinding(this.makeSimpleAttributeBinding(attributeName, true, false));
        return this.entityDiscriminator;
    }

    public SimpleAttributeBinding makeVersionBinding(String attributeName) {
        this.versionBinding = this.makeSimpleAttributeBinding(attributeName, true, false);
        return this.versionBinding;
    }

    public SimpleAttributeBinding makeSimpleAttributeBinding(String name) {
        return this.makeSimpleAttributeBinding(name, false, false);
    }

    private SimpleAttributeBinding makeSimpleAttributeBinding(String name, boolean forceNonNullable, boolean forceUnique) {
        SimpleAttributeBinding binding = new SimpleAttributeBinding(this, forceNonNullable, forceUnique);
        this.registerAttributeBinding(name, binding);
        binding.setAttribute(this.entity.getAttribute(name));
        return binding;
    }

    public ManyToOneAttributeBinding makeManyToOneAttributeBinding(String attributeName) {
        ManyToOneAttributeBinding binding = new ManyToOneAttributeBinding(this);
        this.registerAttributeBinding(attributeName, binding);
        binding.setAttribute(this.entity.getAttribute(attributeName));
        return binding;
    }

    public BagBinding makeBagAttributeBinding(String attributeName, CollectionElementType collectionElementType) {
        BagBinding binding = new BagBinding(this, collectionElementType);
        this.registerAttributeBinding(attributeName, binding);
        binding.setAttribute(this.entity.getAttribute(attributeName));
        return binding;
    }

    private void registerAttributeBinding(String name, EntityReferencingAttributeBinding attributeBinding) {
        this.entityReferencingAttributeBindings.add(attributeBinding);
        this.registerAttributeBinding(name, (AttributeBinding)attributeBinding);
    }

    private void registerAttributeBinding(String name, AttributeBinding attributeBinding) {
        this.attributeBindingMap.put(name, attributeBinding);
    }

    public Caching getCaching() {
        return this.caching;
    }

    public MetaAttributeContext getMetaAttributeContext() {
        return this.metaAttributeContext;
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public boolean isLazy() {
        return this.lazy;
    }

    public void setLazy(boolean lazy) {
        this.lazy = lazy;
    }

    public JavaType getProxyInterfaceType() {
        return this.proxyInterfaceType;
    }

    public String getWhereFilter() {
        return this.whereFilter;
    }

    public boolean isExplicitPolymorphism() {
        return this.explicitPolymorphism;
    }

    public String getRowId() {
        return this.rowId;
    }

    public String getDiscriminatorValue() {
        return this.entityDiscriminator == null ? null : this.entityDiscriminator.getDiscriminatorValue();
    }

    public boolean isDynamicUpdate() {
        return this.dynamicUpdate;
    }

    public boolean isDynamicInsert() {
        return this.dynamicInsert;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public boolean isSelectBeforeUpdate() {
        return this.selectBeforeUpdate;
    }

    public boolean hasSubselectLoadableCollections() {
        return this.hasSubselectLoadableCollections;
    }

    void setSubselectLoadableCollections(boolean hasSubselectLoadableCollections) {
        this.hasSubselectLoadableCollections = hasSubselectLoadableCollections;
    }

    public int getOptimisticLockMode() {
        return this.optimisticLockMode;
    }

    public Class<EntityPersister> getEntityPersisterClass() {
        return this.entityPersisterClass;
    }

    public Class<EntityTuplizer> getEntityTuplizerClass() {
        return this.entityTuplizerClass;
    }

    public Boolean isAbstract() {
        return this.isAbstract;
    }

    protected void addSynchronizedTable(String tableName) {
        this.synchronizedTableNames.add(tableName);
    }

    public Set<String> getSynchronizedTableNames() {
        return this.synchronizedTableNames;
    }

    public String getLoaderName() {
        return this.loaderName;
    }

    public void setLoaderName(String loaderName) {
        this.loaderName = loaderName;
    }

    public CustomSQL getCustomInsert() {
        return this.customInsert;
    }

    public CustomSQL getCustomUpdate() {
        return this.customUpdate;
    }

    public CustomSQL getCustomDelete() {
        return this.customDelete;
    }
}

