/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.proxy;

import java.io.Serializable;
import org.hibernate.HibernateException;
import org.hibernate.LazyInitializationException;
import org.hibernate.SessionException;
import org.hibernate.TransientObjectException;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.proxy.LazyInitializer;

public abstract class AbstractLazyInitializer
implements LazyInitializer {
    private String entityName;
    private Serializable id;
    private Object target;
    private boolean initialized;
    private boolean readOnly;
    private boolean unwrap;
    private transient SessionImplementor session;

    protected AbstractLazyInitializer() {
    }

    protected AbstractLazyInitializer(String entityName, Serializable id, SessionImplementor session) {
        this.entityName = entityName;
        this.id = id;
        if (session == null) {
            session = null;
            this.readOnly = false;
        } else {
            this.setSession(session);
        }
    }

    public final String getEntityName() {
        return this.entityName;
    }

    public final Serializable getIdentifier() {
        return this.id;
    }

    public final void setIdentifier(Serializable id) {
        this.id = id;
    }

    public final boolean isUninitialized() {
        return !this.initialized;
    }

    public final SessionImplementor getSession() {
        return this.session;
    }

    public final void setSession(SessionImplementor s) throws HibernateException {
        if (s != this.session) {
            if (s == null) {
                this.session = null;
                this.readOnly = false;
            } else {
                if (this.isConnectedToSession()) {
                    throw new HibernateException("illegally attempted to associate a proxy with two open Sessions");
                }
                this.session = s;
                this.readOnly = !this.session.getFactory().getEntityPersister(this.entityName).isMutable();
            }
        }
    }

    private static EntityKey generateEntityKeyOrNull(Serializable id, SessionImplementor s, String entityName) {
        if (id == null || s == null || entityName == null) {
            return null;
        }
        return new EntityKey(id, s.getFactory().getEntityPersister(entityName), s.getEntityMode());
    }

    public void unsetSession() {
        this.session = null;
        this.readOnly = false;
    }

    public final void initialize() throws HibernateException {
        if (!this.initialized) {
            if (this.session == null) {
                throw new LazyInitializationException("could not initialize proxy - no Session");
            }
            if (!this.session.isOpen()) {
                throw new LazyInitializationException("could not initialize proxy - the owning Session was closed");
            }
            if (!this.session.isConnected()) {
                throw new LazyInitializationException("could not initialize proxy - the owning Session is disconnected");
            }
            this.target = this.session.immediateLoad(this.entityName, this.id);
            this.initialized = true;
            this.checkTargetState();
        } else {
            this.checkTargetState();
        }
    }

    private void checkTargetState() {
        if (!this.unwrap && this.target == null) {
            this.getSession().getFactory().getEntityNotFoundDelegate().handleEntityNotFound(this.entityName, this.id);
        }
    }

    protected final boolean isConnectedToSession() {
        return this.getProxyOrNull() != null;
    }

    private Object getProxyOrNull() {
        EntityKey entityKey = AbstractLazyInitializer.generateEntityKeyOrNull(this.getIdentifier(), this.session, this.getEntityName());
        if (entityKey != null && this.session != null && this.session.isOpen()) {
            return this.session.getPersistenceContext().getProxy(entityKey);
        }
        return null;
    }

    public final Object getImplementation() {
        this.initialize();
        return this.target;
    }

    public final void setImplementation(Object target) {
        this.target = target;
        this.initialized = true;
    }

    public final Object getImplementation(SessionImplementor s) throws HibernateException {
        EntityKey entityKey = AbstractLazyInitializer.generateEntityKeyOrNull(this.getIdentifier(), s, this.getEntityName());
        return entityKey == null ? null : s.getPersistenceContext().getEntity(entityKey);
    }

    protected final Object getTarget() {
        return this.target;
    }

    public boolean isReadOnly() {
        this.errorIfReadOnlySettingNotAvailable();
        if (!this.isConnectedToSession()) {
            throw new TransientObjectException("The read-only/modifiable setting is only accessible when the proxy is associated with a session.");
        }
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.errorIfReadOnlySettingNotAvailable();
        if (this.readOnly != readOnly) {
            Object proxy = this.getProxyOrNull();
            if (proxy == null) {
                throw new TransientObjectException("Cannot set the read-only/modifiable mode unless the proxy is associated with a session.");
            }
            this.readOnly = readOnly;
            if (this.initialized) {
                this.session.getPersistenceContext().setReadOnly(this.target, readOnly);
            }
        }
    }

    private void errorIfReadOnlySettingNotAvailable() {
        if (this.session == null) {
            throw new TransientObjectException("Proxy is detached (i.e, session is null). The read-only/modifiable setting is only accessible when the proxy is associated with an open session.");
        }
        if (this.session.isClosed()) {
            throw new SessionException("Session is closed. The read-only/modifiable setting is only accessible when the proxy is associated with an open session.");
        }
    }

    public boolean isUnwrap() {
        return this.unwrap;
    }

    public void setUnwrap(boolean unwrap) {
        this.unwrap = unwrap;
    }
}

