/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.ReferenceMap;
import org.hibernate.AssertionFailure;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.MappingException;
import org.hibernate.NonUniqueObjectException;
import org.hibernate.PersistentObjectException;
import org.hibernate.TransientObjectException;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.AssociationKey;
import org.hibernate.engine.BatchFetchQueue;
import org.hibernate.engine.CollectionEntry;
import org.hibernate.engine.CollectionKey;
import org.hibernate.engine.EntityEntry;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.EntityUniqueKey;
import org.hibernate.engine.PersistenceContext;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.Status;
import org.hibernate.engine.loading.LoadContexts;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.tuple.ElementWrapper;
import org.hibernate.util.IdentityMap;
import org.hibernate.util.MarkerObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatefulPersistenceContext
implements PersistenceContext {
    public static final Object NO_ROW = new MarkerObject("NO_ROW");
    private static final Logger log = LoggerFactory.getLogger((Class)StatefulPersistenceContext.class);
    private static final Logger PROXY_WARN_LOG = LoggerFactory.getLogger((String)(StatefulPersistenceContext.class.getName() + ".ProxyWarnLog"));
    private static final int INIT_COLL_SIZE = 8;
    private SessionImplementor session;
    private Map entitiesByKey;
    private Map entitiesByUniqueKey;
    private Map entityEntries;
    private Map proxiesByKey;
    private Map entitySnapshotsByKey;
    private Map arrayHolders;
    private Map collectionEntries;
    private Map collectionsByKey;
    private HashSet nullifiableEntityKeys;
    private HashSet nullAssociations;
    private List nonlazyCollections;
    private Map unownedCollections;
    private Map parentsByChild;
    private int cascading = 0;
    private int loadCounter = 0;
    private boolean flushing = false;
    private boolean hasNonReadOnlyEntities = false;
    private LoadContexts loadContexts;
    private BatchFetchQueue batchFetchQueue;

    public StatefulPersistenceContext(SessionImplementor session) {
        this.session = session;
        this.entitiesByKey = new HashMap(8);
        this.entitiesByUniqueKey = new HashMap(8);
        this.proxiesByKey = new ReferenceMap(0, 2);
        this.entitySnapshotsByKey = new HashMap(8);
        this.entityEntries = IdentityMap.instantiateSequenced(8);
        this.collectionEntries = IdentityMap.instantiateSequenced(8);
        this.collectionsByKey = new HashMap(8);
        this.arrayHolders = IdentityMap.instantiate(8);
        this.parentsByChild = IdentityMap.instantiateSequenced(8);
        this.nullifiableEntityKeys = new HashSet();
        this.initTransientState();
    }

    private void initTransientState() {
        this.nullAssociations = new HashSet(8);
        this.nonlazyCollections = new ArrayList(8);
    }

    public boolean isStateless() {
        return false;
    }

    public SessionImplementor getSession() {
        return this.session;
    }

    public LoadContexts getLoadContexts() {
        if (this.loadContexts == null) {
            this.loadContexts = new LoadContexts(this);
        }
        return this.loadContexts;
    }

    public void addUnownedCollection(CollectionKey key, PersistentCollection collection) {
        if (this.unownedCollections == null) {
            this.unownedCollections = new HashMap(8);
        }
        this.unownedCollections.put(key, collection);
    }

    public PersistentCollection useUnownedCollection(CollectionKey key) {
        if (this.unownedCollections == null) {
            return null;
        }
        return (PersistentCollection)this.unownedCollections.remove(key);
    }

    public BatchFetchQueue getBatchFetchQueue() {
        if (this.batchFetchQueue == null) {
            this.batchFetchQueue = new BatchFetchQueue(this);
        }
        return this.batchFetchQueue;
    }

    public void clear() {
        Iterator itr = this.proxiesByKey.values().iterator();
        while (itr.hasNext()) {
            LazyInitializer li = ((HibernateProxy)itr.next()).getHibernateLazyInitializer();
            li.unsetSession();
        }
        Map.Entry[] collectionEntryArray = IdentityMap.concurrentEntries(this.collectionEntries);
        for (int i = 0; i < collectionEntryArray.length; ++i) {
            ((PersistentCollection)collectionEntryArray[i].getKey()).unsetSession(this.getSession());
        }
        this.arrayHolders.clear();
        this.entitiesByKey.clear();
        this.entitiesByUniqueKey.clear();
        this.entityEntries.clear();
        this.parentsByChild.clear();
        this.entitySnapshotsByKey.clear();
        this.collectionsByKey.clear();
        this.collectionEntries.clear();
        if (this.unownedCollections != null) {
            this.unownedCollections.clear();
        }
        this.proxiesByKey.clear();
        this.nullifiableEntityKeys.clear();
        if (this.batchFetchQueue != null) {
            this.batchFetchQueue.clear();
        }
        this.hasNonReadOnlyEntities = false;
        if (this.loadContexts != null) {
            this.loadContexts.cleanup();
        }
    }

    public boolean hasNonReadOnlyEntities() {
        return this.hasNonReadOnlyEntities;
    }

    public void setEntryStatus(EntityEntry entry, Status status) {
        entry.setStatus(status);
        this.setHasNonReadOnlyEnties(status);
    }

    private void setHasNonReadOnlyEnties(Status status) {
        if (status == Status.DELETED || status == Status.MANAGED || status == Status.SAVING) {
            this.hasNonReadOnlyEntities = true;
        }
    }

    public void afterTransactionCompletion() {
        Iterator iter = this.entityEntries.values().iterator();
        while (iter.hasNext()) {
            ((EntityEntry)iter.next()).setLockMode(LockMode.NONE);
        }
    }

    public Object[] getDatabaseSnapshot(Serializable id, EntityPersister persister) throws HibernateException {
        EntityKey key = new EntityKey(id, persister, this.session.getEntityMode());
        Object cached = this.entitySnapshotsByKey.get(key);
        if (cached != null) {
            return cached == NO_ROW ? null : (Object[])cached;
        }
        Object[] snapshot = persister.getDatabaseSnapshot(id, this.session);
        this.entitySnapshotsByKey.put(key, snapshot == null ? NO_ROW : snapshot);
        return snapshot;
    }

    public Object[] getNaturalIdSnapshot(Serializable id, EntityPersister persister) throws HibernateException {
        if (!persister.hasNaturalIdentifier()) {
            return null;
        }
        int[] props = persister.getNaturalIdentifierProperties();
        boolean[] updateable = persister.getPropertyUpdateability();
        boolean allNatualIdPropsAreUpdateable = true;
        for (int i = 0; i < props.length; ++i) {
            if (updateable[props[i]]) continue;
            allNatualIdPropsAreUpdateable = false;
            break;
        }
        if (allNatualIdPropsAreUpdateable) {
            Object[] entitySnapshot = this.getDatabaseSnapshot(id, persister);
            if (entitySnapshot == NO_ROW) {
                return null;
            }
            Object[] naturalIdSnapshot = new Object[props.length];
            for (int i = 0; i < props.length; ++i) {
                naturalIdSnapshot[i] = entitySnapshot[props[i]];
            }
            return naturalIdSnapshot;
        }
        return persister.getNaturalIdentifierSnapshot(id, this.session);
    }

    public Object[] getCachedDatabaseSnapshot(EntityKey key) {
        Object snapshot = this.entitySnapshotsByKey.get(key);
        if (snapshot == NO_ROW) {
            throw new IllegalStateException("persistence context reported no row snapshot for " + MessageHelper.infoString(key.getEntityName(), key.getIdentifier()));
        }
        return (Object[])snapshot;
    }

    public void addEntity(EntityKey key, Object entity) {
        this.entitiesByKey.put(key, entity);
        this.getBatchFetchQueue().removeBatchLoadableEntityKey(key);
    }

    public Object getEntity(EntityKey key) {
        return this.entitiesByKey.get(key);
    }

    public boolean containsEntity(EntityKey key) {
        return this.entitiesByKey.containsKey(key);
    }

    public Object removeEntity(EntityKey key) {
        Object entity = this.entitiesByKey.remove(key);
        Iterator iter = this.entitiesByUniqueKey.values().iterator();
        while (iter.hasNext()) {
            if (iter.next() != entity) continue;
            iter.remove();
        }
        this.parentsByChild.clear();
        this.entitySnapshotsByKey.remove(key);
        this.nullifiableEntityKeys.remove(key);
        this.getBatchFetchQueue().removeBatchLoadableEntityKey(key);
        this.getBatchFetchQueue().removeSubselect(key);
        return entity;
    }

    public Object getEntity(EntityUniqueKey euk) {
        return this.entitiesByUniqueKey.get(euk);
    }

    public void addEntity(EntityUniqueKey euk, Object entity) {
        this.entitiesByUniqueKey.put(euk, entity);
    }

    public EntityEntry getEntry(Object entity) {
        return (EntityEntry)this.entityEntries.get(entity);
    }

    public EntityEntry removeEntry(Object entity) {
        return (EntityEntry)this.entityEntries.remove(entity);
    }

    public boolean isEntryFor(Object entity) {
        return this.entityEntries.containsKey(entity);
    }

    public CollectionEntry getCollectionEntry(PersistentCollection coll) {
        return (CollectionEntry)this.collectionEntries.get(coll);
    }

    public EntityEntry addEntity(Object entity, Status status, Object[] loadedState, EntityKey entityKey, Object version, LockMode lockMode, boolean existsInDatabase, EntityPersister persister, boolean disableVersionIncrement, boolean lazyPropertiesAreUnfetched) {
        this.addEntity(entityKey, entity);
        return this.addEntry(entity, status, loadedState, null, entityKey.getIdentifier(), version, lockMode, existsInDatabase, persister, disableVersionIncrement, lazyPropertiesAreUnfetched);
    }

    public EntityEntry addEntry(Object entity, Status status, Object[] loadedState, Object rowId, Serializable id, Object version, LockMode lockMode, boolean existsInDatabase, EntityPersister persister, boolean disableVersionIncrement, boolean lazyPropertiesAreUnfetched) {
        EntityEntry e = new EntityEntry(status, loadedState, rowId, id, version, lockMode, existsInDatabase, persister, this.session.getEntityMode(), disableVersionIncrement, lazyPropertiesAreUnfetched);
        this.entityEntries.put(entity, e);
        this.setHasNonReadOnlyEnties(status);
        return e;
    }

    public boolean containsCollection(PersistentCollection collection) {
        return this.collectionEntries.containsKey(collection);
    }

    public boolean containsProxy(Object entity) {
        return this.proxiesByKey.containsValue(entity);
    }

    public boolean reassociateIfUninitializedProxy(Object value) throws MappingException {
        if (value instanceof ElementWrapper) {
            value = ((ElementWrapper)value).getElement();
        }
        if (!Hibernate.isInitialized(value)) {
            HibernateProxy proxy = (HibernateProxy)value;
            LazyInitializer li = proxy.getHibernateLazyInitializer();
            this.reassociateProxy(li, proxy);
            return true;
        }
        return false;
    }

    public void reassociateProxy(Object value, Serializable id) throws MappingException {
        if (value instanceof ElementWrapper) {
            value = ((ElementWrapper)value).getElement();
        }
        if (value instanceof HibernateProxy) {
            if (log.isDebugEnabled()) {
                log.debug("setting proxy identifier: " + id);
            }
            HibernateProxy proxy = (HibernateProxy)value;
            LazyInitializer li = proxy.getHibernateLazyInitializer();
            li.setIdentifier(id);
            this.reassociateProxy(li, proxy);
        }
    }

    private void reassociateProxy(LazyInitializer li, HibernateProxy proxy) {
        if (li.getSession() != this.getSession()) {
            EntityPersister persister = this.session.getFactory().getEntityPersister(li.getEntityName());
            EntityKey key = new EntityKey(li.getIdentifier(), persister, this.session.getEntityMode());
            if (!this.proxiesByKey.containsKey(key)) {
                this.proxiesByKey.put(key, proxy);
            }
            proxy.getHibernateLazyInitializer().setSession(this.session);
        }
    }

    public Object unproxy(Object maybeProxy) throws HibernateException {
        if (maybeProxy instanceof ElementWrapper) {
            maybeProxy = ((ElementWrapper)maybeProxy).getElement();
        }
        if (maybeProxy instanceof HibernateProxy) {
            HibernateProxy proxy = (HibernateProxy)maybeProxy;
            LazyInitializer li = proxy.getHibernateLazyInitializer();
            if (li.isUninitialized()) {
                throw new PersistentObjectException("object was an uninitialized proxy for " + li.getEntityName());
            }
            return li.getImplementation();
        }
        return maybeProxy;
    }

    public Object unproxyAndReassociate(Object maybeProxy) throws HibernateException {
        if (maybeProxy instanceof ElementWrapper) {
            maybeProxy = ((ElementWrapper)maybeProxy).getElement();
        }
        if (maybeProxy instanceof HibernateProxy) {
            HibernateProxy proxy = (HibernateProxy)maybeProxy;
            LazyInitializer li = proxy.getHibernateLazyInitializer();
            this.reassociateProxy(li, proxy);
            return li.getImplementation();
        }
        return maybeProxy;
    }

    public void checkUniqueness(EntityKey key, Object object) throws HibernateException {
        Object entity = this.getEntity(key);
        if (entity == object) {
            throw new AssertionFailure("object already associated, but no entry was found");
        }
        if (entity != null) {
            throw new NonUniqueObjectException(key.getIdentifier(), key.getEntityName());
        }
    }

    public Object narrowProxy(Object proxy, EntityPersister persister, EntityKey key, Object object) throws HibernateException {
        boolean alreadyNarrow = persister.getConcreteProxyClass(this.session.getEntityMode()).isAssignableFrom(proxy.getClass());
        if (!alreadyNarrow) {
            if (PROXY_WARN_LOG.isWarnEnabled()) {
                PROXY_WARN_LOG.warn("Narrowing proxy to " + persister.getConcreteProxyClass(this.session.getEntityMode()) + " - this operation breaks ==");
            }
            if (object != null) {
                this.proxiesByKey.remove(key);
                return object;
            }
            proxy = persister.createProxy(key.getIdentifier(), this.session);
            this.proxiesByKey.put(key, proxy);
            return proxy;
        }
        if (object != null) {
            LazyInitializer li = ((HibernateProxy)proxy).getHibernateLazyInitializer();
            li.setImplementation(object);
        }
        return proxy;
    }

    public Object proxyFor(EntityPersister persister, EntityKey key, Object impl) throws HibernateException {
        if (!persister.hasProxy()) {
            return impl;
        }
        Object proxy = this.proxiesByKey.get(key);
        if (proxy != null) {
            return this.narrowProxy(proxy, persister, key, impl);
        }
        return impl;
    }

    public Object proxyFor(Object impl) throws HibernateException {
        EntityEntry e = this.getEntry(impl);
        return this.proxyFor(e.getPersister(), e.getEntityKey(), impl);
    }

    public Object getCollectionOwner(Serializable key, CollectionPersister collectionPersister) throws MappingException {
        return this.getEntity(new EntityKey(key, collectionPersister.getOwnerEntityPersister(), this.session.getEntityMode()));
    }

    public Object getLoadedCollectionOwnerOrNull(PersistentCollection collection) {
        CollectionEntry ce = this.getCollectionEntry(collection);
        if (ce.getLoadedPersister() == null) {
            return null;
        }
        Object loadedOwner = null;
        Serializable entityId = this.getLoadedCollectionOwnerIdOrNull(ce);
        if (entityId != null) {
            loadedOwner = this.getCollectionOwner(entityId, ce.getLoadedPersister());
        }
        return loadedOwner;
    }

    public Serializable getLoadedCollectionOwnerIdOrNull(PersistentCollection collection) {
        return this.getLoadedCollectionOwnerIdOrNull(this.getCollectionEntry(collection));
    }

    private Serializable getLoadedCollectionOwnerIdOrNull(CollectionEntry ce) {
        if (ce == null || ce.getLoadedKey() == null || ce.getLoadedPersister() == null) {
            return null;
        }
        return ce.getLoadedPersister().getCollectionType().getIdOfOwnerOrNull(ce.getLoadedKey(), this.session);
    }

    public void addUninitializedCollection(CollectionPersister persister, PersistentCollection collection, Serializable id) {
        CollectionEntry ce = new CollectionEntry(collection, persister, id, this.flushing);
        this.addCollection(collection, ce, id);
    }

    public void addUninitializedDetachedCollection(CollectionPersister persister, PersistentCollection collection) {
        CollectionEntry ce = new CollectionEntry(persister, collection.getKey());
        this.addCollection(collection, ce, collection.getKey());
    }

    public void addNewCollection(CollectionPersister persister, PersistentCollection collection) throws HibernateException {
        this.addCollection(collection, persister);
    }

    private void addCollection(PersistentCollection coll, CollectionEntry entry, Serializable key) {
        this.collectionEntries.put(coll, entry);
        CollectionKey collectionKey = new CollectionKey(entry.getLoadedPersister(), key, this.session.getEntityMode());
        PersistentCollection old = this.collectionsByKey.put(collectionKey, coll);
        if (old != null) {
            if (old == coll) {
                throw new AssertionFailure("bug adding collection twice");
            }
            old.unsetSession(this.session);
            this.collectionEntries.remove(old);
        }
    }

    private void addCollection(PersistentCollection collection, CollectionPersister persister) {
        CollectionEntry ce = new CollectionEntry(persister, collection);
        this.collectionEntries.put(collection, ce);
    }

    public void addInitializedDetachedCollection(CollectionPersister collectionPersister, PersistentCollection collection) throws HibernateException {
        if (collection.isUnreferenced()) {
            this.addCollection(collection, collectionPersister);
        } else {
            CollectionEntry ce = new CollectionEntry(collection, this.session.getFactory());
            this.addCollection(collection, ce, collection.getKey());
        }
    }

    public CollectionEntry addInitializedCollection(CollectionPersister persister, PersistentCollection collection, Serializable id) throws HibernateException {
        CollectionEntry ce = new CollectionEntry(collection, persister, id, this.flushing);
        ce.postInitialize(collection);
        this.addCollection(collection, ce, id);
        return ce;
    }

    public PersistentCollection getCollection(CollectionKey collectionKey) {
        return (PersistentCollection)this.collectionsByKey.get(collectionKey);
    }

    public void addNonLazyCollection(PersistentCollection collection) {
        this.nonlazyCollections.add(collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeNonLazyCollections() throws HibernateException {
        if (this.loadCounter == 0) {
            log.debug("initializing non-lazy collections");
            ++this.loadCounter;
            try {
                int size;
                while ((size = this.nonlazyCollections.size()) > 0) {
                    ((PersistentCollection)this.nonlazyCollections.remove(size - 1)).forceInitialization();
                }
                Object var3_2 = null;
                --this.loadCounter;
                this.clearNullProperties();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                --this.loadCounter;
                this.clearNullProperties();
                throw throwable;
            }
        }
    }

    public PersistentCollection getCollectionHolder(Object array) {
        return (PersistentCollection)this.arrayHolders.get(array);
    }

    public void addCollectionHolder(PersistentCollection holder) {
        this.arrayHolders.put(holder.getValue(), holder);
    }

    public PersistentCollection removeCollectionHolder(Object array) {
        return (PersistentCollection)this.arrayHolders.remove(array);
    }

    public Serializable getSnapshot(PersistentCollection coll) {
        return this.getCollectionEntry(coll).getSnapshot();
    }

    public CollectionEntry getCollectionEntryOrNull(Object collection) {
        PersistentCollection coll;
        if (collection instanceof PersistentCollection) {
            coll = (PersistentCollection)collection;
        } else {
            coll = this.getCollectionHolder(collection);
            if (coll == null) {
                Iterator wrappers = IdentityMap.keyIterator(this.collectionEntries);
                while (wrappers.hasNext()) {
                    PersistentCollection pc = (PersistentCollection)wrappers.next();
                    if (!pc.isWrapper(collection)) continue;
                    coll = pc;
                    break;
                }
            }
        }
        return coll == null ? null : this.getCollectionEntry(coll);
    }

    public Object getProxy(EntityKey key) {
        return this.proxiesByKey.get(key);
    }

    public void addProxy(EntityKey key, Object proxy) {
        this.proxiesByKey.put(key, proxy);
    }

    public Object removeProxy(EntityKey key) {
        if (this.batchFetchQueue != null) {
            this.batchFetchQueue.removeBatchLoadableEntityKey(key);
            this.batchFetchQueue.removeSubselect(key);
        }
        return this.proxiesByKey.remove(key);
    }

    public HashSet getNullifiableEntityKeys() {
        return this.nullifiableEntityKeys;
    }

    public Map getEntitiesByKey() {
        return this.entitiesByKey;
    }

    public Map getProxiesByKey() {
        return this.proxiesByKey;
    }

    public Map getEntityEntries() {
        return this.entityEntries;
    }

    public Map getCollectionEntries() {
        return this.collectionEntries;
    }

    public Map getCollectionsByKey() {
        return this.collectionsByKey;
    }

    public int getCascadeLevel() {
        return this.cascading;
    }

    public int incrementCascadeLevel() {
        return ++this.cascading;
    }

    public int decrementCascadeLevel() {
        return --this.cascading;
    }

    public boolean isFlushing() {
        return this.flushing;
    }

    public void setFlushing(boolean flushing) {
        this.flushing = flushing;
    }

    public void beforeLoad() {
        ++this.loadCounter;
    }

    public void afterLoad() {
        --this.loadCounter;
    }

    public String toString() {
        return "PersistenceContext[entityKeys=" + this.entitiesByKey.keySet() + ",collectionKeys=" + this.collectionsByKey.keySet() + "]";
    }

    public Serializable getOwnerId(String entityName, String propertyName, Object childEntity, Map mergeMap) {
        boolean found;
        String collectionRole = entityName + '.' + propertyName;
        EntityPersister persister = this.session.getFactory().getEntityPersister(entityName);
        CollectionPersister collectionPersister = this.session.getFactory().getCollectionPersister(collectionRole);
        Object parent = this.parentsByChild.get(childEntity);
        if (parent != null) {
            if (this.isFoundInParent(propertyName, childEntity, persister, collectionPersister, parent)) {
                return this.getEntry(parent).getId();
            }
            this.parentsByChild.remove(childEntity);
        }
        Iterator entities = IdentityMap.entries(this.entityEntries).iterator();
        while (entities.hasNext()) {
            Map.Entry me = (Map.Entry)entities.next();
            EntityEntry entityEntry = (EntityEntry)me.getValue();
            if (!persister.isSubclassEntityName(entityEntry.getEntityName())) continue;
            Object entityEntryInstance = me.getKey();
            found = this.isFoundInParent(propertyName, childEntity, persister, collectionPersister, entityEntryInstance);
            if (!found && mergeMap != null) {
                Object unmergedInstance = mergeMap.get(entityEntryInstance);
                Object unmergedChild = mergeMap.get(childEntity);
                if (unmergedInstance != null && unmergedChild != null) {
                    found = this.isFoundInParent(propertyName, unmergedChild, persister, collectionPersister, unmergedInstance);
                }
            }
            if (!found) continue;
            return entityEntry.getId();
        }
        if (mergeMap != null) {
            Iterator mergeMapItr = mergeMap.entrySet().iterator();
            while (mergeMapItr.hasNext()) {
                HibernateProxy proxy;
                Map.Entry mergeMapEntry = mergeMapItr.next();
                if (!(mergeMapEntry.getKey() instanceof HibernateProxy) || !persister.isSubclassEntityName((proxy = (HibernateProxy)mergeMapEntry.getKey()).getHibernateLazyInitializer().getEntityName())) continue;
                found = this.isFoundInParent(propertyName, childEntity, persister, collectionPersister, mergeMap.get(proxy));
                if (!found) {
                    found = this.isFoundInParent(propertyName, mergeMap.get(childEntity), persister, collectionPersister, mergeMap.get(proxy));
                }
                if (!found) continue;
                return proxy.getHibernateLazyInitializer().getIdentifier();
            }
        }
        return null;
    }

    private boolean isFoundInParent(String property, Object childEntity, EntityPersister persister, CollectionPersister collectionPersister, Object potentialParent) {
        Object collection = persister.getPropertyValue(potentialParent, property, this.session.getEntityMode());
        return collection != null && Hibernate.isInitialized(collection) && collectionPersister.getCollectionType().contains(collection, childEntity, this.session);
    }

    public Object getIndexInOwner(String entity, String property, Object childEntity, Map mergeMap) {
        EntityPersister persister = this.session.getFactory().getEntityPersister(entity);
        CollectionPersister cp = this.session.getFactory().getCollectionPersister(entity + '.' + property);
        Object parent = this.parentsByChild.get(childEntity);
        if (parent != null) {
            Object index = this.getIndexInParent(property, childEntity, persister, cp, parent);
            if (index == null && mergeMap != null) {
                Object unmergedInstance = mergeMap.get(parent);
                Object unmergedChild = mergeMap.get(childEntity);
                if (unmergedInstance != null && unmergedChild != null) {
                    index = this.getIndexInParent(property, unmergedChild, persister, cp, unmergedInstance);
                }
            }
            if (index != null) {
                return index;
            }
            this.parentsByChild.remove(childEntity);
        }
        Iterator entities = IdentityMap.entries(this.entityEntries).iterator();
        while (entities.hasNext()) {
            Map.Entry me = (Map.Entry)entities.next();
            EntityEntry ee = (EntityEntry)me.getValue();
            if (!persister.isSubclassEntityName(ee.getEntityName())) continue;
            Object instance = me.getKey();
            Object index = this.getIndexInParent(property, childEntity, persister, cp, instance);
            if (index == null && mergeMap != null) {
                Object unmergedInstance = mergeMap.get(instance);
                Object unmergedChild = mergeMap.get(childEntity);
                if (unmergedInstance != null && unmergedChild != null) {
                    index = this.getIndexInParent(property, unmergedChild, persister, cp, unmergedInstance);
                }
            }
            if (index == null) continue;
            return index;
        }
        return null;
    }

    private Object getIndexInParent(String property, Object childEntity, EntityPersister persister, CollectionPersister collectionPersister, Object potentialParent) {
        Object collection = persister.getPropertyValue(potentialParent, property, this.session.getEntityMode());
        if (collection != null && Hibernate.isInitialized(collection)) {
            return collectionPersister.getCollectionType().indexOf(collection, childEntity);
        }
        return null;
    }

    public void addNullProperty(EntityKey ownerKey, String propertyName) {
        this.nullAssociations.add(new AssociationKey(ownerKey, propertyName));
    }

    public boolean isPropertyNull(EntityKey ownerKey, String propertyName) {
        return this.nullAssociations.contains(new AssociationKey(ownerKey, propertyName));
    }

    private void clearNullProperties() {
        this.nullAssociations.clear();
    }

    public boolean isReadOnly(Object entityOrProxy) {
        boolean isReadOnly;
        if (entityOrProxy == null) {
            throw new AssertionFailure("object must be non-null.");
        }
        if (entityOrProxy instanceof HibernateProxy) {
            isReadOnly = ((HibernateProxy)entityOrProxy).getHibernateLazyInitializer().isReadOnly();
        } else {
            EntityEntry ee = this.getEntry(entityOrProxy);
            if (ee == null) {
                throw new TransientObjectException("Instance was not associated with this persistence context");
            }
            isReadOnly = ee.isReadOnly();
        }
        return isReadOnly;
    }

    public void setReadOnly(Object object, boolean readOnly) {
        if (object == null) {
            throw new AssertionFailure("object must be non-null.");
        }
        if (this.isReadOnly(object) == readOnly) {
            return;
        }
        if (object instanceof HibernateProxy) {
            HibernateProxy proxy = (HibernateProxy)object;
            this.setProxyReadOnly(proxy, readOnly);
            if (Hibernate.isInitialized(proxy)) {
                this.setEntityReadOnly(proxy.getHibernateLazyInitializer().getImplementation(), readOnly);
            }
        } else {
            this.setEntityReadOnly(object, readOnly);
            Object maybeProxy = this.getSession().getPersistenceContext().proxyFor(object);
            if (maybeProxy instanceof HibernateProxy) {
                this.setProxyReadOnly((HibernateProxy)maybeProxy, readOnly);
            }
        }
    }

    private void setProxyReadOnly(HibernateProxy proxy, boolean readOnly) {
        if (proxy.getHibernateLazyInitializer().getSession() != this.getSession()) {
            throw new AssertionFailure("Attempt to set a proxy to read-only that is associated with a different session");
        }
        proxy.getHibernateLazyInitializer().setReadOnly(readOnly);
    }

    private void setEntityReadOnly(Object entity, boolean readOnly) {
        EntityEntry entry = this.getEntry(entity);
        if (entry == null) {
            throw new TransientObjectException("Instance was not associated with this persistence context");
        }
        entry.setReadOnly(readOnly, entity);
        this.hasNonReadOnlyEntities = this.hasNonReadOnlyEntities || !readOnly;
    }

    public void replaceDelayedEntityIdentityInsertKeys(EntityKey oldKey, Serializable generatedId) {
        Object entity = this.entitiesByKey.remove(oldKey);
        EntityEntry oldEntry = (EntityEntry)this.entityEntries.remove(entity);
        this.parentsByChild.clear();
        EntityKey newKey = new EntityKey(generatedId, oldEntry.getPersister(), this.getSession().getEntityMode());
        this.addEntity(newKey, entity);
        this.addEntry(entity, oldEntry.getStatus(), oldEntry.getLoadedState(), oldEntry.getRowId(), generatedId, oldEntry.getVersion(), oldEntry.getLockMode(), oldEntry.isExistsInDatabase(), oldEntry.getPersister(), oldEntry.isBeingReplicated(), oldEntry.isLoadedWithLazyPropertiesUnfetched());
    }

    public void serialize(ObjectOutputStream oos) throws IOException {
        Object entry;
        log.trace("serializing persistent-context");
        oos.writeBoolean(this.hasNonReadOnlyEntities);
        oos.writeInt(this.entitiesByKey.size());
        log.trace("starting serialization of [" + this.entitiesByKey.size() + "] entitiesByKey entries");
        Iterator itr = this.entitiesByKey.entrySet().iterator();
        while (itr.hasNext()) {
            entry = itr.next();
            ((EntityKey)entry.getKey()).serialize(oos);
            oos.writeObject(entry.getValue());
        }
        oos.writeInt(this.entitiesByUniqueKey.size());
        log.trace("starting serialization of [" + this.entitiesByUniqueKey.size() + "] entitiesByUniqueKey entries");
        itr = this.entitiesByUniqueKey.entrySet().iterator();
        while (itr.hasNext()) {
            entry = itr.next();
            ((EntityUniqueKey)entry.getKey()).serialize(oos);
            oos.writeObject(entry.getValue());
        }
        oos.writeInt(this.proxiesByKey.size());
        log.trace("starting serialization of [" + this.proxiesByKey.size() + "] proxiesByKey entries");
        itr = this.proxiesByKey.entrySet().iterator();
        while (itr.hasNext()) {
            entry = itr.next();
            ((EntityKey)entry.getKey()).serialize(oos);
            oos.writeObject(entry.getValue());
        }
        oos.writeInt(this.entitySnapshotsByKey.size());
        log.trace("starting serialization of [" + this.entitySnapshotsByKey.size() + "] entitySnapshotsByKey entries");
        itr = this.entitySnapshotsByKey.entrySet().iterator();
        while (itr.hasNext()) {
            entry = itr.next();
            ((EntityKey)entry.getKey()).serialize(oos);
            oos.writeObject(entry.getValue());
        }
        oos.writeInt(this.entityEntries.size());
        log.trace("starting serialization of [" + this.entityEntries.size() + "] entityEntries entries");
        itr = this.entityEntries.entrySet().iterator();
        while (itr.hasNext()) {
            entry = itr.next();
            oos.writeObject(entry.getKey());
            ((EntityEntry)entry.getValue()).serialize(oos);
        }
        oos.writeInt(this.collectionsByKey.size());
        log.trace("starting serialization of [" + this.collectionsByKey.size() + "] collectionsByKey entries");
        itr = this.collectionsByKey.entrySet().iterator();
        while (itr.hasNext()) {
            entry = itr.next();
            ((CollectionKey)entry.getKey()).serialize(oos);
            oos.writeObject(entry.getValue());
        }
        oos.writeInt(this.collectionEntries.size());
        log.trace("starting serialization of [" + this.collectionEntries.size() + "] collectionEntries entries");
        itr = this.collectionEntries.entrySet().iterator();
        while (itr.hasNext()) {
            entry = itr.next();
            oos.writeObject(entry.getKey());
            ((CollectionEntry)entry.getValue()).serialize(oos);
        }
        oos.writeInt(this.arrayHolders.size());
        log.trace("starting serialization of [" + this.arrayHolders.size() + "] arrayHolders entries");
        itr = this.arrayHolders.entrySet().iterator();
        while (itr.hasNext()) {
            entry = itr.next();
            oos.writeObject(entry.getKey());
            oos.writeObject(entry.getValue());
        }
        oos.writeInt(this.nullifiableEntityKeys.size());
        log.trace("starting serialization of [" + this.nullifiableEntityKeys.size() + "] nullifiableEntityKeys entries");
        itr = this.nullifiableEntityKeys.iterator();
        while (itr.hasNext()) {
            entry = (EntityKey)((Object)itr.next());
            ((EntityKey)entry).serialize(oos);
        }
    }

    public static StatefulPersistenceContext deserialize(ObjectInputStream ois, SessionImplementor session) throws IOException, ClassNotFoundException {
        log.trace("deserializing persistent-context");
        StatefulPersistenceContext rtn = new StatefulPersistenceContext(session);
        try {
            int i;
            rtn.hasNonReadOnlyEntities = ois.readBoolean();
            int count = ois.readInt();
            log.trace("staring deserialization of [" + count + "] entitiesByKey entries");
            rtn.entitiesByKey = new HashMap(count < 8 ? 8 : count);
            for (i = 0; i < count; ++i) {
                rtn.entitiesByKey.put(EntityKey.deserialize(ois, session), ois.readObject());
            }
            count = ois.readInt();
            log.trace("staring deserialization of [" + count + "] entitiesByUniqueKey entries");
            rtn.entitiesByUniqueKey = new HashMap(count < 8 ? 8 : count);
            for (i = 0; i < count; ++i) {
                rtn.entitiesByUniqueKey.put(EntityUniqueKey.deserialize(ois, session), ois.readObject());
            }
            count = ois.readInt();
            log.trace("staring deserialization of [" + count + "] proxiesByKey entries");
            rtn.proxiesByKey = new ReferenceMap(0, 2, count < 8 ? 8 : count, 0.75f);
            for (i = 0; i < count; ++i) {
                EntityKey ek = EntityKey.deserialize(ois, session);
                Object proxy = ois.readObject();
                if (proxy instanceof HibernateProxy) {
                    ((HibernateProxy)proxy).getHibernateLazyInitializer().setSession(session);
                    rtn.proxiesByKey.put(ek, proxy);
                    continue;
                }
                log.trace("encountered prunded proxy");
            }
            count = ois.readInt();
            log.trace("staring deserialization of [" + count + "] entitySnapshotsByKey entries");
            rtn.entitySnapshotsByKey = new HashMap(count < 8 ? 8 : count);
            for (i = 0; i < count; ++i) {
                rtn.entitySnapshotsByKey.put(EntityKey.deserialize(ois, session), ois.readObject());
            }
            count = ois.readInt();
            log.trace("staring deserialization of [" + count + "] entityEntries entries");
            rtn.entityEntries = IdentityMap.instantiateSequenced(count < 8 ? 8 : count);
            for (i = 0; i < count; ++i) {
                Object entity = ois.readObject();
                EntityEntry entry = EntityEntry.deserialize(ois, session);
                rtn.entityEntries.put(entity, entry);
            }
            count = ois.readInt();
            log.trace("staring deserialization of [" + count + "] collectionsByKey entries");
            rtn.collectionsByKey = new HashMap(count < 8 ? 8 : count);
            for (i = 0; i < count; ++i) {
                rtn.collectionsByKey.put(CollectionKey.deserialize(ois, session), ois.readObject());
            }
            count = ois.readInt();
            log.trace("staring deserialization of [" + count + "] collectionEntries entries");
            rtn.collectionEntries = IdentityMap.instantiateSequenced(count < 8 ? 8 : count);
            for (i = 0; i < count; ++i) {
                PersistentCollection pc = (PersistentCollection)ois.readObject();
                CollectionEntry ce = CollectionEntry.deserialize(ois, session);
                pc.setCurrentSession(session);
                rtn.collectionEntries.put(pc, ce);
            }
            count = ois.readInt();
            log.trace("staring deserialization of [" + count + "] arrayHolders entries");
            rtn.arrayHolders = IdentityMap.instantiate(count < 8 ? 8 : count);
            for (i = 0; i < count; ++i) {
                rtn.arrayHolders.put(ois.readObject(), ois.readObject());
            }
            count = ois.readInt();
            log.trace("staring deserialization of [" + count + "] nullifiableEntityKeys entries");
            rtn.nullifiableEntityKeys = new HashSet();
            for (i = 0; i < count; ++i) {
                rtn.nullifiableEntityKeys.add(EntityKey.deserialize(ois, session));
            }
        }
        catch (HibernateException he) {
            throw new InvalidObjectException(he.getMessage());
        }
        return rtn;
    }

    public void addChildParent(Object child, Object parent) {
        this.parentsByChild.put(child, parent);
    }

    public void removeChildParent(Object child) {
        this.parentsByChild.remove(child);
    }
}

