/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.hibernate.DuplicateMappingException;
import org.hibernate.EmptyInterceptor;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.InvalidMappingException;
import org.hibernate.MappingException;
import org.hibernate.MappingNotFoundException;
import org.hibernate.SessionFactory;
import org.hibernate.SessionFactoryObserver;
import org.hibernate.cfg.DefaultNamingStrategy;
import org.hibernate.cfg.Environment;
import org.hibernate.cfg.ExtendsQueueEntry;
import org.hibernate.cfg.HbmBinder;
import org.hibernate.cfg.Mappings;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.cfg.ObjectNameNormalizer;
import org.hibernate.cfg.QuerySecondPass;
import org.hibernate.cfg.SecondPass;
import org.hibernate.cfg.Settings;
import org.hibernate.cfg.SettingsFactory;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.engine.FilterDefinition;
import org.hibernate.engine.Mapping;
import org.hibernate.engine.NamedQueryDefinition;
import org.hibernate.engine.NamedSQLQueryDefinition;
import org.hibernate.engine.ResultSetMappingDefinition;
import org.hibernate.event.AutoFlushEventListener;
import org.hibernate.event.DeleteEventListener;
import org.hibernate.event.DirtyCheckEventListener;
import org.hibernate.event.EventListeners;
import org.hibernate.event.EvictEventListener;
import org.hibernate.event.FlushEntityEventListener;
import org.hibernate.event.FlushEventListener;
import org.hibernate.event.InitializeCollectionEventListener;
import org.hibernate.event.LoadEventListener;
import org.hibernate.event.LockEventListener;
import org.hibernate.event.MergeEventListener;
import org.hibernate.event.PersistEventListener;
import org.hibernate.event.PostCollectionRecreateEventListener;
import org.hibernate.event.PostCollectionRemoveEventListener;
import org.hibernate.event.PostCollectionUpdateEventListener;
import org.hibernate.event.PostDeleteEventListener;
import org.hibernate.event.PostInsertEventListener;
import org.hibernate.event.PostLoadEventListener;
import org.hibernate.event.PostUpdateEventListener;
import org.hibernate.event.PreCollectionRecreateEventListener;
import org.hibernate.event.PreCollectionRemoveEventListener;
import org.hibernate.event.PreCollectionUpdateEventListener;
import org.hibernate.event.PreDeleteEventListener;
import org.hibernate.event.PreInsertEventListener;
import org.hibernate.event.PreLoadEventListener;
import org.hibernate.event.PreUpdateEventListener;
import org.hibernate.event.RefreshEventListener;
import org.hibernate.event.ReplicateEventListener;
import org.hibernate.event.SaveOrUpdateEventListener;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.PersistentIdentifierGenerator;
import org.hibernate.id.factory.DefaultIdentifierGeneratorFactory;
import org.hibernate.id.factory.IdentifierGeneratorFactory;
import org.hibernate.impl.SessionFactoryImpl;
import org.hibernate.mapping.AuxiliaryDatabaseObject;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.DenormalizedTable;
import org.hibernate.mapping.FetchProfile;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.IdentifierCollection;
import org.hibernate.mapping.Index;
import org.hibernate.mapping.MappedSuperclass;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.TypeDef;
import org.hibernate.mapping.UniqueKey;
import org.hibernate.proxy.EntityNotFoundDelegate;
import org.hibernate.secure.JACCConfiguration;
import org.hibernate.tool.hbm2ddl.DatabaseMetadata;
import org.hibernate.tool.hbm2ddl.IndexMetadata;
import org.hibernate.tool.hbm2ddl.TableMetadata;
import org.hibernate.tuple.entity.EntityTuplizerFactory;
import org.hibernate.type.SerializationException;
import org.hibernate.type.Type;
import org.hibernate.util.ArrayHelper;
import org.hibernate.util.CollectionHelper;
import org.hibernate.util.ConfigHelper;
import org.hibernate.util.PropertiesHelper;
import org.hibernate.util.ReflectHelper;
import org.hibernate.util.SerializationHelper;
import org.hibernate.util.StringHelper;
import org.hibernate.util.XMLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class Configuration
implements Serializable {
    private static Logger log = LoggerFactory.getLogger((Class)Configuration.class);
    protected Map classes;
    protected Map imports;
    protected Map collections;
    protected Map tables;
    protected List auxiliaryDatabaseObjects;
    protected Map namedQueries;
    protected Map namedSqlQueries;
    protected Map sqlResultSetMappings;
    protected Map typeDefs;
    protected Map filterDefinitions;
    protected Map fetchProfiles;
    protected Map tableNameBinding;
    protected Map columnNameBindingPerTable;
    protected List secondPasses;
    protected List propertyReferences;
    protected Map extendsQueue;
    protected Map sqlFunctions;
    private EntityTuplizerFactory entityTuplizerFactory;
    private Interceptor interceptor;
    private Properties properties;
    private EntityResolver entityResolver;
    private EntityNotFoundDelegate entityNotFoundDelegate;
    protected transient XMLHelper xmlHelper;
    protected NamingStrategy namingStrategy;
    private SessionFactoryObserver sessionFactoryObserver;
    private EventListeners eventListeners;
    protected final SettingsFactory settingsFactory;
    private transient Mapping mapping = this.buildMapping();
    private DefaultIdentifierGeneratorFactory identifierGeneratorFactory;
    private Map mappedSuperclasses;
    final ObjectNameNormalizer normalizer = new ObjectNameNormalizerImpl();

    protected Configuration(SettingsFactory settingsFactory) {
        this.settingsFactory = settingsFactory;
        this.reset();
    }

    public Configuration() {
        this(new SettingsFactory());
    }

    protected void reset() {
        this.classes = new HashMap();
        this.imports = new HashMap();
        this.collections = new HashMap();
        this.tables = new TreeMap();
        this.namedQueries = new HashMap();
        this.namedSqlQueries = new HashMap();
        this.sqlResultSetMappings = new HashMap();
        this.typeDefs = new HashMap();
        this.filterDefinitions = new HashMap();
        this.fetchProfiles = new HashMap();
        this.auxiliaryDatabaseObjects = new ArrayList();
        this.tableNameBinding = new HashMap();
        this.columnNameBindingPerTable = new HashMap();
        this.propertyReferences = new ArrayList();
        this.secondPasses = new ArrayList();
        this.extendsQueue = new HashMap();
        this.namingStrategy = DefaultNamingStrategy.INSTANCE;
        this.xmlHelper = new XMLHelper();
        this.interceptor = EmptyInterceptor.INSTANCE;
        this.properties = Environment.getProperties();
        this.entityResolver = XMLHelper.DEFAULT_DTD_RESOLVER;
        this.eventListeners = new EventListeners();
        this.sqlFunctions = new HashMap();
        this.entityTuplizerFactory = new EntityTuplizerFactory();
        this.identifierGeneratorFactory = new DefaultIdentifierGeneratorFactory();
        this.mappedSuperclasses = new HashMap();
    }

    public EntityTuplizerFactory getEntityTuplizerFactory() {
        return this.entityTuplizerFactory;
    }

    public Iterator getClassMappings() {
        return this.classes.values().iterator();
    }

    public Iterator getCollectionMappings() {
        return this.collections.values().iterator();
    }

    public Iterator getTableMappings() {
        return this.tables.values().iterator();
    }

    public Iterator getMappedSuperclassMappings() {
        return this.mappedSuperclasses.values().iterator();
    }

    public PersistentClass getClassMapping(String entityName) {
        return (PersistentClass)this.classes.get(entityName);
    }

    public Collection getCollectionMapping(String role) {
        return (Collection)this.collections.get(role);
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public EntityNotFoundDelegate getEntityNotFoundDelegate() {
        return this.entityNotFoundDelegate;
    }

    public void setEntityNotFoundDelegate(EntityNotFoundDelegate entityNotFoundDelegate) {
        this.entityNotFoundDelegate = entityNotFoundDelegate;
    }

    public Configuration addFile(String xmlFile) throws MappingException {
        return this.addFile(new File(xmlFile));
    }

    public Configuration addFile(File xmlFile) throws MappingException {
        log.info("Reading mappings from file: " + xmlFile.getPath());
        if (!xmlFile.exists()) {
            throw new MappingNotFoundException("file", xmlFile.toString());
        }
        try {
            ArrayList errors = new ArrayList();
            Document doc = this.xmlHelper.createSAXReader(xmlFile.toString(), errors, this.entityResolver).read(xmlFile);
            if (errors.size() != 0) {
                throw new InvalidMappingException("file", xmlFile.toString(), (Throwable)errors.get(0));
            }
            this.add(doc);
            return this;
        }
        catch (InvalidMappingException e) {
            throw e;
        }
        catch (MappingNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvalidMappingException("file", xmlFile.toString(), e);
        }
    }

    public Configuration addCacheableFile(File xmlFile) throws MappingException {
        File cachedFile = this.determineCachedDomFile(xmlFile);
        try {
            return this.addCacheableFileStrictly(xmlFile);
        }
        catch (SerializationException e) {
            log.warn("Could not deserialize cache file: " + cachedFile.getPath() + " : " + e);
        }
        catch (FileNotFoundException e) {
            log.warn("I/O reported cached file could not be found : " + cachedFile.getPath() + " : " + e);
        }
        if (!xmlFile.exists()) {
            throw new MappingNotFoundException("file", xmlFile.toString());
        }
        log.info("Reading mappings from file: " + xmlFile);
        ArrayList errors = new ArrayList();
        try {
            Document doc = this.xmlHelper.createSAXReader(xmlFile.getAbsolutePath(), errors, this.entityResolver).read(xmlFile);
            if (errors.size() != 0) {
                throw new InvalidMappingException("file", xmlFile.toString(), (Throwable)errors.get(0));
            }
            try {
                log.debug("Writing cache file for: " + xmlFile + " to: " + cachedFile);
                SerializationHelper.serialize((Serializable)doc, new FileOutputStream(cachedFile));
            }
            catch (SerializationException e) {
                log.warn("Could not write cached file: " + cachedFile, (Throwable)e);
            }
            catch (FileNotFoundException e) {
                log.warn("I/O reported error writing cached file : " + cachedFile.getPath(), (Throwable)e);
            }
            this.add(doc);
        }
        catch (DocumentException e) {
            throw new InvalidMappingException("file", xmlFile.toString(), e);
        }
        return this;
    }

    private File determineCachedDomFile(File xmlFile) {
        return new File(xmlFile.getAbsolutePath() + ".bin");
    }

    public Configuration addCacheableFileStrictly(File xmlFile) throws MappingException, SerializationException, FileNotFoundException {
        boolean useCachedFile;
        File cachedFile = this.determineCachedDomFile(xmlFile);
        boolean bl = useCachedFile = xmlFile.exists() && cachedFile.exists() && xmlFile.lastModified() < cachedFile.lastModified();
        if (!useCachedFile) {
            throw new FileNotFoundException("Cached file could not be found or could not be used");
        }
        log.info("Reading mappings from cache file: " + cachedFile);
        Document document = (Document)SerializationHelper.deserialize(new FileInputStream(cachedFile));
        this.add(document);
        return this;
    }

    public Configuration addCacheableFile(String xmlFile) throws MappingException {
        return this.addCacheableFile(new File(xmlFile));
    }

    public Configuration addXML(String xml) throws MappingException {
        if (log.isDebugEnabled()) {
            log.debug("Mapping XML:\n" + xml);
        }
        try {
            ArrayList errors = new ArrayList();
            Document doc = this.xmlHelper.createSAXReader("XML String", errors, this.entityResolver).read((Reader)new StringReader(xml));
            if (errors.size() != 0) {
                throw new MappingException("invalid mapping", (Throwable)errors.get(0));
            }
            this.add(doc);
        }
        catch (DocumentException e) {
            throw new MappingException("Could not parse mapping document in XML string", e);
        }
        return this;
    }

    public Configuration addURL(URL url) throws MappingException {
        if (log.isDebugEnabled()) {
            log.debug("Reading mapping document from URL:" + url.toExternalForm());
        }
        try {
            this.addInputStream(url.openStream());
        }
        catch (InvalidMappingException e) {
            throw new InvalidMappingException("URL", url.toExternalForm(), e.getCause());
        }
        catch (Exception e) {
            throw new InvalidMappingException("URL", url.toExternalForm(), e);
        }
        return this;
    }

    public Configuration addDocument(org.w3c.dom.Document doc) throws MappingException {
        if (log.isDebugEnabled()) {
            log.debug("Mapping document:\n" + doc);
        }
        this.add(this.xmlHelper.createDOMReader().read(doc));
        return this;
    }

    public Configuration addInputStream(InputStream xmlInputStream) throws MappingException {
        try {
            ArrayList errors = new ArrayList();
            Document doc = this.xmlHelper.createSAXReader("XML InputStream", errors, this.entityResolver).read(new InputSource(xmlInputStream));
            if (errors.size() != 0) {
                throw new InvalidMappingException("invalid mapping", null, (Throwable)errors.get(0));
            }
            this.add(doc);
            Configuration configuration = this;
            return configuration;
        }
        catch (DocumentException e) {
            throw new InvalidMappingException("input stream", null, e);
        }
        finally {
            try {
                xmlInputStream.close();
            }
            catch (IOException ioe) {
                log.warn("Could not close input stream", (Throwable)ioe);
            }
        }
    }

    public Configuration addResource(String resourceName, ClassLoader classLoader) throws MappingException {
        log.info("Reading mappings from resource: " + resourceName);
        InputStream rsrc = classLoader.getResourceAsStream(resourceName);
        if (rsrc == null) {
            throw new MappingNotFoundException("resource", resourceName);
        }
        try {
            return this.addInputStream(rsrc);
        }
        catch (MappingException me) {
            throw new InvalidMappingException("resource", resourceName, me);
        }
    }

    public Configuration addResource(String resourceName) throws MappingException {
        log.info("Reading mappings from resource : " + resourceName);
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        InputStream rsrc = null;
        if (contextClassLoader != null) {
            rsrc = contextClassLoader.getResourceAsStream(resourceName);
        }
        if (rsrc == null) {
            rsrc = Environment.class.getClassLoader().getResourceAsStream(resourceName);
        }
        if (rsrc == null) {
            throw new MappingNotFoundException("resource", resourceName);
        }
        try {
            return this.addInputStream(rsrc);
        }
        catch (MappingException me) {
            throw new InvalidMappingException("resource", resourceName, me);
        }
    }

    public Configuration addClass(Class persistentClass) throws MappingException {
        String mappingResourceName = persistentClass.getName().replace('.', '/') + ".hbm.xml";
        log.info("Reading mappings from resource: " + mappingResourceName);
        return this.addResource(mappingResourceName, persistentClass.getClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Configuration addJar(File jar) throws MappingException {
        log.info("Searching for mapping documents in jar: " + jar.getName());
        JarFile jarFile = null;
        try {
            try {
                jarFile = new JarFile(jar);
            }
            catch (IOException ioe) {
                throw new InvalidMappingException("Could not read mapping documents from jar: " + jar.getName(), "jar", jar.getName(), ioe);
            }
            Enumeration<JarEntry> jarEntries = jarFile.entries();
            while (jarEntries.hasMoreElements()) {
                ZipEntry ze = jarEntries.nextElement();
                if (!ze.getName().endsWith(".hbm.xml")) continue;
                log.info("Found mapping document in jar: " + ze.getName());
                try {
                    this.addInputStream(jarFile.getInputStream(ze));
                }
                catch (Exception e) {
                    throw new InvalidMappingException("Could not read mapping documents from jar: " + jar.getName(), "jar", jar.getName(), e);
                    return this;
                }
            }
        }
        finally {
            try {
                if (jarFile != null) {
                    jarFile.close();
                }
            }
            catch (IOException ioe) {
                log.error("could not close jar", (Throwable)ioe);
            }
        }
    }

    public Configuration addDirectory(File dir) throws MappingException {
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                this.addDirectory(files[i]);
                continue;
            }
            if (!files[i].getName().endsWith(".hbm.xml")) continue;
            this.addFile(files[i]);
        }
        return this;
    }

    protected void add(Document doc) throws MappingException {
        HbmBinder.bindRoot(doc, this.createMappings(), CollectionHelper.EMPTY_MAP);
    }

    public Mappings createMappings() {
        return new MappingsImpl();
    }

    private Iterator iterateGenerators(Dialect dialect) throws MappingException {
        IdentifierGenerator ig;
        TreeMap<Object, IdentifierGenerator> generators = new TreeMap<Object, IdentifierGenerator>();
        String defaultCatalog = this.properties.getProperty("hibernate.default_catalog");
        String defaultSchema = this.properties.getProperty("hibernate.default_schema");
        Iterator iter = this.classes.values().iterator();
        while (iter.hasNext()) {
            PersistentClass pc = (PersistentClass)iter.next();
            if (pc.isInherited() || !((ig = pc.getIdentifier().createIdentifierGenerator(this.getIdentifierGeneratorFactory(), dialect, defaultCatalog, defaultSchema, (RootClass)pc)) instanceof PersistentIdentifierGenerator)) continue;
            generators.put(((PersistentIdentifierGenerator)ig).generatorKey(), ig);
        }
        iter = this.collections.values().iterator();
        while (iter.hasNext()) {
            Collection collection = (Collection)iter.next();
            if (!collection.isIdentified() || !((ig = ((IdentifierCollection)collection).getIdentifier().createIdentifierGenerator(this.getIdentifierGeneratorFactory(), dialect, defaultCatalog, defaultSchema, null)) instanceof PersistentIdentifierGenerator)) continue;
            generators.put(((PersistentIdentifierGenerator)ig).generatorKey(), ig);
        }
        return generators.values().iterator();
    }

    public String[] generateDropSchemaScript(Dialect dialect) throws HibernateException {
        Table table;
        Iterator iter;
        this.secondPassCompile();
        String defaultCatalog = this.properties.getProperty("hibernate.default_catalog");
        String defaultSchema = this.properties.getProperty("hibernate.default_schema");
        ArrayList<String> script = new ArrayList<String>(50);
        ListIterator itr = this.auxiliaryDatabaseObjects.listIterator(this.auxiliaryDatabaseObjects.size());
        while (itr.hasPrevious()) {
            AuxiliaryDatabaseObject object = (AuxiliaryDatabaseObject)itr.previous();
            if (!object.appliesToDialect(dialect)) continue;
            script.add(object.sqlDropString(dialect, defaultCatalog, defaultSchema));
        }
        if (dialect.dropConstraints()) {
            iter = this.getTableMappings();
            while (iter.hasNext()) {
                table = (Table)iter.next();
                if (!table.isPhysicalTable()) continue;
                Iterator subIter = table.getForeignKeyIterator();
                while (subIter.hasNext()) {
                    ForeignKey fk = (ForeignKey)subIter.next();
                    if (!fk.isPhysicalConstraint()) continue;
                    script.add(fk.sqlDropString(dialect, defaultCatalog, defaultSchema));
                }
            }
        }
        iter = this.getTableMappings();
        while (iter.hasNext()) {
            table = (Table)iter.next();
            if (!table.isPhysicalTable()) continue;
            script.add(table.sqlDropString(dialect, defaultCatalog, defaultSchema));
        }
        iter = this.iterateGenerators(dialect);
        while (iter.hasNext()) {
            String[] lines = ((PersistentIdentifierGenerator)iter.next()).sqlDropStrings(dialect);
            for (int i = 0; i < lines.length; ++i) {
                script.add(lines[i]);
            }
        }
        return ArrayHelper.toStringArray(script);
    }

    public String[] generateSchemaCreationScript(Dialect dialect) throws HibernateException {
        Table table;
        this.secondPassCompile();
        ArrayList<String> script = new ArrayList<String>(50);
        String defaultCatalog = this.properties.getProperty("hibernate.default_catalog");
        String defaultSchema = this.properties.getProperty("hibernate.default_schema");
        Iterator iter = this.getTableMappings();
        while (iter.hasNext()) {
            table = (Table)iter.next();
            if (!table.isPhysicalTable()) continue;
            script.add(table.sqlCreateString(dialect, this.mapping, defaultCatalog, defaultSchema));
            Iterator comments = table.sqlCommentStrings(dialect, defaultCatalog, defaultSchema);
            while (comments.hasNext()) {
                script.add((String)comments.next());
            }
        }
        iter = this.getTableMappings();
        while (iter.hasNext()) {
            Iterator subIter;
            table = (Table)iter.next();
            if (!table.isPhysicalTable()) continue;
            if (!dialect.supportsUniqueConstraintInCreateAlterTable()) {
                subIter = table.getUniqueKeyIterator();
                while (subIter.hasNext()) {
                    UniqueKey uk = (UniqueKey)subIter.next();
                    String constraintString = uk.sqlCreateString(dialect, this.mapping, defaultCatalog, defaultSchema);
                    if (constraintString == null) continue;
                    script.add(constraintString);
                }
            }
            subIter = table.getIndexIterator();
            while (subIter.hasNext()) {
                Index index = (Index)subIter.next();
                script.add(index.sqlCreateString(dialect, this.mapping, defaultCatalog, defaultSchema));
            }
            if (!dialect.hasAlterTable()) continue;
            subIter = table.getForeignKeyIterator();
            while (subIter.hasNext()) {
                ForeignKey fk = (ForeignKey)subIter.next();
                if (!fk.isPhysicalConstraint()) continue;
                script.add(fk.sqlCreateString(dialect, this.mapping, defaultCatalog, defaultSchema));
            }
        }
        iter = this.iterateGenerators(dialect);
        while (iter.hasNext()) {
            String[] lines = ((PersistentIdentifierGenerator)iter.next()).sqlCreateStrings(dialect);
            for (int i = 0; i < lines.length; ++i) {
                script.add(lines[i]);
            }
        }
        Iterator itr = this.auxiliaryDatabaseObjects.iterator();
        while (itr.hasNext()) {
            AuxiliaryDatabaseObject object = (AuxiliaryDatabaseObject)itr.next();
            if (!object.appliesToDialect(dialect)) continue;
            script.add(object.sqlCreateString(dialect, this.mapping, defaultCatalog, defaultSchema));
        }
        return ArrayHelper.toStringArray(script);
    }

    public String[] generateSchemaUpdateScript(Dialect dialect, DatabaseMetadata databaseMetadata) throws HibernateException {
        TableMetadata tableInfo;
        Table table;
        this.secondPassCompile();
        String defaultCatalog = this.properties.getProperty("hibernate.default_catalog");
        String defaultSchema = this.properties.getProperty("hibernate.default_schema");
        ArrayList<String> script = new ArrayList<String>(50);
        Iterator iter = this.getTableMappings();
        while (iter.hasNext()) {
            table = (Table)iter.next();
            if (!table.isPhysicalTable()) continue;
            tableInfo = databaseMetadata.getTableMetadata(table.getName(), table.getSchema() == null ? defaultSchema : table.getSchema(), table.getCatalog() == null ? defaultCatalog : table.getCatalog(), table.isQuoted());
            if (tableInfo == null) {
                script.add(table.sqlCreateString(dialect, this.mapping, defaultCatalog, defaultSchema));
            } else {
                Iterator subiter = table.sqlAlterStrings(dialect, this.mapping, tableInfo, defaultCatalog, defaultSchema);
                while (subiter.hasNext()) {
                    script.add((String)subiter.next());
                }
            }
            Iterator comments = table.sqlCommentStrings(dialect, defaultCatalog, defaultSchema);
            while (comments.hasNext()) {
                script.add((String)comments.next());
            }
        }
        iter = this.getTableMappings();
        while (iter.hasNext()) {
            Iterator subIter;
            table = (Table)iter.next();
            if (!table.isPhysicalTable()) continue;
            tableInfo = databaseMetadata.getTableMetadata(table.getName(), table.getSchema(), table.getCatalog(), table.isQuoted());
            if (dialect.hasAlterTable()) {
                subIter = table.getForeignKeyIterator();
                while (subIter.hasNext()) {
                    boolean create;
                    ForeignKey fk = (ForeignKey)subIter.next();
                    if (!fk.isPhysicalConstraint() || !(create = tableInfo == null || tableInfo.getForeignKeyMetadata(fk) == null && (!(dialect instanceof MySQLDialect) || tableInfo.getIndexMetadata(fk.getName()) == null))) continue;
                    script.add(fk.sqlCreateString(dialect, this.mapping, defaultCatalog, defaultSchema));
                }
            }
            subIter = table.getIndexIterator();
            while (subIter.hasNext()) {
                IndexMetadata meta;
                Index index = (Index)subIter.next();
                if (tableInfo != null && StringHelper.isNotEmpty(index.getName()) && (meta = tableInfo.getIndexMetadata(index.getName())) != null) continue;
                script.add(index.sqlCreateString(dialect, this.mapping, defaultCatalog, defaultSchema));
            }
        }
        iter = this.iterateGenerators(dialect);
        while (iter.hasNext()) {
            PersistentIdentifierGenerator generator = (PersistentIdentifierGenerator)iter.next();
            Object key = generator.generatorKey();
            if (databaseMetadata.isSequence(key) || databaseMetadata.isTable(key)) continue;
            String[] lines = generator.sqlCreateStrings(dialect);
            for (int i = 0; i < lines.length; ++i) {
                script.add(lines[i]);
            }
        }
        return ArrayHelper.toStringArray(script);
    }

    public void validateSchema(Dialect dialect, DatabaseMetadata databaseMetadata) throws HibernateException {
        this.secondPassCompile();
        String defaultCatalog = this.properties.getProperty("hibernate.default_catalog");
        String defaultSchema = this.properties.getProperty("hibernate.default_schema");
        Iterator iter = this.getTableMappings();
        while (iter.hasNext()) {
            Table table = (Table)iter.next();
            if (!table.isPhysicalTable()) continue;
            TableMetadata tableInfo = databaseMetadata.getTableMetadata(table.getName(), table.getSchema() == null ? defaultSchema : table.getSchema(), table.getCatalog() == null ? defaultCatalog : table.getCatalog(), table.isQuoted());
            if (tableInfo == null) {
                throw new HibernateException("Missing table: " + table.getName());
            }
            table.validateColumns(dialect, this.mapping, tableInfo);
        }
        iter = this.iterateGenerators(dialect);
        while (iter.hasNext()) {
            PersistentIdentifierGenerator generator = (PersistentIdentifierGenerator)iter.next();
            Object key = generator.generatorKey();
            if (databaseMetadata.isSequence(key) || databaseMetadata.isTable(key)) continue;
            throw new HibernateException("Missing sequence or table: " + key);
        }
    }

    private void validate() throws MappingException {
        Iterator iter = this.classes.values().iterator();
        while (iter.hasNext()) {
            ((PersistentClass)iter.next()).validate(this.mapping);
        }
        iter = this.collections.values().iterator();
        while (iter.hasNext()) {
            ((Collection)iter.next()).validate(this.mapping);
        }
    }

    public void buildMappings() {
        this.secondPassCompile();
    }

    protected void secondPassCompile() throws MappingException {
        SecondPass sp;
        log.debug("processing extends queue");
        this.processExtendsQueue();
        log.debug("processing collection mappings");
        Iterator iter = this.secondPasses.iterator();
        while (iter.hasNext()) {
            sp = (SecondPass)iter.next();
            if (sp instanceof QuerySecondPass) continue;
            sp.doSecondPass(this.classes);
            iter.remove();
        }
        log.debug("processing native query and ResultSetMapping mappings");
        iter = this.secondPasses.iterator();
        while (iter.hasNext()) {
            sp = (SecondPass)iter.next();
            sp.doSecondPass(this.classes);
            iter.remove();
        }
        log.debug("processing association property references");
        iter = this.propertyReferences.iterator();
        while (iter.hasNext()) {
            Mappings.PropertyReference upr = (Mappings.PropertyReference)iter.next();
            PersistentClass clazz = this.getClassMapping(upr.referencedClass);
            if (clazz == null) {
                throw new MappingException("property-ref to unmapped class: " + upr.referencedClass);
            }
            Property prop = clazz.getReferencedProperty(upr.propertyName);
            if (!upr.unique) continue;
            ((SimpleValue)prop.getValue()).setAlternateUniqueKey(true);
        }
        log.debug("processing foreign key constraints");
        iter = this.getTableMappings();
        HashSet done = new HashSet();
        while (iter.hasNext()) {
            this.secondPassCompileForeignKeys((Table)iter.next(), done);
        }
    }

    private void processExtendsQueue() {
        Document document = this.findPossibleExtends();
        while (document != null) {
            this.add(document);
            document = this.findPossibleExtends();
        }
        if (this.extendsQueue.size() > 0) {
            Iterator iterator = this.extendsQueue.keySet().iterator();
            StringBuffer buf = new StringBuffer("Following superclasses referenced in extends not found: ");
            while (iterator.hasNext()) {
                ExtendsQueueEntry entry = (ExtendsQueueEntry)iterator.next();
                buf.append(entry.getExplicitName());
                if (entry.getMappingPackage() != null) {
                    buf.append("[").append(entry.getMappingPackage()).append("]");
                }
                if (!iterator.hasNext()) continue;
                buf.append(",");
            }
            throw new MappingException(buf.toString());
        }
    }

    protected Document findPossibleExtends() {
        Iterator iter = this.extendsQueue.keySet().iterator();
        while (iter.hasNext()) {
            ExtendsQueueEntry entry = (ExtendsQueueEntry)iter.next();
            if (this.getClassMapping(entry.getExplicitName()) != null) {
                iter.remove();
                return entry.getDocument();
            }
            if (this.getClassMapping(HbmBinder.getClassName(entry.getExplicitName(), entry.getMappingPackage())) == null) continue;
            iter.remove();
            return entry.getDocument();
        }
        return null;
    }

    protected void secondPassCompileForeignKeys(Table table, Set done) throws MappingException {
        table.createForeignKeys();
        Iterator iter = table.getForeignKeyIterator();
        while (iter.hasNext()) {
            PersistentClass referencedClass;
            ForeignKey fk = (ForeignKey)iter.next();
            if (done.contains(fk)) continue;
            done.add(fk);
            String referencedEntityName = fk.getReferencedEntityName();
            if (referencedEntityName == null) {
                throw new MappingException("An association from the table " + fk.getTable().getName() + " does not specify the referenced entity");
            }
            if (log.isDebugEnabled()) {
                log.debug("resolving reference to class: " + referencedEntityName);
            }
            if ((referencedClass = (PersistentClass)this.classes.get(referencedEntityName)) == null) {
                throw new MappingException("An association from the table " + fk.getTable().getName() + " refers to an unmapped class: " + referencedEntityName);
            }
            if (referencedClass.isJoinedSubclass()) {
                this.secondPassCompileForeignKeys(referencedClass.getSuperclass().getTable(), done);
            }
            fk.setReferencedTable(referencedClass.getTable());
            fk.alignColumns();
        }
    }

    public Map getNamedQueries() {
        return this.namedQueries;
    }

    public SessionFactory buildSessionFactory() throws HibernateException {
        log.debug("Preparing to build session factory with filters : " + this.filterDefinitions);
        this.secondPassCompile();
        this.validate();
        Environment.verifyProperties(this.properties);
        Properties copy = new Properties();
        copy.putAll((Map<?, ?>)this.properties);
        PropertiesHelper.resolvePlaceHolders(copy);
        Settings settings = this.buildSettings(copy);
        return new SessionFactoryImpl(this, this.mapping, settings, this.getInitializedEventListeners(), this.sessionFactoryObserver);
    }

    private EventListeners getInitializedEventListeners() {
        EventListeners result = (EventListeners)this.eventListeners.shallowCopy();
        result.initializeListeners(this);
        return result;
    }

    public Interceptor getInterceptor() {
        return this.interceptor;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public Configuration setInterceptor(Interceptor interceptor) {
        this.interceptor = interceptor;
        return this;
    }

    public Configuration setProperties(Properties properties) {
        this.properties = properties;
        return this;
    }

    public Configuration addProperties(Properties extraProperties) {
        this.properties.putAll((Map<?, ?>)extraProperties);
        return this;
    }

    public Configuration mergeProperties(Properties properties) {
        Iterator<Map.Entry<Object, Object>> itr = properties.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<Object, Object> entry = itr.next();
            if (this.properties.containsKey(entry.getKey())) continue;
            this.properties.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        return this;
    }

    public Configuration setProperty(String propertyName, String value) {
        this.properties.setProperty(propertyName, value);
        return this;
    }

    public String getProperty(String propertyName) {
        return this.properties.getProperty(propertyName);
    }

    private void addProperties(Element parent) {
        Iterator iter = parent.elementIterator("property");
        while (iter.hasNext()) {
            Element node = (Element)iter.next();
            String name = node.attributeValue("name");
            String value = node.getText().trim();
            log.debug(name + "=" + value);
            this.properties.setProperty(name, value);
            if (name.startsWith("hibernate")) continue;
            this.properties.setProperty("hibernate." + name, value);
        }
        Environment.verifyProperties(this.properties);
    }

    protected InputStream getConfigurationInputStream(String resource) throws HibernateException {
        log.info("Configuration resource: " + resource);
        return ConfigHelper.getResourceAsStream(resource);
    }

    public Configuration configure() throws HibernateException {
        this.configure("/hibernate.cfg.xml");
        return this;
    }

    public Configuration configure(String resource) throws HibernateException {
        log.info("configuring from resource: " + resource);
        InputStream stream = this.getConfigurationInputStream(resource);
        return this.doConfigure(stream, resource);
    }

    public Configuration configure(URL url) throws HibernateException {
        log.info("configuring from url: " + url.toString());
        try {
            return this.doConfigure(url.openStream(), url.toString());
        }
        catch (IOException ioe) {
            throw new HibernateException("could not configure from URL: " + url, ioe);
        }
    }

    public Configuration configure(File configFile) throws HibernateException {
        log.info("configuring from file: " + configFile.getName());
        try {
            return this.doConfigure(new FileInputStream(configFile), configFile.toString());
        }
        catch (FileNotFoundException fnfe) {
            throw new HibernateException("could not find file: " + configFile, fnfe);
        }
    }

    protected Configuration doConfigure(InputStream stream, String resourceName) throws HibernateException {
        Document doc;
        try {
            ArrayList errors = new ArrayList();
            doc = this.xmlHelper.createSAXReader(resourceName, errors, this.entityResolver).read(new InputSource(stream));
            if (errors.size() != 0) {
                throw new MappingException("invalid configuration", (Throwable)errors.get(0));
            }
        }
        catch (DocumentException e) {
            throw new HibernateException("Could not parse configuration: " + resourceName, e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException ioe) {
                log.warn("could not close input stream for: " + resourceName, (Throwable)ioe);
            }
        }
        return this.doConfigure(doc);
    }

    public Configuration configure(org.w3c.dom.Document document) throws HibernateException {
        log.info("configuring from XML document");
        return this.doConfigure(this.xmlHelper.createDOMReader().read(document));
    }

    protected Configuration doConfigure(Document doc) throws HibernateException {
        Element sfNode = doc.getRootElement().element("session-factory");
        String name = sfNode.attributeValue("name");
        if (name != null) {
            this.properties.setProperty("hibernate.session_factory_name", name);
        }
        this.addProperties(sfNode);
        this.parseSessionFactory(sfNode, name);
        Element secNode = doc.getRootElement().element("security");
        if (secNode != null) {
            this.parseSecurity(secNode);
        }
        log.info("Configured SessionFactory: " + name);
        log.debug("properties: " + this.properties);
        return this;
    }

    private void parseSessionFactory(Element sfNode, String name) {
        Iterator elements = sfNode.elementIterator();
        while (elements.hasNext()) {
            String region;
            Attribute regionNode;
            Element subelement = (Element)elements.next();
            String subelementName = subelement.getName();
            if ("mapping".equals(subelementName)) {
                this.parseMappingElement(subelement, name);
                continue;
            }
            if ("class-cache".equals(subelementName)) {
                String className = subelement.attributeValue("class");
                regionNode = subelement.attribute("region");
                region = regionNode == null ? className : regionNode.getValue();
                boolean includeLazy = !"non-lazy".equals(subelement.attributeValue("include"));
                this.setCacheConcurrencyStrategy(className, subelement.attributeValue("usage"), region, includeLazy);
                continue;
            }
            if ("collection-cache".equals(subelementName)) {
                String role = subelement.attributeValue("collection");
                regionNode = subelement.attribute("region");
                region = regionNode == null ? role : regionNode.getValue();
                this.setCollectionCacheConcurrencyStrategy(role, subelement.attributeValue("usage"), region);
                continue;
            }
            if ("listener".equals(subelementName)) {
                this.parseListener(subelement);
                continue;
            }
            if (!"event".equals(subelementName)) continue;
            this.parseEvent(subelement);
        }
    }

    protected void parseMappingElement(Element subelement, String name) {
        Attribute rsrc = subelement.attribute("resource");
        Attribute file = subelement.attribute("file");
        Attribute jar = subelement.attribute("jar");
        Attribute pkg = subelement.attribute("package");
        Attribute clazz = subelement.attribute("class");
        if (rsrc != null) {
            log.debug(name + "<-" + rsrc);
            this.addResource(rsrc.getValue());
        } else if (jar != null) {
            log.debug(name + "<-" + jar);
            this.addJar(new File(jar.getValue()));
        } else {
            if (pkg != null) {
                throw new MappingException("An AnnotationConfiguration instance is required to use <mapping package=\"" + pkg.getValue() + "\"/>");
            }
            if (clazz != null) {
                throw new MappingException("An AnnotationConfiguration instance is required to use <mapping class=\"" + clazz.getValue() + "\"/>");
            }
            if (file == null) {
                throw new MappingException("<mapping> element in configuration specifies no attributes");
            }
            log.debug(name + "<-" + file);
            this.addFile(file.getValue());
        }
    }

    private void parseSecurity(Element secNode) {
        String contextId = secNode.attributeValue("context");
        this.setProperty("hibernate.jacc_context_id", contextId);
        log.info("JACC contextID: " + contextId);
        JACCConfiguration jcfg = new JACCConfiguration(contextId);
        Iterator grantElements = secNode.elementIterator();
        while (grantElements.hasNext()) {
            Element grantElement = (Element)grantElements.next();
            String elementName = grantElement.getName();
            if (!"grant".equals(elementName)) continue;
            jcfg.addPermission(grantElement.attributeValue("role"), grantElement.attributeValue("entity-name"), grantElement.attributeValue("actions"));
        }
    }

    private void parseEvent(Element element) {
        String type = element.attributeValue("type");
        List listeners = element.elements();
        Object[] listenerClasses = new String[listeners.size()];
        for (int i = 0; i < listeners.size(); ++i) {
            listenerClasses[i] = ((Element)listeners.get(i)).attributeValue("class");
        }
        log.debug("Event listeners: " + type + "=" + StringHelper.toString(listenerClasses));
        this.setListeners(type, (String[])listenerClasses);
    }

    private void parseListener(Element element) {
        String type = element.attributeValue("type");
        if (type == null) {
            throw new MappingException("No type specified for listener");
        }
        String impl = element.attributeValue("class");
        log.debug("Event listener: " + type + "=" + impl);
        this.setListeners(type, new String[]{impl});
    }

    public void setListener(String type, String listener) {
        String[] listeners = null;
        if (listener != null) {
            listeners = (String[])Array.newInstance(String.class, 1);
            listeners[0] = listener;
        }
        this.setListeners(type, listeners);
    }

    public void setListeners(String type, String[] listenerClasses) {
        Object[] listeners = null;
        if (listenerClasses != null) {
            listeners = (Object[])Array.newInstance(this.eventListeners.getListenerClassFor(type), listenerClasses.length);
            for (int i = 0; i < listeners.length; ++i) {
                try {
                    listeners[i] = ReflectHelper.classForName(listenerClasses[i]).newInstance();
                    continue;
                }
                catch (Exception e) {
                    throw new MappingException("Unable to instantiate specified event (" + type + ") listener class: " + listenerClasses[i], e);
                }
            }
        }
        this.setListeners(type, listeners);
    }

    public void setListener(String type, Object listener) {
        Object[] listeners = null;
        if (listener != null) {
            listeners = (Object[])Array.newInstance(this.eventListeners.getListenerClassFor(type), 1);
            listeners[0] = listener;
        }
        this.setListeners(type, listeners);
    }

    public void setListeners(String type, Object[] listeners) {
        if ("auto-flush".equals(type)) {
            if (listeners == null) {
                this.eventListeners.setAutoFlushEventListeners(new AutoFlushEventListener[0]);
            } else {
                this.eventListeners.setAutoFlushEventListeners((AutoFlushEventListener[])listeners);
            }
        } else if ("merge".equals(type)) {
            if (listeners == null) {
                this.eventListeners.setMergeEventListeners(new MergeEventListener[0]);
            } else {
                this.eventListeners.setMergeEventListeners((MergeEventListener[])listeners);
            }
        } else if ("create".equals(type)) {
            if (listeners == null) {
                this.eventListeners.setPersistEventListeners(new PersistEventListener[0]);
            } else {
                this.eventListeners.setPersistEventListeners((PersistEventListener[])listeners);
            }
        } else if ("create-onflush".equals(type)) {
            if (listeners == null) {
                this.eventListeners.setPersistOnFlushEventListeners(new PersistEventListener[0]);
            } else {
                this.eventListeners.setPersistOnFlushEventListeners((PersistEventListener[])listeners);
            }
        } else if ("delete".equals(type)) {
            if (listeners == null) {
                this.eventListeners.setDeleteEventListeners(new DeleteEventListener[0]);
            } else {
                this.eventListeners.setDeleteEventListeners((DeleteEventListener[])listeners);
            }
        } else if ("dirty-check".equals(type)) {
            if (listeners == null) {
                this.eventListeners.setDirtyCheckEventListeners(new DirtyCheckEventListener[0]);
            } else {
                this.eventListeners.setDirtyCheckEventListeners((DirtyCheckEventListener[])listeners);
            }
        } else if ("evict".equals(type)) {
            if (listeners == null) {
                this.eventListeners.setEvictEventListeners(new EvictEventListener[0]);
            } else {
                this.eventListeners.setEvictEventListeners((EvictEventListener[])listeners);
            }
        } else if ("flush".equals(type)) {
            if (listeners == null) {
                this.eventListeners.setFlushEventListeners(new FlushEventListener[0]);
            } else {
                this.eventListeners.setFlushEventListeners((FlushEventListener[])listeners);
            }
        } else if ("flush-entity".equals(type)) {
            if (listeners == null) {
                this.eventListeners.setFlushEntityEventListeners(new FlushEntityEventListener[0]);
            } else {
                this.eventListeners.setFlushEntityEventListeners((FlushEntityEventListener[])listeners);
            }
        } else if ("load".equals(type)) {
            if (listeners == null) {
                this.eventListeners.setLoadEventListeners(new LoadEventListener[0]);
            } else {
                this.eventListeners.setLoadEventListeners((LoadEventListener[])listeners);
            }
        } else if ("load-collection".equals(type)) {
            if (listeners == null) {
                this.eventListeners.setInitializeCollectionEventListeners(new InitializeCollectionEventListener[0]);
            } else {
                this.eventListeners.setInitializeCollectionEventListeners((InitializeCollectionEventListener[])listeners);
            }
        } else if ("lock".equals(type)) {
            if (listeners == null) {
                this.eventListeners.setLockEventListeners(new LockEventListener[0]);
            } else {
                this.eventListeners.setLockEventListeners((LockEventListener[])listeners);
            }
        } else if ("refresh".equals(type)) {
            if (listeners == null) {
                this.eventListeners.setRefreshEventListeners(new RefreshEventListener[0]);
            } else {
                this.eventListeners.setRefreshEventListeners((RefreshEventListener[])listeners);
            }
        } else if ("replicate".equals(type)) {
            if (listeners == null) {
                this.eventListeners.setReplicateEventListeners(new ReplicateEventListener[0]);
            } else {
                this.eventListeners.setReplicateEventListeners((ReplicateEventListener[])listeners);
            }
        } else if ("save-update".equals(type)) {
            if (listeners == null) {
                this.eventListeners.setSaveOrUpdateEventListeners(new SaveOrUpdateEventListener[0]);
            } else {
                this.eventListeners.setSaveOrUpdateEventListeners((SaveOrUpdateEventListener[])listeners);
            }
        } else if ("save".equals(type)) {
            if (listeners == null) {
                this.eventListeners.setSaveEventListeners(new SaveOrUpdateEventListener[0]);
            } else {
                this.eventListeners.setSaveEventListeners((SaveOrUpdateEventListener[])listeners);
            }
        } else if ("update".equals(type)) {
            if (listeners == null) {
                this.eventListeners.setUpdateEventListeners(new SaveOrUpdateEventListener[0]);
            } else {
                this.eventListeners.setUpdateEventListeners((SaveOrUpdateEventListener[])listeners);
            }
        } else if ("pre-load".equals(type)) {
            if (listeners == null) {
                this.eventListeners.setPreLoadEventListeners(new PreLoadEventListener[0]);
            } else {
                this.eventListeners.setPreLoadEventListeners((PreLoadEventListener[])listeners);
            }
        } else if ("pre-update".equals(type)) {
            if (listeners == null) {
                this.eventListeners.setPreUpdateEventListeners(new PreUpdateEventListener[0]);
            } else {
                this.eventListeners.setPreUpdateEventListeners((PreUpdateEventListener[])listeners);
            }
        } else if ("pre-delete".equals(type)) {
            if (listeners == null) {
                this.eventListeners.setPreDeleteEventListeners(new PreDeleteEventListener[0]);
            } else {
                this.eventListeners.setPreDeleteEventListeners((PreDeleteEventListener[])listeners);
            }
        } else if ("pre-insert".equals(type)) {
            if (listeners == null) {
                this.eventListeners.setPreInsertEventListeners(new PreInsertEventListener[0]);
            } else {
                this.eventListeners.setPreInsertEventListeners((PreInsertEventListener[])listeners);
            }
        } else if ("pre-collection-recreate".equals(type)) {
            if (listeners == null) {
                this.eventListeners.setPreCollectionRecreateEventListeners(new PreCollectionRecreateEventListener[0]);
            } else {
                this.eventListeners.setPreCollectionRecreateEventListeners((PreCollectionRecreateEventListener[])listeners);
            }
        } else if ("pre-collection-remove".equals(type)) {
            if (listeners == null) {
                this.eventListeners.setPreCollectionRemoveEventListeners(new PreCollectionRemoveEventListener[0]);
            } else {
                this.eventListeners.setPreCollectionRemoveEventListeners((PreCollectionRemoveEventListener[])listeners);
            }
        } else if ("pre-collection-update".equals(type)) {
            if (listeners == null) {
                this.eventListeners.setPreCollectionUpdateEventListeners(new PreCollectionUpdateEventListener[0]);
            } else {
                this.eventListeners.setPreCollectionUpdateEventListeners((PreCollectionUpdateEventListener[])listeners);
            }
        } else if ("post-load".equals(type)) {
            if (listeners == null) {
                this.eventListeners.setPostLoadEventListeners(new PostLoadEventListener[0]);
            } else {
                this.eventListeners.setPostLoadEventListeners((PostLoadEventListener[])listeners);
            }
        } else if ("post-update".equals(type)) {
            if (listeners == null) {
                this.eventListeners.setPostUpdateEventListeners(new PostUpdateEventListener[0]);
            } else {
                this.eventListeners.setPostUpdateEventListeners((PostUpdateEventListener[])listeners);
            }
        } else if ("post-delete".equals(type)) {
            if (listeners == null) {
                this.eventListeners.setPostDeleteEventListeners(new PostDeleteEventListener[0]);
            } else {
                this.eventListeners.setPostDeleteEventListeners((PostDeleteEventListener[])listeners);
            }
        } else if ("post-insert".equals(type)) {
            if (listeners == null) {
                this.eventListeners.setPostInsertEventListeners(new PostInsertEventListener[0]);
            } else {
                this.eventListeners.setPostInsertEventListeners((PostInsertEventListener[])listeners);
            }
        } else if ("post-commit-update".equals(type)) {
            if (listeners == null) {
                this.eventListeners.setPostCommitUpdateEventListeners(new PostUpdateEventListener[0]);
            } else {
                this.eventListeners.setPostCommitUpdateEventListeners((PostUpdateEventListener[])listeners);
            }
        } else if ("post-commit-delete".equals(type)) {
            if (listeners == null) {
                this.eventListeners.setPostCommitDeleteEventListeners(new PostDeleteEventListener[0]);
            } else {
                this.eventListeners.setPostCommitDeleteEventListeners((PostDeleteEventListener[])listeners);
            }
        } else if ("post-commit-insert".equals(type)) {
            if (listeners == null) {
                this.eventListeners.setPostCommitInsertEventListeners(new PostInsertEventListener[0]);
            } else {
                this.eventListeners.setPostCommitInsertEventListeners((PostInsertEventListener[])listeners);
            }
        } else if ("post-collection-recreate".equals(type)) {
            if (listeners == null) {
                this.eventListeners.setPostCollectionRecreateEventListeners(new PostCollectionRecreateEventListener[0]);
            } else {
                this.eventListeners.setPostCollectionRecreateEventListeners((PostCollectionRecreateEventListener[])listeners);
            }
        } else if ("post-collection-remove".equals(type)) {
            if (listeners == null) {
                this.eventListeners.setPostCollectionRemoveEventListeners(new PostCollectionRemoveEventListener[0]);
            } else {
                this.eventListeners.setPostCollectionRemoveEventListeners((PostCollectionRemoveEventListener[])listeners);
            }
        } else if ("post-collection-update".equals(type)) {
            if (listeners == null) {
                this.eventListeners.setPostCollectionUpdateEventListeners(new PostCollectionUpdateEventListener[0]);
            } else {
                this.eventListeners.setPostCollectionUpdateEventListeners((PostCollectionUpdateEventListener[])listeners);
            }
        } else {
            throw new MappingException("Unrecognized listener type [" + type + "]");
        }
    }

    public EventListeners getEventListeners() {
        return this.eventListeners;
    }

    RootClass getRootClassMapping(String clazz) throws MappingException {
        try {
            return (RootClass)this.getClassMapping(clazz);
        }
        catch (ClassCastException cce) {
            throw new MappingException("You may only specify a cache for root <class> mappings");
        }
    }

    public Configuration setCacheConcurrencyStrategy(String clazz, String concurrencyStrategy) throws MappingException {
        this.setCacheConcurrencyStrategy(clazz, concurrencyStrategy, clazz);
        return this;
    }

    public void setCacheConcurrencyStrategy(String clazz, String concurrencyStrategy, String region) throws MappingException {
        this.setCacheConcurrencyStrategy(clazz, concurrencyStrategy, region, true);
    }

    void setCacheConcurrencyStrategy(String clazz, String concurrencyStrategy, String region, boolean includeLazy) throws MappingException {
        RootClass rootClass = this.getRootClassMapping(clazz);
        if (rootClass == null) {
            throw new MappingException("Cannot cache an unknown entity: " + clazz);
        }
        rootClass.setCacheConcurrencyStrategy(concurrencyStrategy);
        rootClass.setCacheRegionName(region);
        rootClass.setLazyPropertiesCacheable(includeLazy);
    }

    public Configuration setCollectionCacheConcurrencyStrategy(String collectionRole, String concurrencyStrategy) throws MappingException {
        this.setCollectionCacheConcurrencyStrategy(collectionRole, concurrencyStrategy, collectionRole);
        return this;
    }

    public void setCollectionCacheConcurrencyStrategy(String collectionRole, String concurrencyStrategy, String region) throws MappingException {
        Collection collection = this.getCollectionMapping(collectionRole);
        if (collection == null) {
            throw new MappingException("Cannot cache an unknown collection: " + collectionRole);
        }
        collection.setCacheConcurrencyStrategy(concurrencyStrategy);
        collection.setCacheRegionName(region);
    }

    public Map getImports() {
        return this.imports;
    }

    public Settings buildSettings() throws HibernateException {
        Properties clone = (Properties)this.properties.clone();
        PropertiesHelper.resolvePlaceHolders(clone);
        return this.buildSettingsInternal(clone);
    }

    public Settings buildSettings(Properties props) throws HibernateException {
        return this.buildSettingsInternal(props);
    }

    private Settings buildSettingsInternal(Properties props) {
        Settings settings = this.settingsFactory.buildSettings(props);
        settings.setEntityTuplizerFactory(this.getEntityTuplizerFactory());
        return settings;
    }

    public Map getNamedSQLQueries() {
        return this.namedSqlQueries;
    }

    public Map getSqlResultSetMappings() {
        return this.sqlResultSetMappings;
    }

    public NamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    public Configuration setNamingStrategy(NamingStrategy namingStrategy) {
        this.namingStrategy = namingStrategy;
        return this;
    }

    public DefaultIdentifierGeneratorFactory getIdentifierGeneratorFactory() {
        return this.identifierGeneratorFactory;
    }

    public Mapping buildMapping() {
        return new Mapping(){

            public IdentifierGeneratorFactory getIdentifierGeneratorFactory() {
                return Configuration.this.identifierGeneratorFactory;
            }

            public Type getIdentifierType(String persistentClass) throws MappingException {
                PersistentClass pc = (PersistentClass)Configuration.this.classes.get(persistentClass);
                if (pc == null) {
                    throw new MappingException("persistent class not known: " + persistentClass);
                }
                return pc.getIdentifier().getType();
            }

            public String getIdentifierPropertyName(String persistentClass) throws MappingException {
                PersistentClass pc = (PersistentClass)Configuration.this.classes.get(persistentClass);
                if (pc == null) {
                    throw new MappingException("persistent class not known: " + persistentClass);
                }
                if (!pc.hasIdentifierProperty()) {
                    return null;
                }
                return pc.getIdentifierProperty().getName();
            }

            public Type getReferencedPropertyType(String persistentClass, String propertyName) throws MappingException {
                PersistentClass pc = (PersistentClass)Configuration.this.classes.get(persistentClass);
                if (pc == null) {
                    throw new MappingException("persistent class not known: " + persistentClass);
                }
                Property prop = pc.getReferencedProperty(propertyName);
                if (prop == null) {
                    throw new MappingException("property not known: " + persistentClass + '.' + propertyName);
                }
                return prop.getType();
            }
        };
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.mapping = this.buildMapping();
        this.xmlHelper = new XMLHelper();
    }

    public Map getFilterDefinitions() {
        return this.filterDefinitions;
    }

    public void addFilterDefinition(FilterDefinition definition) {
        this.filterDefinitions.put(definition.getFilterName(), definition);
    }

    public Iterator iterateFetchProfiles() {
        return this.fetchProfiles.values().iterator();
    }

    public void addFetchProfile(FetchProfile fetchProfile) {
        this.fetchProfiles.put(fetchProfile.getName(), fetchProfile);
    }

    public void addAuxiliaryDatabaseObject(AuxiliaryDatabaseObject object) {
        this.auxiliaryDatabaseObjects.add(object);
    }

    public Map getSqlFunctions() {
        return this.sqlFunctions;
    }

    public void addSqlFunction(String functionName, SQLFunction function) {
        this.sqlFunctions.put(functionName, function);
    }

    public SessionFactoryObserver getSessionFactoryObserver() {
        return this.sessionFactoryObserver;
    }

    public void setSessionFactoryObserver(SessionFactoryObserver sessionFactoryObserver) {
        this.sessionFactoryObserver = sessionFactoryObserver;
    }

    final class ObjectNameNormalizerImpl
    extends ObjectNameNormalizer
    implements Serializable {
        ObjectNameNormalizerImpl() {
        }

        public boolean isUseQuotedIdentifiersGlobally() {
            String setting = (String)Configuration.this.properties.get("hibernate.globally_quoted_identifiers");
            return setting != null && Boolean.valueOf(setting) != false;
        }

        public NamingStrategy getNamingStrategy() {
            return Configuration.this.namingStrategy;
        }
    }

    protected class MappingsImpl
    implements Mappings,
    Serializable {
        private String schemaName;
        private String catalogName;
        private String defaultPackage;
        private boolean autoImport;
        private boolean defaultLazy;
        private String defaultCascade;
        private String defaultAccess;

        protected MappingsImpl() {
        }

        public String getSchemaName() {
            return this.schemaName;
        }

        public void setSchemaName(String schemaName) {
            this.schemaName = schemaName;
        }

        public String getCatalogName() {
            return this.catalogName;
        }

        public void setCatalogName(String catalogName) {
            this.catalogName = catalogName;
        }

        public String getDefaultPackage() {
            return this.defaultPackage;
        }

        public void setDefaultPackage(String defaultPackage) {
            this.defaultPackage = defaultPackage;
        }

        public boolean isAutoImport() {
            return this.autoImport;
        }

        public void setAutoImport(boolean autoImport) {
            this.autoImport = autoImport;
        }

        public boolean isDefaultLazy() {
            return this.defaultLazy;
        }

        public void setDefaultLazy(boolean defaultLazy) {
            this.defaultLazy = defaultLazy;
        }

        public String getDefaultCascade() {
            return this.defaultCascade;
        }

        public void setDefaultCascade(String defaultCascade) {
            this.defaultCascade = defaultCascade;
        }

        public String getDefaultAccess() {
            return this.defaultAccess;
        }

        public void setDefaultAccess(String defaultAccess) {
            this.defaultAccess = defaultAccess;
        }

        public NamingStrategy getNamingStrategy() {
            return Configuration.this.namingStrategy;
        }

        public void setNamingStrategy(NamingStrategy namingStrategy) {
            Configuration.this.namingStrategy = namingStrategy;
        }

        public Iterator iterateClasses() {
            return Configuration.this.classes.values().iterator();
        }

        public PersistentClass getClass(String entityName) {
            return (PersistentClass)Configuration.this.classes.get(entityName);
        }

        public PersistentClass locatePersistentClassByEntityName(String entityName) {
            String actualEntityName;
            PersistentClass persistentClass = (PersistentClass)Configuration.this.classes.get(entityName);
            if (persistentClass == null && StringHelper.isNotEmpty(actualEntityName = (String)Configuration.this.imports.get(entityName))) {
                persistentClass = (PersistentClass)Configuration.this.classes.get(actualEntityName);
            }
            return persistentClass;
        }

        public void addClass(PersistentClass persistentClass) throws DuplicateMappingException {
            PersistentClass old = Configuration.this.classes.put(persistentClass.getEntityName(), persistentClass);
            if (old != null) {
                throw new DuplicateMappingException("class/entity", persistentClass.getEntityName());
            }
        }

        public void addImport(String entityName, String rename) throws DuplicateMappingException {
            String existing = Configuration.this.imports.put(rename, entityName);
            if (existing != null) {
                if (existing.equals(entityName)) {
                    log.info("duplicate import: {} -> {}", (Object)entityName, (Object)rename);
                } else {
                    throw new DuplicateMappingException("duplicate import: " + rename + " refers to both " + entityName + " and " + existing + " (try using auto-import=\"false\")", "import", rename);
                }
            }
        }

        public Collection getCollection(String role) {
            return (Collection)Configuration.this.collections.get(role);
        }

        public Iterator iterateCollections() {
            return Configuration.this.collections.values().iterator();
        }

        public void addCollection(Collection collection) throws DuplicateMappingException {
            Collection old = Configuration.this.collections.put(collection.getRole(), collection);
            if (old != null) {
                throw new DuplicateMappingException("collection role", collection.getRole());
            }
        }

        public Table getTable(String schema, String catalog, String name) {
            String key = Table.qualify(catalog, schema, name);
            return (Table)Configuration.this.tables.get(key);
        }

        public Iterator iterateTables() {
            return Configuration.this.tables.values().iterator();
        }

        public Table addTable(String schema, String catalog, String name, String subselect, boolean isAbstract) {
            name = this.getObjectNameNormalizer().normalizeIdentifierQuoting(name);
            schema = this.getObjectNameNormalizer().normalizeIdentifierQuoting(schema);
            catalog = this.getObjectNameNormalizer().normalizeIdentifierQuoting(catalog);
            String key = subselect == null ? Table.qualify(catalog, schema, name) : subselect;
            Table table = (Table)Configuration.this.tables.get(key);
            if (table == null) {
                table = new Table();
                table.setAbstract(isAbstract);
                table.setName(name);
                table.setSchema(schema);
                table.setCatalog(catalog);
                table.setSubselect(subselect);
                Configuration.this.tables.put(key, table);
            } else if (!isAbstract) {
                table.setAbstract(false);
            }
            return table;
        }

        public Table addDenormalizedTable(String schema, String catalog, String name, boolean isAbstract, String subselect, Table includedTable) throws DuplicateMappingException {
            String key;
            name = this.getObjectNameNormalizer().normalizeIdentifierQuoting(name);
            schema = this.getObjectNameNormalizer().normalizeIdentifierQuoting(schema);
            catalog = this.getObjectNameNormalizer().normalizeIdentifierQuoting(catalog);
            String string = key = subselect == null ? Table.qualify(catalog, schema, name) : subselect;
            if (Configuration.this.tables.containsKey(key)) {
                throw new DuplicateMappingException("table", name);
            }
            DenormalizedTable table = new DenormalizedTable(includedTable);
            table.setAbstract(isAbstract);
            table.setName(name);
            table.setSchema(schema);
            table.setCatalog(catalog);
            table.setSubselect(subselect);
            Configuration.this.tables.put(key, table);
            return table;
        }

        public NamedQueryDefinition getQuery(String name) {
            return (NamedQueryDefinition)Configuration.this.namedQueries.get(name);
        }

        public void addQuery(String name, NamedQueryDefinition query) throws DuplicateMappingException {
            this.checkQueryName(name);
            Configuration.this.namedQueries.put(name.intern(), query);
        }

        private void checkQueryName(String name) throws DuplicateMappingException {
            if (Configuration.this.namedQueries.containsKey(name) || Configuration.this.namedSqlQueries.containsKey(name)) {
                throw new DuplicateMappingException("query", name);
            }
        }

        public NamedSQLQueryDefinition getSQLQuery(String name) {
            return (NamedSQLQueryDefinition)Configuration.this.namedSqlQueries.get(name);
        }

        public void addSQLQuery(String name, NamedSQLQueryDefinition query) throws DuplicateMappingException {
            this.checkQueryName(name);
            Configuration.this.namedSqlQueries.put(name.intern(), query);
        }

        public ResultSetMappingDefinition getResultSetMapping(String name) {
            return (ResultSetMappingDefinition)Configuration.this.sqlResultSetMappings.get(name);
        }

        public void addResultSetMapping(ResultSetMappingDefinition sqlResultSetMapping) throws DuplicateMappingException {
            ResultSetMappingDefinition old = Configuration.this.sqlResultSetMappings.put(sqlResultSetMapping.getName(), sqlResultSetMapping);
            if (old != null) {
                throw new DuplicateMappingException("resultSet", sqlResultSetMapping.getName());
            }
        }

        protected void removeResultSetMapping(String name) {
            Configuration.this.sqlResultSetMappings.remove(name);
        }

        public TypeDef getTypeDef(String typeName) {
            return (TypeDef)Configuration.this.typeDefs.get(typeName);
        }

        public void addTypeDef(String typeName, String typeClass, Properties paramMap) {
            TypeDef def = new TypeDef(typeClass, paramMap);
            Configuration.this.typeDefs.put(typeName, def);
            log.debug("Added " + typeName + " with class " + typeClass);
        }

        public Map getFilterDefinitions() {
            return Configuration.this.filterDefinitions;
        }

        public FilterDefinition getFilterDefinition(String name) {
            return (FilterDefinition)Configuration.this.filterDefinitions.get(name);
        }

        public void addFilterDefinition(FilterDefinition definition) {
            Configuration.this.filterDefinitions.put(definition.getFilterName(), definition);
        }

        public FetchProfile findOrCreateFetchProfile(String name) {
            FetchProfile profile = (FetchProfile)Configuration.this.fetchProfiles.get(name);
            if (profile == null) {
                profile = new FetchProfile(name);
                Configuration.this.fetchProfiles.put(name, profile);
            }
            return profile;
        }

        public Iterator iterateAuxliaryDatabaseObjects() {
            return Configuration.this.auxiliaryDatabaseObjects.iterator();
        }

        public ListIterator iterateAuxliaryDatabaseObjectsInReverse() {
            return Configuration.this.auxiliaryDatabaseObjects.listIterator(Configuration.this.auxiliaryDatabaseObjects.size());
        }

        public void addAuxiliaryDatabaseObject(AuxiliaryDatabaseObject auxiliaryDatabaseObject) {
            Configuration.this.auxiliaryDatabaseObjects.add(auxiliaryDatabaseObject);
        }

        public String getLogicalTableName(Table table) throws MappingException {
            return this.getLogicalTableName(table.getQuotedSchema(), table.getCatalog(), table.getQuotedName());
        }

        private String getLogicalTableName(String schema, String catalog, String physicalName) throws MappingException {
            String key = this.buildTableNameKey(schema, catalog, physicalName);
            TableDescription descriptor = (TableDescription)Configuration.this.tableNameBinding.get(key);
            if (descriptor == null) {
                throw new MappingException("Unable to find physical table: " + physicalName);
            }
            return descriptor.logicalName;
        }

        public void addTableBinding(String schema, String catalog, String logicalName, String physicalName, Table denormalizedSuperTable) throws DuplicateMappingException {
            TableDescription tableDescription;
            String key = this.buildTableNameKey(schema, catalog, physicalName);
            TableDescription oldDescriptor = Configuration.this.tableNameBinding.put(key, tableDescription = new TableDescription(logicalName, denormalizedSuperTable));
            if (oldDescriptor != null && !oldDescriptor.logicalName.equals(logicalName)) {
                throw new DuplicateMappingException("Same physical table name [" + physicalName + "] references several logical table names: [" + oldDescriptor.logicalName + "], [" + logicalName + ']', "table", physicalName);
            }
        }

        private String buildTableNameKey(String schema, String catalog, String finalName) {
            StringBuffer keyBuilder = new StringBuffer();
            if (schema != null) {
                keyBuilder.append(schema);
            }
            keyBuilder.append(".");
            if (catalog != null) {
                keyBuilder.append(catalog);
            }
            keyBuilder.append(".");
            keyBuilder.append(finalName);
            return keyBuilder.toString();
        }

        public void addColumnBinding(String logicalName, Column physicalColumn, Table table) throws DuplicateMappingException {
            TableColumnNameBinding binding = (TableColumnNameBinding)Configuration.this.columnNameBindingPerTable.get(table);
            if (binding == null) {
                binding = new TableColumnNameBinding(table.getName());
                Configuration.this.columnNameBindingPerTable.put(table, binding);
            }
            binding.addBinding(logicalName, physicalColumn);
        }

        public String getPhysicalColumnName(String logicalName, Table table) throws MappingException {
            logicalName = logicalName.toLowerCase();
            String finalName = null;
            Table currentTable = table;
            do {
                String key;
                TableDescription description;
                TableColumnNameBinding binding;
                if ((binding = (TableColumnNameBinding)Configuration.this.columnNameBindingPerTable.get(currentTable)) != null) {
                    finalName = (String)binding.logicalToPhysical.get(logicalName);
                }
                if ((description = (TableDescription)Configuration.this.tableNameBinding.get(key = this.buildTableNameKey(currentTable.getSchema(), currentTable.getCatalog(), currentTable.getName()))) == null) continue;
                currentTable = description.denormalizedSupertable;
            } while (finalName == null && currentTable != null);
            if (finalName == null) {
                throw new MappingException("Unable to find column with logical name " + logicalName + " in table " + table.getName());
            }
            return finalName;
        }

        public String getLogicalColumnName(String physicalName, Table table) throws MappingException {
            String logical = null;
            Table currentTable = table;
            TableDescription description = null;
            do {
                String key;
                TableColumnNameBinding binding;
                if ((binding = (TableColumnNameBinding)Configuration.this.columnNameBindingPerTable.get(currentTable)) != null) {
                    logical = (String)binding.physicalToLogical.get(physicalName);
                }
                if ((description = (TableDescription)Configuration.this.tableNameBinding.get(key = this.buildTableNameKey(currentTable.getSchema(), currentTable.getCatalog(), currentTable.getName()))) == null) continue;
                currentTable = description.denormalizedSupertable;
            } while (logical == null && currentTable != null && description != null);
            if (logical == null) {
                throw new MappingException("Unable to find logical column name from physical name " + physicalName + " in table " + table.getName());
            }
            return logical;
        }

        public void addSecondPass(SecondPass sp) {
            this.addSecondPass(sp, false);
        }

        public void addSecondPass(SecondPass sp, boolean onTopOfTheQueue) {
            if (onTopOfTheQueue) {
                Configuration.this.secondPasses.add(0, sp);
            } else {
                Configuration.this.secondPasses.add(sp);
            }
        }

        public void addPropertyReference(String referencedClass, String propertyName) {
            Configuration.this.propertyReferences.add(new Mappings.PropertyReference(referencedClass, propertyName, false));
        }

        public void addUniquePropertyReference(String referencedClass, String propertyName) {
            Configuration.this.propertyReferences.add(new Mappings.PropertyReference(referencedClass, propertyName, true));
        }

        public void addToExtendsQueue(ExtendsQueueEntry entry) {
            Configuration.this.extendsQueue.put(entry, null);
        }

        public DefaultIdentifierGeneratorFactory getIdentifierGeneratorFactory() {
            return Configuration.this.identifierGeneratorFactory;
        }

        public void addMappedSuperclass(Class type, MappedSuperclass mappedSuperclass) {
            Configuration.this.mappedSuperclasses.put(type, mappedSuperclass);
        }

        public MappedSuperclass getMappedSuperclass(Class type) {
            return (MappedSuperclass)Configuration.this.mappedSuperclasses.get(type);
        }

        public ObjectNameNormalizer getObjectNameNormalizer() {
            return Configuration.this.normalizer;
        }

        private class TableColumnNameBinding
        implements Serializable {
            private final String tableName;
            private Map logicalToPhysical = new HashMap();
            private Map physicalToLogical = new HashMap();

            private TableColumnNameBinding(String tableName) {
                this.tableName = tableName;
            }

            public void addBinding(String logicalName, Column physicalColumn) {
                this.bindLogicalToPhysical(logicalName, physicalColumn);
                this.bindPhysicalToLogical(logicalName, physicalColumn);
            }

            private void bindLogicalToPhysical(String logicalName, Column physicalColumn) throws DuplicateMappingException {
                String physicalName;
                String logicalKey = logicalName.toLowerCase();
                String existingPhysicalName = this.logicalToPhysical.put(logicalKey, physicalName = physicalColumn.getQuotedName());
                if (existingPhysicalName != null) {
                    boolean areSamePhysicalColumn;
                    boolean bl = areSamePhysicalColumn = physicalColumn.isQuoted() ? existingPhysicalName.equals(physicalName) : existingPhysicalName.equalsIgnoreCase(physicalName);
                    if (!areSamePhysicalColumn) {
                        throw new DuplicateMappingException(" Table [" + this.tableName + "] contains logical column name [" + logicalName + "] referenced by multiple physical column names: [" + existingPhysicalName + "], [" + physicalName + "]", "column-binding", this.tableName + "." + logicalName);
                    }
                }
            }

            private void bindPhysicalToLogical(String logicalName, Column physicalColumn) throws DuplicateMappingException {
                String physicalName = physicalColumn.getQuotedName();
                String existingLogicalName = this.physicalToLogical.put(physicalName, logicalName);
                if (existingLogicalName != null && !existingLogicalName.equals(logicalName)) {
                    throw new DuplicateMappingException(" Table [" + this.tableName + "] contains phyical column name [" + physicalName + "] represented by different logical column names: [" + existingLogicalName + "], [" + logicalName + "]", "column-binding", this.tableName + "." + physicalName);
                }
            }
        }

        private class TableDescription
        implements Serializable {
            final String logicalName;
            final Table denormalizedSupertable;

            TableDescription(String logicalName, Table denormalizedSupertable) {
                this.logicalName = logicalName;
                this.denormalizedSupertable = denormalizedSupertable;
            }
        }
    }
}

