/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.action;

import org.hibernate.OptimisticLockException;
import org.hibernate.action.BeforeTransactionCompletionProcess;
import org.hibernate.engine.EntityEntry;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.persister.entity.EntityPersister;

public class EntityVerifyVersionProcess
implements BeforeTransactionCompletionProcess {
    private final Object object;
    private final EntityEntry entry;

    public EntityVerifyVersionProcess(Object object, EntityEntry entry) {
        this.object = object;
        this.entry = entry;
    }

    public void doBeforeTransactionCompletion(SessionImplementor session) {
        EntityPersister persister = this.entry.getPersister();
        Object latestVersion = persister.getCurrentVersion(this.entry.getId(), session);
        if (!this.entry.getVersion().equals(latestVersion)) {
            throw new OptimisticLockException("Newer version (" + latestVersion + ") of entity (" + this.entry.getEntityName() + ") found in database.  id=" + this.entry.getId());
        }
    }
}

