/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.LockMode;

public class LockOptions {
    public static final int NO_WAIT = 0;
    public static final int WAIT_FOREVER = -1;
    public static final LockOptions NONE = new LockOptions(LockMode.NONE);
    public static final LockOptions READ = new LockOptions(LockMode.READ);
    public static final LockOptions UPGRADE = new LockOptions(LockMode.UPGRADE);
    private LockMode lockMode = LockMode.NONE;
    private int timeout = -1;
    private boolean scope = false;
    private Map lockModesByName = new HashMap();

    public LockOptions() {
    }

    public LockOptions(LockMode lockMode) {
        this.lockMode = lockMode;
    }

    public LockMode getLockMode() {
        return this.lockMode;
    }

    public LockOptions setLockMode(LockMode lockMode) {
        this.lockMode = lockMode;
        return this;
    }

    public LockOptions setAliasLockMode(LockMode lockMode, String alias) {
        this.lockModesByName.put(alias, lockMode);
        return this;
    }

    public LockMode getAliasLockMode(String alias) {
        return (LockMode)this.lockModesByName.get(alias);
    }

    public int getAliasLockCount() {
        return this.lockModesByName.size();
    }

    public Iterator getAliasLockIterator() {
        return this.lockModesByName.entrySet().iterator();
    }

    public int getTimeOut() {
        return this.timeout;
    }

    public LockOptions setTimeOut(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public boolean getScope() {
        return this.scope;
    }

    public LockOptions setScope(boolean scope) {
        this.scope = scope;
        return this;
    }

    public static LockOptions copy(LockOptions from, LockOptions dest) {
        dest.setLockMode(from.getLockMode());
        dest.setScope(from.getScope());
        dest.setTimeOut(from.getTimeOut());
        dest.lockModesByName = new HashMap(from.lockModesByName);
        return dest;
    }
}

