/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.widgets.dataset.editor.workflow.edit;

import com.google.gwt.editor.client.SimpleBeanEditorDriver;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.dashbuilder.client.widgets.dataset.editor.csv.CSVDataSetEditor;
import org.dashbuilder.client.widgets.dataset.editor.driver.CSVDataSetDefDriver;
import org.dashbuilder.client.widgets.dataset.editor.workflow.AbstractDataSetWorkflowTest;
import org.dashbuilder.client.widgets.dataset.editor.workflow.DataSetEditorWorkflow;
import org.dashbuilder.client.widgets.dataset.editor.workflow.edit.CSVDataSetEditWorkflow;
import org.dashbuilder.client.widgets.dataset.event.CancelRequestEvent;
import org.dashbuilder.client.widgets.dataset.event.SaveRequestEvent;
import org.dashbuilder.client.widgets.dataset.event.TestDataSetRequestEvent;
import org.dashbuilder.dataprovider.DataSetProviderType;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.client.DataSetClientServices;
import org.dashbuilder.dataset.client.editor.CSVDataSetDefEditor;
import org.dashbuilder.dataset.client.editor.DataSetDefRefreshAttributesEditor;
import org.dashbuilder.dataset.def.CSVDataSetDef;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.validations.dataset.CSVDataSetDefValidator;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class CSVDataSetEditWorkflowTest
extends AbstractDataSetWorkflowTest {
    @Mock
    SyncBeanManager beanManager;
    @Mock
    EventSourceMock<SaveRequestEvent> saveRequestEvent;
    @Mock
    EventSourceMock<TestDataSetRequestEvent> testDataSetEvent;
    @Mock
    EventSourceMock<CancelRequestEvent> cancelRequestEvent;
    @Mock
    DataSetClientServices clientServices;
    @Mock
    DataSet dataSet;
    @Mock
    DataSetEditorWorkflow.View view;
    @Mock
    SimpleBeanEditorDriver<CSVDataSetDef, CSVDataSetDefEditor> driver;
    @Mock
    CSVDataSetEditor csvEditor;
    @Mock
    CSVDataSetDef dataSetDef;
    @Mock
    DataSetDefRefreshAttributesEditor refreshEditor;
    private CSVDataSetEditWorkflow presenter;

    @Override
    @Before
    public void setup() throws Exception {
        super.setup();
        this.presenter = new CSVDataSetEditWorkflow(this.clientServices, this.validatorProvider, this.beanManager, this.saveRequestEvent, this.testDataSetEvent, this.cancelRequestEvent, this.view);
        Mockito.when((Object)this.dataSetDef.getProvider()).thenReturn((Object)DataSetProviderType.CSV);
        Mockito.when((Object)this.csvEditor.refreshEditor()).thenReturn((Object)this.refreshEditor);
        Mockito.when((Object)this.refreshEditor.isRefreshEnabled()).thenReturn((Object)true);
    }

    @Test
    public void testGetDriverClass() {
        Assert.assertEquals(CSVDataSetDefDriver.class, (Object)this.presenter.getDriverClass());
    }

    @Test
    public void testGetEditorClass() {
        Assert.assertEquals(CSVDataSetEditor.class, (Object)this.presenter.getEditorClass());
    }

    @Test
    public void testValidateUsingFilePath() {
        this.presenter._setDataSetDef((DataSetDef)this.dataSetDef);
        this.presenter.driver = this.driver;
        this.presenter.editor = this.csvEditor;
        Mockito.when((Object)this.csvEditor.isUsingFilePath()).thenReturn((Object)true);
        this.presenter.validate(true, true, true);
        ((CSVDataSetDefValidator)Mockito.verify((Object)this.csvDataSetDefValidator, (VerificationMode)Mockito.times((int)1))).validate(this.dataSetDef, true, true, true, new Object[]{true});
        ((CSVDataSetDefValidator)Mockito.verify((Object)this.csvDataSetDefValidator, (VerificationMode)Mockito.times((int)0))).validateCustomAttributes(this.dataSetDef, new Object[]{true});
    }

    @Test
    public void testValidateUsingFileUrl() {
        this.presenter._setDataSetDef((DataSetDef)this.dataSetDef);
        this.presenter.driver = this.driver;
        this.presenter.editor = this.csvEditor;
        Mockito.when((Object)this.csvEditor.isUsingFilePath()).thenReturn((Object)false);
        this.presenter.validate(true, true, true);
        ((CSVDataSetDefValidator)Mockito.verify((Object)this.csvDataSetDefValidator, (VerificationMode)Mockito.times((int)1))).validate(this.dataSetDef, true, true, true, new Object[]{false});
        ((CSVDataSetDefValidator)Mockito.verify((Object)this.csvDataSetDefValidator, (VerificationMode)Mockito.times((int)0))).validateCustomAttributes(this.dataSetDef, new Object[]{false});
    }

    @Test
    public void testFlushDriverUsingFileUrl() throws Exception {
        this.presenter._setDataSetDef((DataSetDef)this.dataSetDef);
        this.presenter.driver = this.driver;
        this.presenter.editor = this.csvEditor;
        Mockito.when((Object)this.csvEditor.isUsingFilePath()).thenReturn((Object)false);
        this.presenter.afterFlush();
        ((CSVDataSetDef)Mockito.verify((Object)this.dataSetDef, (VerificationMode)Mockito.times((int)1))).setFilePath(null);
        ((CSVDataSetDef)Mockito.verify((Object)this.dataSetDef, (VerificationMode)Mockito.times((int)0))).setFileURL(null);
    }

    @Test
    public void testFlushUsingFilePath() throws Exception {
        this.presenter._setDataSetDef((DataSetDef)this.dataSetDef);
        this.presenter.driver = this.driver;
        this.presenter.editor = this.csvEditor;
        Mockito.when((Object)this.csvEditor.isUsingFilePath()).thenReturn((Object)true);
        this.presenter.afterFlush();
        ((CSVDataSetDef)Mockito.verify((Object)this.dataSetDef, (VerificationMode)Mockito.times((int)1))).setFileURL(null);
        ((CSVDataSetDef)Mockito.verify((Object)this.dataSetDef, (VerificationMode)Mockito.times((int)0))).setFilePath(null);
    }
}

