/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.widgets.dataset.editor.column;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.dashbuilder.client.widgets.dataset.editor.column.ColumnTypeEditor;
import org.dashbuilder.client.widgets.dataset.editor.column.DataColumnDefEditor;
import org.dashbuilder.common.client.editor.ValueBoxEditor;
import org.dashbuilder.dataprovider.DataSetProviderType;
import org.dashbuilder.dataset.ColumnType;
import org.gwtbootstrap3.client.ui.constants.Placement;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class DataColumnDefEditorTest {
    @Mock
    ValueBoxEditor<String> id;
    @Mock
    ColumnTypeEditor columnType;
    @Mock
    DataColumnDefEditor.View view;
    @Mock
    Widget idWidget;
    private DataColumnDefEditor presenter;

    @Before
    public void setup() {
        this.presenter = new DataColumnDefEditor(this.id, this.columnType, this.view);
        this.presenter.providerType = DataSetProviderType.SQL;
        Mockito.when((Object)this.id.asWidget()).thenReturn((Object)this.idWidget);
    }

    @Test
    public void testInit() {
        this.presenter.init();
        ((DataColumnDefEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).init((Object)this.presenter);
        ((DataColumnDefEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).initWidgets((ValueBoxEditor.View)Matchers.any(ValueBoxEditor.View.class), (IsWidget)Matchers.any(IsWidget.class));
        ((ColumnTypeEditor)Mockito.verify((Object)this.columnType, (VerificationMode)Mockito.times((int)0))).addHelpContent(Matchers.anyString(), Matchers.anyString(), (Placement)Matchers.any(Placement.class));
    }

    @Test
    public void testRemoveFromParent() {
        this.presenter.removeFromParent();
        ((DataColumnDefEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.presenter);
        ((DataColumnDefEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).initWidgets((ValueBoxEditor.View)Matchers.any(ValueBoxEditor.View.class), (IsWidget)Matchers.any(IsWidget.class));
        ((Widget)Mockito.verify((Object)this.idWidget, (VerificationMode)Mockito.times((int)1))).removeFromParent();
    }

    @Test
    public void testEnableEditMode() {
        this.presenter.isEditMode(true);
        ((DataColumnDefEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.presenter);
        ((DataColumnDefEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).initWidgets((ValueBoxEditor.View)Matchers.any(ValueBoxEditor.View.class), (IsWidget)Matchers.any(IsWidget.class));
        ((ColumnTypeEditor)Mockito.verify((Object)this.columnType, (VerificationMode)Mockito.times((int)1))).isEditMode(true);
    }

    @Test
    public void testEnableEditModeSpecificForBeanTypes() {
        this.presenter.providerType = DataSetProviderType.BEAN;
        this.presenter.isEditMode(true);
        ((DataColumnDefEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.presenter);
        ((DataColumnDefEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).initWidgets((ValueBoxEditor.View)Matchers.any(ValueBoxEditor.View.class), (IsWidget)Matchers.any(IsWidget.class));
        ((ColumnTypeEditor)Mockito.verify((Object)this.columnType, (VerificationMode)Mockito.times((int)1))).isEditMode(false);
    }

    @Test
    public void testDisableEditMode() {
        this.presenter.isEditMode(false);
        ((DataColumnDefEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.presenter);
        ((DataColumnDefEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).initWidgets((ValueBoxEditor.View)Matchers.any(ValueBoxEditor.View.class), (IsWidget)Matchers.any(IsWidget.class));
        ((ColumnTypeEditor)Mockito.verify((Object)this.columnType, (VerificationMode)Mockito.times((int)1))).isEditMode(false);
    }

    @Test
    public void testSetOriginalColumnType() {
        ColumnType type = (ColumnType)Mockito.mock(ColumnType.class);
        this.presenter.setOriginalColumnType(type);
        ((ColumnTypeEditor)Mockito.verify((Object)this.columnType, (VerificationMode)Mockito.times((int)1))).setOriginalColumnType(type);
        ((DataColumnDefEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.presenter);
        ((DataColumnDefEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).initWidgets((ValueBoxEditor.View)Matchers.any(ValueBoxEditor.View.class), (IsWidget)Matchers.any(IsWidget.class));
        ((ColumnTypeEditor)Mockito.verify((Object)this.columnType, (VerificationMode)Mockito.times((int)0))).isEditMode(Mockito.anyBoolean());
    }

    @Test
    public void testId() {
        Assert.assertEquals(this.id, (Object)this.presenter.id());
    }

    @Test
    public void testColumnType() {
        Assert.assertEquals((Object)this.columnType, (Object)this.presenter.columnType());
    }
}

