/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.widgets.dataset.editor.workflow.edit;

import com.google.gwt.editor.client.SimpleBeanEditorDriver;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.dashbuilder.client.widgets.dataset.editor.driver.SQLDataSetDefDriver;
import org.dashbuilder.client.widgets.dataset.editor.sql.SQLDataSetEditor;
import org.dashbuilder.client.widgets.dataset.editor.workflow.DataSetEditorWorkflow;
import org.dashbuilder.client.widgets.dataset.editor.workflow.edit.SQLDataSetEditWorkflow;
import org.dashbuilder.client.widgets.dataset.event.CancelRequestEvent;
import org.dashbuilder.client.widgets.dataset.event.SaveRequestEvent;
import org.dashbuilder.client.widgets.dataset.event.TestDataSetRequestEvent;
import org.dashbuilder.dataprovider.DataSetProviderType;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.client.DataSetClientServices;
import org.dashbuilder.dataset.client.editor.DataSetDefRefreshAttributesEditor;
import org.dashbuilder.dataset.client.editor.SQLDataSetDefEditor;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.def.SQLDataSetDef;
import org.dashbuilder.validations.dataset.DataSetDefValidator;
import org.dashbuilder.validations.dataset.SQLDataSetDefValidator;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class SQLDataSetEditWorkflowTest {
    @Mock
    SyncBeanManager beanManager;
    @Mock
    DataSetDefValidator dataSetDefValidator;
    @Mock
    EventSourceMock<SaveRequestEvent> saveRequestEvent;
    @Mock
    EventSourceMock<TestDataSetRequestEvent> testDataSetEvent;
    @Mock
    EventSourceMock<CancelRequestEvent> cancelRequestEvent;
    @Mock
    DataSetClientServices clientServices;
    @Mock
    DataSet dataSet;
    @Mock
    DataSetEditorWorkflow.View view;
    @Mock
    SimpleBeanEditorDriver<SQLDataSetDef, SQLDataSetDefEditor> driver;
    @Mock
    SQLDataSetEditor sqlEditor;
    @Mock
    SQLDataSetDefValidator sqlDataSetDefValidator;
    @Mock
    SQLDataSetDef dataSetDef;
    @Mock
    DataSetDefRefreshAttributesEditor refreshEditor;
    private SQLDataSetEditWorkflow presenter;

    @Before
    public void setup() throws Exception {
        this.presenter = new SQLDataSetEditWorkflow(this.clientServices, this.dataSetDefValidator, this.beanManager, this.saveRequestEvent, this.testDataSetEvent, this.cancelRequestEvent, this.view);
        Mockito.when((Object)this.dataSetDef.getProvider()).thenReturn((Object)DataSetProviderType.SQL);
        Mockito.when((Object)this.dataSetDefValidator.validatorFor((DataSetProviderType)Mockito.any(DataSetProviderType.class))).thenReturn((Object)this.sqlDataSetDefValidator);
        Mockito.when((Object)this.sqlEditor.refreshEditor()).thenReturn((Object)this.refreshEditor);
        Mockito.when((Object)this.refreshEditor.isRefreshEnabled()).thenReturn((Object)true);
    }

    @Test
    public void testGetDriverClass() {
        Assert.assertEquals(SQLDataSetDefDriver.class, (Object)this.presenter.getDriverClass());
    }

    @Test
    public void testGetEditorClass() {
        Assert.assertEquals(SQLDataSetEditor.class, (Object)this.presenter.getEditorClass());
    }

    @Test
    public void testValidateUsingQuery() {
        this.presenter._setDataSetDef((DataSetDef)this.dataSetDef);
        this.presenter.driver = this.driver;
        this.presenter.editor = this.sqlEditor;
        Mockito.when((Object)this.sqlEditor.isUsingQuery()).thenReturn((Object)true);
        this.presenter.validate(true, true, true);
        ((SQLDataSetDefValidator)Mockito.verify((Object)this.sqlDataSetDefValidator, (VerificationMode)Mockito.times((int)1))).validate(this.dataSetDef, true, true, true, new Object[]{true});
        ((SQLDataSetDefValidator)Mockito.verify((Object)this.sqlDataSetDefValidator, (VerificationMode)Mockito.times((int)0))).validateAttributes(this.dataSetDef, new Object[]{true});
    }

    @Test
    public void testValidateUsingTable() {
        this.presenter._setDataSetDef((DataSetDef)this.dataSetDef);
        this.presenter.driver = this.driver;
        this.presenter.editor = this.sqlEditor;
        Mockito.when((Object)this.sqlEditor.isUsingQuery()).thenReturn((Object)false);
        this.presenter.validate(true, true, true);
        ((SQLDataSetDefValidator)Mockito.verify((Object)this.sqlDataSetDefValidator, (VerificationMode)Mockito.times((int)1))).validate(this.dataSetDef, true, true, true, new Object[]{false});
        ((SQLDataSetDefValidator)Mockito.verify((Object)this.sqlDataSetDefValidator, (VerificationMode)Mockito.times((int)0))).validateAttributes(this.dataSetDef, new Object[]{false});
    }

    @Test
    public void testFlushDriverUsingQuery() throws Exception {
        this.presenter._setDataSetDef((DataSetDef)this.dataSetDef);
        this.presenter.driver = this.driver;
        this.presenter.editor = this.sqlEditor;
        Mockito.when((Object)this.sqlEditor.isUsingQuery()).thenReturn((Object)true);
        this.presenter.afterFlush();
        ((SQLDataSetDef)Mockito.verify((Object)this.dataSetDef, (VerificationMode)Mockito.times((int)1))).setDbTable(null);
        ((SQLDataSetDef)Mockito.verify((Object)this.dataSetDef, (VerificationMode)Mockito.times((int)0))).setDbSQL(null);
    }

    @Test
    public void testFlushDriverUsingTable() throws Exception {
        this.presenter._setDataSetDef((DataSetDef)this.dataSetDef);
        this.presenter.driver = this.driver;
        this.presenter.editor = this.sqlEditor;
        Mockito.when((Object)this.sqlEditor.isUsingQuery()).thenReturn((Object)false);
        this.presenter.afterFlush();
        ((SQLDataSetDef)Mockito.verify((Object)this.dataSetDef, (VerificationMode)Mockito.times((int)1))).setDbSQL(null);
        ((SQLDataSetDef)Mockito.verify((Object)this.dataSetDef, (VerificationMode)Mockito.times((int)0))).setDbTable(null);
    }
}

