/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.widgets.dataset.editor.sql;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.dashbuilder.client.widgets.dataset.editor.sql.SQLDataSetDefAttributesEditor;
import org.dashbuilder.common.client.editor.ValueBoxEditor;
import org.dashbuilder.dataprovider.DataSetProviderType;
import org.dashbuilder.dataset.def.SQLDataSetDef;
import org.gwtbootstrap3.client.ui.constants.Placement;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class SQLDataSetDefAttributesEditorTest {
    @Mock
    ValueBoxEditor<String> dataSource;
    @Mock
    ValueBoxEditor<String> dbSchema;
    @Mock
    ValueBoxEditor<String> dbTable;
    @Mock
    ValueBoxEditor<String> dbSQL;
    @Mock
    SQLDataSetDefAttributesEditor.View view;
    private SQLDataSetDefAttributesEditor presenter;

    @Before
    public void setup() {
        this.presenter = new SQLDataSetDefAttributesEditor(this.dataSource, this.dbSchema, this.dbTable, this.dbSQL, this.view);
    }

    @Test
    public void testInit() {
        this.presenter.init();
        ((SQLDataSetDefAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).init((Object)this.presenter);
        ((SQLDataSetDefAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).initWidgets((ValueBoxEditor.View)Matchers.any(ValueBoxEditor.View.class), (ValueBoxEditor.View)Matchers.any(ValueBoxEditor.View.class), (ValueBoxEditor.View)Matchers.any(ValueBoxEditor.View.class), (ValueBoxEditor.View)Matchers.any(ValueBoxEditor.View.class));
        ((ValueBoxEditor)Mockito.verify(this.dataSource, (VerificationMode)Mockito.times((int)1))).addHelpContent(Matchers.anyString(), Matchers.anyString(), (Placement)Matchers.any(Placement.class));
        ((ValueBoxEditor)Mockito.verify(this.dbSchema, (VerificationMode)Mockito.times((int)1))).addHelpContent(Matchers.anyString(), Matchers.anyString(), (Placement)Matchers.any(Placement.class));
        ((ValueBoxEditor)Mockito.verify(this.dbTable, (VerificationMode)Mockito.times((int)1))).addHelpContent(Matchers.anyString(), Matchers.anyString(), (Placement)Matchers.any(Placement.class));
        ((ValueBoxEditor)Mockito.verify(this.dbSQL, (VerificationMode)Mockito.times((int)1))).addHelpContent(Matchers.anyString(), Matchers.anyString(), (Placement)Matchers.any(Placement.class));
        ((SQLDataSetDefAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).query();
        ((SQLDataSetDefAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).table();
    }

    @Test
    public void testDataSource() {
        Assert.assertEquals(this.dataSource, (Object)this.presenter.dataSource());
    }

    @Test
    public void testDbSchema() {
        Assert.assertEquals(this.dbSchema, (Object)this.presenter.dbSchema());
    }

    @Test
    public void testDbTable() {
        Assert.assertEquals(this.dbTable, (Object)this.presenter.dbTable());
    }

    @Test
    public void testDbSQL() {
        Assert.assertEquals(this.dbSQL, (Object)this.presenter.dbSQL());
    }

    @Test
    public void testSetValueUsingTable() {
        SQLDataSetDef dataSetDef = (SQLDataSetDef)Mockito.mock(SQLDataSetDef.class);
        Mockito.when((Object)dataSetDef.getUUID()).thenReturn((Object)"uuid1");
        Mockito.when((Object)dataSetDef.getName()).thenReturn((Object)"name1");
        Mockito.when((Object)dataSetDef.getProvider()).thenReturn((Object)DataSetProviderType.SQL);
        Mockito.when((Object)dataSetDef.getDbTable()).thenReturn((Object)"table1");
        Mockito.when((Object)dataSetDef.getDbSQL()).thenReturn(null);
        this.presenter.setValue(dataSetDef);
        Assert.assertEquals((Object)false, (Object)this.presenter.isUsingQuery());
        ((SQLDataSetDefAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).table();
        ((SQLDataSetDefAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.presenter);
        ((SQLDataSetDefAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).initWidgets((ValueBoxEditor.View)Matchers.any(ValueBoxEditor.View.class), (ValueBoxEditor.View)Matchers.any(ValueBoxEditor.View.class), (ValueBoxEditor.View)Matchers.any(ValueBoxEditor.View.class), (ValueBoxEditor.View)Matchers.any(ValueBoxEditor.View.class));
        ((ValueBoxEditor)Mockito.verify(this.dataSource, (VerificationMode)Mockito.times((int)0))).addHelpContent(Matchers.anyString(), Matchers.anyString(), (Placement)Matchers.any(Placement.class));
        ((ValueBoxEditor)Mockito.verify(this.dbSchema, (VerificationMode)Mockito.times((int)0))).addHelpContent(Matchers.anyString(), Matchers.anyString(), (Placement)Matchers.any(Placement.class));
        ((ValueBoxEditor)Mockito.verify(this.dbTable, (VerificationMode)Mockito.times((int)0))).addHelpContent(Matchers.anyString(), Matchers.anyString(), (Placement)Matchers.any(Placement.class));
        ((ValueBoxEditor)Mockito.verify(this.dbSQL, (VerificationMode)Mockito.times((int)0))).addHelpContent(Matchers.anyString(), Matchers.anyString(), (Placement)Matchers.any(Placement.class));
        ((SQLDataSetDefAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).query();
    }

    @Test
    public void testSetValueUsingQuery() {
        SQLDataSetDef dataSetDef = (SQLDataSetDef)Mockito.mock(SQLDataSetDef.class);
        Mockito.when((Object)dataSetDef.getUUID()).thenReturn((Object)"uuid1");
        Mockito.when((Object)dataSetDef.getName()).thenReturn((Object)"name1");
        Mockito.when((Object)dataSetDef.getProvider()).thenReturn((Object)DataSetProviderType.SQL);
        Mockito.when((Object)dataSetDef.getDbTable()).thenReturn(null);
        Mockito.when((Object)dataSetDef.getDbSQL()).thenReturn((Object)"query1");
        this.presenter.setValue(dataSetDef);
        Assert.assertEquals((Object)true, (Object)this.presenter.isUsingQuery());
        ((SQLDataSetDefAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).query();
        ((SQLDataSetDefAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.presenter);
        ((SQLDataSetDefAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).initWidgets((ValueBoxEditor.View)Matchers.any(ValueBoxEditor.View.class), (ValueBoxEditor.View)Matchers.any(ValueBoxEditor.View.class), (ValueBoxEditor.View)Matchers.any(ValueBoxEditor.View.class), (ValueBoxEditor.View)Matchers.any(ValueBoxEditor.View.class));
        ((ValueBoxEditor)Mockito.verify(this.dataSource, (VerificationMode)Mockito.times((int)0))).addHelpContent(Matchers.anyString(), Matchers.anyString(), (Placement)Matchers.any(Placement.class));
        ((ValueBoxEditor)Mockito.verify(this.dbSchema, (VerificationMode)Mockito.times((int)0))).addHelpContent(Matchers.anyString(), Matchers.anyString(), (Placement)Matchers.any(Placement.class));
        ((ValueBoxEditor)Mockito.verify(this.dbTable, (VerificationMode)Mockito.times((int)0))).addHelpContent(Matchers.anyString(), Matchers.anyString(), (Placement)Matchers.any(Placement.class));
        ((ValueBoxEditor)Mockito.verify(this.dbSQL, (VerificationMode)Mockito.times((int)0))).addHelpContent(Matchers.anyString(), Matchers.anyString(), (Placement)Matchers.any(Placement.class));
        ((SQLDataSetDefAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).table();
    }
}

