/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.renderer.client.table;

import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.Range;
import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.gwtmockito.WithClassesToStub;
import org.dashbuilder.renderer.client.table.TableDisplayerView;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.widgets.common.client.tables.PagedTable;
import org.uberfire.ext.widgets.table.client.DataGrid;

@RunWith(value=GwtMockitoTestRunner.class)
@WithClassesToStub(value={DataGrid.class})
public class TableDisplayerViewTest {
    @Mock
    PagedTable<Integer> table;
    @InjectMocks
    TableDisplayerView tableDisplayerView;

    @Test
    public void testCreateTable() {
        HasWidgets hasWidgets = (HasWidgets)Mockito.mock(HasWidgets.class);
        Mockito.when((Object)this.table.getRightToolbar()).thenReturn((Object)hasWidgets);
        this.tableDisplayerView.setupToolbar();
        ((HasWidgets)Mockito.verify((Object)hasWidgets, (VerificationMode)Mockito.times((int)2))).add((Widget)ArgumentMatchers.any());
    }

    @Test
    public void testCreateTableUsingHorizontalPanel() {
        HorizontalPanel panel = (HorizontalPanel)Mockito.mock(HorizontalPanel.class);
        Mockito.when((Object)this.table.getRightToolbar()).thenReturn((Object)panel);
        this.tableDisplayerView.setupToolbar();
        ((HorizontalPanel)Mockito.verify((Object)panel)).insert((Widget)ArgumentMatchers.any(), Mockito.eq((int)0));
        ((HorizontalPanel)Mockito.verify((Object)panel)).insert((Widget)ArgumentMatchers.any(), Mockito.eq((int)1));
    }

    @Test
    public void testCurrentPageForNextPageWithoutTotalCount() {
        HasData display = (HasData)Mockito.mock(HasData.class);
        Mockito.when((Object)this.table.getRowCount()).thenReturn((Object)1);
        Mockito.when((Object)display.getVisibleRange()).thenReturn((Object)new Range(10, 10));
        Assert.assertEquals((long)1L, (long)this.tableDisplayerView.tableProvider.getCurrentPageRows(display).size());
    }

    @Test
    public void testCurrentPageForNextPageWithTotalCount() {
        HasData display = (HasData)Mockito.mock(HasData.class);
        Mockito.when((Object)this.table.getRowCount()).thenReturn((Object)11);
        Mockito.when((Object)display.getVisibleRange()).thenReturn((Object)new Range(10, 10));
        Assert.assertEquals((long)1L, (long)this.tableDisplayerView.tableProvider.getCurrentPageRows(display).size());
    }

    @Test
    public void testCurrentPageForNextPageWithoutRows() {
        HasData display = (HasData)Mockito.mock(HasData.class);
        Mockito.when((Object)this.table.getRowCount()).thenReturn((Object)0);
        Mockito.when((Object)display.getVisibleRange()).thenReturn((Object)new Range(10, 10));
        Assert.assertEquals((long)0L, (long)this.tableDisplayerView.tableProvider.getCurrentPageRows(display).size());
    }

    @Test
    public void testCurrentPage() {
        HasData display = (HasData)Mockito.mock(HasData.class);
        Mockito.when((Object)this.table.getRowCount()).thenReturn((Object)5);
        Mockito.when((Object)display.getVisibleRange()).thenReturn((Object)new Range(0, 10));
        Assert.assertEquals((long)5L, (long)this.tableDisplayerView.tableProvider.getCurrentPageRows(display).size());
    }
}

