/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.renderer.client.selector;

import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.dashbuilder.dataset.group.AggregateFunctionType;
import org.dashbuilder.dataset.group.DataSetGroup;
import org.dashbuilder.dataset.group.Interval;
import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.displayer.DisplayerSettingsFactory;
import org.dashbuilder.displayer.client.AbstractDisplayer;
import org.dashbuilder.displayer.client.AbstractDisplayerTest;
import org.dashbuilder.displayer.client.Displayer;
import org.dashbuilder.displayer.client.DisplayerListener;
import org.dashbuilder.displayer.impl.SelectorDisplayerSettingsBuilderImpl;
import org.dashbuilder.renderer.client.selector.SelectorDisplayer;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class SelectorDisplayerTest
extends AbstractDisplayerTest {
    public SelectorDisplayer createSelectorDisplayer(DisplayerSettings settings) {
        return (SelectorDisplayer)this.initDisplayer((AbstractDisplayer)new SelectorDisplayer((SelectorDisplayer.View)Mockito.mock(SelectorDisplayer.View.class)), settings);
    }

    @Test
    public void testDraw() {
        DisplayerSettings departmentList = ((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)DisplayerSettingsFactory.newSelectorSettings().dataset("expenses")).group("DEPARTMENT")).column("DEPARTMENT")).column("EXPENSES_ID", AggregateFunctionType.COUNT)).filterOn(false, true, false)).buildSettings();
        SelectorDisplayer presenter = this.createSelectorDisplayer(departmentList);
        SelectorDisplayer.View view = presenter.getView();
        presenter.draw();
        ((SelectorDisplayer.View)Mockito.verify((Object)view)).setFilterEnabled(true);
        ((SelectorDisplayer.View)Mockito.verify((Object)view)).clearItems();
        ((SelectorDisplayer.View)Mockito.verify((Object)view)).showSelectHint("DEPARTMENT");
        ((SelectorDisplayer.View)Mockito.verify((Object)view, (VerificationMode)Mockito.times((int)5))).addItem(Mockito.anyString(), Mockito.anyString(), Mockito.eq((boolean)false));
        ((SelectorDisplayer.View)Mockito.verify((Object)view, (VerificationMode)Mockito.never())).showResetHint(Mockito.anyString());
    }

    @Test
    public void testNoData() {
        DisplayerSettings departmentList = ((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)DisplayerSettingsFactory.newSelectorSettings().dataset("expenses")).filter("EXPENSES_ID", new ColumnFilter[]{FilterFactory.isNull()})).group("DEPARTMENT")).column("DEPARTMENT")).column("EXPENSES_ID", AggregateFunctionType.COUNT)).buildSettings();
        SelectorDisplayer presenter = this.createSelectorDisplayer(departmentList);
        SelectorDisplayer.View view = presenter.getView();
        presenter.draw();
        ((SelectorDisplayer.View)Mockito.verify((Object)view)).clearItems();
        ((SelectorDisplayer.View)Mockito.verify((Object)view)).showSelectHint("DEPARTMENT");
        ((SelectorDisplayer.View)Mockito.verify((Object)view, (VerificationMode)Mockito.never())).addItem(Mockito.anyString(), Mockito.anyString(), Mockito.anyBoolean());
    }

    @Test
    public void testNullNotShown() {
        DisplayerSettings departmentList = ((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)DisplayerSettingsFactory.newSelectorSettings().dataset("expenses")).group("DEPARTMENT")).column("DEPARTMENT")).column("EXPENSES_ID", AggregateFunctionType.COUNT)).buildSettings();
        DataSet expensesDataSet = this.clientDataSetManager.getDataSet("expenses");
        int column = expensesDataSet.getColumnIndex(expensesDataSet.getColumnById("DEPARTMENT"));
        expensesDataSet.setValueAt(0, column, null);
        SelectorDisplayer presenter = this.createSelectorDisplayer(departmentList);
        SelectorDisplayer.View view = presenter.getView();
        presenter.draw();
        ((SelectorDisplayer.View)Mockito.verify((Object)view, (VerificationMode)Mockito.never())).addItem(Mockito.anyString(), (String)Mockito.eq((Object)null), Mockito.anyBoolean());
        ((SelectorDisplayer.View)Mockito.verify((Object)view, (VerificationMode)Mockito.times((int)5))).addItem(Mockito.anyString(), Mockito.anyString(), Mockito.eq((boolean)false));
    }

    @Test
    public void testSelectDisabled() {
        DisplayerSettings departmentList = ((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)DisplayerSettingsFactory.newSelectorSettings().dataset("expenses")).group("DEPARTMENT")).column("DEPARTMENT")).column("EXPENSES_ID", AggregateFunctionType.COUNT)).filterOff(true)).buildSettings();
        SelectorDisplayer presenter = this.createSelectorDisplayer(departmentList);
        DisplayerListener listener = (DisplayerListener)Mockito.mock(DisplayerListener.class);
        SelectorDisplayer.View view = presenter.getView();
        presenter.draw();
        Mockito.reset((Object[])new SelectorDisplayer.View[]{view});
        Mockito.when((Object)view.getSelectedId()).thenReturn((Object)"1");
        presenter.addListener(new DisplayerListener[]{listener});
        presenter.onItemSelected();
        ((DisplayerListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.never())).onFilterEnabled((Displayer)Mockito.eq((Object)presenter), (DataSetGroup)Mockito.any(DataSetGroup.class));
        ((DisplayerListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.never())).onRedraw((Displayer)presenter);
        ((SelectorDisplayer.View)Mockito.verify((Object)view)).showResetHint("DEPARTMENT");
        ((SelectorDisplayer.View)Mockito.verify((Object)view, (VerificationMode)Mockito.never())).clearItems();
        ((SelectorDisplayer.View)Mockito.verify((Object)view, (VerificationMode)Mockito.never())).showSelectHint("DEPARTMENT");
        ((SelectorDisplayer.View)Mockito.verify((Object)view, (VerificationMode)Mockito.never())).addItem(Mockito.anyString(), Mockito.anyString(), Mockito.anyBoolean());
    }

    @Test
    public void testSelectItem() {
        DisplayerSettings departmentList = ((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)DisplayerSettingsFactory.newSelectorSettings().dataset("expenses")).group("DEPARTMENT")).column("DEPARTMENT")).column("EXPENSES_ID", AggregateFunctionType.COUNT)).filterOn(false, true, true)).buildSettings();
        SelectorDisplayer presenter = this.createSelectorDisplayer(departmentList);
        SelectorDisplayer.View view = presenter.getView();
        DisplayerListener listener = (DisplayerListener)Mockito.mock(DisplayerListener.class);
        presenter.draw();
        Mockito.reset((Object[])new SelectorDisplayer.View[]{view});
        Mockito.when((Object)view.getSelectedId()).thenReturn((Object)"1");
        presenter.addListener(new DisplayerListener[]{listener});
        presenter.onItemSelected();
        ((SelectorDisplayer.View)Mockito.verify((Object)view, (VerificationMode)Mockito.never())).clearItems();
        ((SelectorDisplayer.View)Mockito.verify((Object)view, (VerificationMode)Mockito.never())).addItem(Mockito.anyString(), Mockito.anyString(), Mockito.anyBoolean());
        ArgumentCaptor argument = ArgumentCaptor.forClass(DataSetGroup.class);
        ((SelectorDisplayer.View)Mockito.verify((Object)view)).showResetHint("DEPARTMENT");
        ((SelectorDisplayer.View)Mockito.verify((Object)view, (VerificationMode)Mockito.never())).showSelectHint("DEPARTMENT");
        ((DisplayerListener)Mockito.verify((Object)listener)).onFilterEnabled((Displayer)Mockito.eq((Object)presenter), (DataSetGroup)argument.capture());
        ((DisplayerListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.never())).onRedraw((Displayer)presenter);
        DataSetGroup dataSetGroup = (DataSetGroup)argument.getValue();
        Interval selectedInterval = (Interval)dataSetGroup.getSelectedIntervalList().get(0);
        Assert.assertEquals((Object)selectedInterval.getName(), (Object)"Services");
    }

    @Test
    public void testDrillDown() {
        DisplayerSettings departmentList = ((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)DisplayerSettingsFactory.newSelectorSettings().dataset("expenses")).group("DEPARTMENT")).column("DEPARTMENT")).column("EXPENSES_ID", AggregateFunctionType.COUNT)).filterOn(true, true, true)).buildSettings();
        SelectorDisplayer presenter = this.createSelectorDisplayer(departmentList);
        SelectorDisplayer.View view = presenter.getView();
        DisplayerListener listener = (DisplayerListener)Mockito.mock(DisplayerListener.class);
        presenter.draw();
        Mockito.reset((Object[])new SelectorDisplayer.View[]{view});
        Mockito.when((Object)view.getSelectedId()).thenReturn((Object)"1");
        presenter.addListener(new DisplayerListener[]{listener});
        presenter.onItemSelected();
        ((DisplayerListener)Mockito.verify((Object)listener)).onFilterEnabled((Displayer)Mockito.eq((Object)presenter), (DataSetGroup)Mockito.any(DataSetGroup.class));
        ((DisplayerListener)Mockito.verify((Object)listener)).onRedraw((Displayer)presenter);
        ((SelectorDisplayer.View)Mockito.verify((Object)view)).clearItems();
        ((SelectorDisplayer.View)Mockito.verify((Object)view, (VerificationMode)Mockito.atLeastOnce())).showResetHint("DEPARTMENT");
        ((SelectorDisplayer.View)Mockito.verify((Object)view, (VerificationMode)Mockito.never())).showSelectHint("DEPARTMENT");
        ((SelectorDisplayer.View)Mockito.verify((Object)view, (VerificationMode)Mockito.times((int)1))).addItem(Mockito.anyString(), Mockito.anyString(), Mockito.eq((boolean)false));
    }

    @Test
    public void testNullEntries() {
        DataSet expensesDataSet = this.clientDataSetManager.getDataSet("expenses");
        int column = expensesDataSet.getColumnIndex(expensesDataSet.getColumnById("DEPARTMENT"));
        expensesDataSet.setValueAt(0, column, null);
        DisplayerSettings departmentList = ((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)DisplayerSettingsFactory.newSelectorSettings().dataset("expenses")).group("DEPARTMENT")).column("DEPARTMENT")).column("EXPENSES_ID", AggregateFunctionType.COUNT)).filterOn(false, true, true)).buildSettings();
        SelectorDisplayer presenter = this.createSelectorDisplayer(departmentList);
        SelectorDisplayer.View view = presenter.getView();
        DisplayerListener listener = (DisplayerListener)Mockito.mock(DisplayerListener.class);
        presenter.addListener(new DisplayerListener[]{listener});
        presenter.draw();
        ((SelectorDisplayer.View)Mockito.verify((Object)view, (VerificationMode)Mockito.times((int)5))).addItem(Mockito.anyString(), Mockito.anyString(), Mockito.eq((boolean)false));
        ((SelectorDisplayer.View)Mockito.verify((Object)view, (VerificationMode)Mockito.never())).addItem(Mockito.anyString(), (String)Mockito.eq((Object)null), Mockito.anyBoolean());
        Mockito.reset((Object[])new DisplayerListener[]{listener});
        Mockito.when((Object)view.getSelectedId()).thenReturn((Object)"1");
        presenter.onItemSelected();
        ArgumentCaptor argument = ArgumentCaptor.forClass(DataSetGroup.class);
        ((DisplayerListener)Mockito.verify((Object)listener)).onFilterEnabled((Displayer)Mockito.eq((Object)presenter), (DataSetGroup)argument.capture());
        DataSetGroup dataSetGroup = (DataSetGroup)argument.getValue();
        Interval selectedInterval = (Interval)dataSetGroup.getSelectedIntervalList().get(0);
        Assert.assertEquals((Object)selectedInterval.getName(), (Object)"Engineering");
    }
}

