/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.renderer.client.external;

import java.text.ParseException;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.ExpenseReportsData;
import org.dashbuilder.displayer.ColumnSettings;
import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.displayer.client.AbstractDisplayer;
import org.dashbuilder.displayer.client.AbstractDisplayerTest;
import org.dashbuilder.renderer.client.external.ExternalComponentDisplayer;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class ExternalComponentDisplayerTest
extends AbstractDisplayerTest {
    @Test
    public void testBuildData() throws ParseException {
        DataSet dataSet = ExpenseReportsData.INSTANCE.toDataSet();
        DisplayerSettings settings = (DisplayerSettings)Mockito.mock(DisplayerSettings.class);
        ColumnSettings clSettings = (ColumnSettings)Mockito.mock(ColumnSettings.class);
        ExternalComponentDisplayer displayer = new ExternalComponentDisplayer();
        Mockito.when((Object)settings.getColumnSettings(ArgumentMatchers.anyString())).thenReturn((Object)clSettings);
        displayer.setDisplayerSettings(settings);
        displayer.setEvaluator(new AbstractDisplayer.ExpressionEval(){

            public String evalExpression(String value, String expression) {
                return value;
            }
        });
        String[][] buildData = displayer.buildData(dataSet);
        for (int i = 0; i < buildData.length; ++i) {
            for (int j = 0; j < buildData[i].length; ++j) {
                Assert.assertEquals((Object)buildData[i][j], (Object)dataSet.getValueAt(i, j).toString());
            }
        }
    }
}

