/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.renderer.client.table;

import org.dashbuilder.common.client.error.ClientRuntimeError;
import org.dashbuilder.common.client.widgets.FilterLabel;
import org.dashbuilder.common.client.widgets.FilterLabelSet;
import org.dashbuilder.dataprovider.DataSetProviderType;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.dashbuilder.dataset.group.AggregateFunctionType;
import org.dashbuilder.dataset.sort.SortOrder;
import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.displayer.DisplayerSettingsFactory;
import org.dashbuilder.displayer.client.AbstractDisplayer;
import org.dashbuilder.displayer.client.AbstractDisplayerTest;
import org.dashbuilder.displayer.client.Displayer;
import org.dashbuilder.displayer.client.DisplayerListener;
import org.dashbuilder.displayer.client.formatter.ValueFormatter;
import org.dashbuilder.displayer.impl.TableDisplayerSettingsBuilderImpl;
import org.dashbuilder.renderer.client.table.TableDisplayer;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.mvp.Command;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class TableDisplayerTest
extends AbstractDisplayerTest {
    @Mock
    DisplayerListener displayerListener;
    @Mock
    Command selectCommand;
    @Mock
    FilterLabel filterLabel;

    public TableDisplayer createTableDisplayer(DisplayerSettings settings) {
        return (TableDisplayer)this.initDisplayer((AbstractDisplayer)new TableDisplayer((TableDisplayer.View)Mockito.mock(TableDisplayer.View.class), (FilterLabelSet)Mockito.mock(FilterLabelSet.class)), settings);
    }

    public void resetFilterLabelSet(FilterLabelSet filterLabelSet) {
        Mockito.reset((Object[])new FilterLabelSet[]{filterLabelSet});
        ((FilterLabelSet)Mockito.doAnswer(invocationOnMock -> this.filterLabel).when((Object)filterLabelSet)).addLabel(Mockito.anyString());
    }

    @Test
    public void testTableDraw() {
        DisplayerSettings allRows = ((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)DisplayerSettingsFactory.newTableSettings().dataset("expenses")).tableOrderDefault("DEPARTMENT", SortOrder.DESCENDING).tableOrderEnabled(true).tablePageSize(10).tableWidth(1000).filterOn(true, true, true)).allowCsvExport(true)).allowExcelExport(false)).buildSettings();
        TableDisplayer table = this.createTableDisplayer(allRows);
        TableDisplayer.View tableView = table.getView();
        FilterLabelSet filterLabelSet = table.getFilterLabelSet();
        table.draw();
        ((TableDisplayer.View)Mockito.verify((Object)tableView)).setWidth(1000);
        ((TableDisplayer.View)Mockito.verify((Object)tableView)).setSortEnabled(true);
        ((TableDisplayer.View)Mockito.verify((Object)tableView, (VerificationMode)Mockito.times((int)2))).setTotalRows(50, true);
        ((TableDisplayer.View)Mockito.verify((Object)tableView)).createTable(10, filterLabelSet);
        ((TableDisplayer.View)Mockito.verify((Object)tableView)).addColumn(ColumnType.NUMBER, "EXPENSES_ID", "EXPENSES_ID", 0, false, true);
        ((TableDisplayer.View)Mockito.verify((Object)tableView)).addColumn(ColumnType.LABEL, "CITY", "CITY", 1, true, true);
        ((TableDisplayer.View)Mockito.verify((Object)tableView)).addColumn(ColumnType.LABEL, "DEPARTMENT", "DEPARTMENT", 2, true, true);
        ((TableDisplayer.View)Mockito.verify((Object)tableView)).addColumn(ColumnType.LABEL, "EMPLOYEE", "EMPLOYEE", 3, true, true);
        ((TableDisplayer.View)Mockito.verify((Object)tableView)).addColumn(ColumnType.DATE, "CREATION_DATE", "CREATION_DATE", 4, false, true);
        ((TableDisplayer.View)Mockito.verify((Object)tableView)).addColumn(ColumnType.NUMBER, "AMOUNT", "AMOUNT", 5, false, true);
        ((TableDisplayer.View)Mockito.verify((Object)tableView)).setExportToCsvEnabled(true);
        ((TableDisplayer.View)Mockito.verify((Object)tableView)).setExportToXlsEnabled(false);
        ((TableDisplayer.View)Mockito.verify((Object)tableView)).gotoFirstPage();
    }

    @Test
    public void testEmptyTableDraw() {
        DisplayerSettings allRows = ((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)DisplayerSettingsFactory.newTableSettings().dataset("expenses")).filter("EXPENSES_ID", new ColumnFilter[]{FilterFactory.isNull()})).tablePageSize(10).buildSettings();
        TableDisplayer table = this.createTableDisplayer(allRows);
        TableDisplayer.View tableView = table.getView();
        FilterLabelSet filterLabelSet = table.getFilterLabelSet();
        table.draw();
        ((TableDisplayer.View)Mockito.verify((Object)tableView)).createTable(10, filterLabelSet);
        ((TableDisplayer.View)Mockito.verify((Object)tableView, (VerificationMode)Mockito.times((int)2))).setTotalRows(0, true);
        ((TableDisplayer.View)Mockito.verify((Object)tableView)).setPagerEnabled(false);
        ((TableDisplayer.View)Mockito.verify((Object)tableView, (VerificationMode)Mockito.never())).setPagerEnabled(true);
        Mockito.reset((Object[])new TableDisplayer.View[]{tableView});
        table.redraw();
        ((TableDisplayer.View)Mockito.verify((Object)tableView, (VerificationMode)Mockito.never())).setPagerEnabled(true);
    }

    @Test
    public void testTableSort() {
        DisplayerSettings allRows = ((TableDisplayerSettingsBuilderImpl)DisplayerSettingsFactory.newTableSettings().dataset("expenses")).tablePageSize(10).tableOrderDefault("EXPENSES_ID", SortOrder.DESCENDING).buildSettings();
        TableDisplayer table = this.createTableDisplayer(allRows);
        TableDisplayer.View tableView = table.getView();
        table.draw();
        Assert.assertEquals((Object)table.getDataSetHandler().getLastDataSet().getValueAt(0, 0), (Object)50.0);
        allRows.setTableSortEnabled(false);
        table = this.createTableDisplayer(allRows);
        tableView = table.getView();
        table.draw();
        Mockito.reset((Object[])new TableDisplayer.View[]{tableView});
        table.sortBy("EXPENSES_ID", SortOrder.DESCENDING);
        ((TableDisplayer.View)Mockito.verify((Object)tableView, (VerificationMode)Mockito.never())).redrawTable();
        Assert.assertEquals((Object)table.getDataSetHandler().getLastDataSet().getValueAt(0, 0), (Object)50.0);
        allRows.setTableSortEnabled(true);
        table = this.createTableDisplayer(allRows);
        tableView = table.getView();
        table.draw();
        Mockito.reset((Object[])new TableDisplayer.View[]{tableView});
        table.sortBy("EXPENSES_ID", SortOrder.ASCENDING);
        ((TableDisplayer.View)Mockito.verify((Object)tableView)).redrawTable();
        Assert.assertEquals((Object)table.getDataSetHandler().getLastDataSet().getValueAt(0, 0), (Object)1.0);
    }

    @Test
    public void testSelectCellDisabled() {
        DisplayerSettings allRows = ((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)DisplayerSettingsFactory.newTableSettings().dataset("expenses")).tablePageSize(10).tableOrderDefault("EXPENSES_ID", SortOrder.DESCENDING).filterOff(false)).buildSettings();
        TableDisplayer table = this.createTableDisplayer(allRows);
        TableDisplayer.View view = table.getView();
        FilterLabelSet filterLabelSet = table.getFilterLabelSet();
        table.addListener(new DisplayerListener[]{this.displayerListener});
        table.addOnCellSelectedCommand(this.selectCommand);
        table.draw();
        Mockito.reset((Object[])new TableDisplayer.View[]{view});
        Mockito.reset((Object[])new DisplayerListener[]{this.displayerListener});
        this.resetFilterLabelSet(filterLabelSet);
        table.selectCell("DEPARTMENT", 3);
        ((Command)Mockito.verify((Object)this.selectCommand, (VerificationMode)Mockito.never())).execute();
        ((TableDisplayer.View)Mockito.verify((Object)view, (VerificationMode)Mockito.never())).gotoFirstPage();
        ((FilterLabelSet)Mockito.verify((Object)filterLabelSet, (VerificationMode)Mockito.never())).addLabel(Mockito.anyString());
        ((DisplayerListener)Mockito.verify((Object)this.displayerListener, (VerificationMode)Mockito.never())).onRedraw((Displayer)table);
        Assert.assertNull((Object)table.getSelectedCellColumn());
        Assert.assertNull((Object)table.getSelectedCellRow());
    }

    @Test
    public void testSelectCellNoDrillDown() {
        DisplayerSettings allRows = ((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)DisplayerSettingsFactory.newTableSettings().dataset("expenses")).tablePageSize(10).tableOrderDefault("EXPENSES_ID", SortOrder.DESCENDING).filterOn(false, true, true)).buildSettings();
        TableDisplayer table = this.createTableDisplayer(allRows);
        TableDisplayer.View view = table.getView();
        FilterLabelSet filterLabelSet = table.getFilterLabelSet();
        table.addListener(new DisplayerListener[]{this.displayerListener});
        table.addOnCellSelectedCommand(this.selectCommand);
        table.draw();
        Mockito.reset((Object[])new TableDisplayer.View[]{view});
        Mockito.reset((Object[])new DisplayerListener[]{this.displayerListener});
        this.resetFilterLabelSet(filterLabelSet);
        table.selectCell("DEPARTMENT", 3);
        ((Command)Mockito.verify((Object)this.selectCommand)).execute();
        ((TableDisplayer.View)Mockito.verify((Object)view, (VerificationMode)Mockito.never())).gotoFirstPage();
        ((FilterLabelSet)Mockito.verify((Object)filterLabelSet)).addLabel(Mockito.anyString());
        ((DisplayerListener)Mockito.verify((Object)this.displayerListener, (VerificationMode)Mockito.never())).onRedraw((Displayer)table);
        Assert.assertEquals((Object)table.getSelectedCellColumn(), (Object)"DEPARTMENT");
        Assert.assertEquals((Object)table.getSelectedCellRow(), (Object)new Integer(3));
    }

    @Test
    public void testSelectCellDrillDown() {
        DisplayerSettings allRows = ((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)DisplayerSettingsFactory.newTableSettings().dataset("expenses")).tablePageSize(10).tableOrderDefault("EXPENSES_ID", SortOrder.DESCENDING).filterOn(true, true, true)).buildSettings();
        TableDisplayer table = this.createTableDisplayer(allRows);
        TableDisplayer.View view = table.getView();
        FilterLabelSet filterLabelSet = table.getFilterLabelSet();
        table.addListener(new DisplayerListener[]{this.displayerListener});
        table.addOnCellSelectedCommand(this.selectCommand);
        table.draw();
        Mockito.reset((Object[])new TableDisplayer.View[]{view});
        Mockito.reset((Object[])new DisplayerListener[]{this.displayerListener});
        this.resetFilterLabelSet(filterLabelSet);
        table.selectCell("DEPARTMENT", 3);
        ((TableDisplayer.View)Mockito.verify((Object)view, (VerificationMode)Mockito.atLeastOnce())).gotoFirstPage();
        ((TableDisplayer.View)Mockito.verify((Object)view)).redrawTable();
        ((FilterLabelSet)Mockito.verify((Object)filterLabelSet, (VerificationMode)Mockito.atLeastOnce())).addLabel(Mockito.anyString());
        ((TableDisplayer.View)Mockito.verify((Object)view, (VerificationMode)Mockito.times((int)2))).setTotalRows(11, true);
        ((DisplayerListener)Mockito.verify((Object)this.displayerListener)).onRedraw((Displayer)table);
        ((Command)Mockito.verify((Object)this.selectCommand)).execute();
        Assert.assertEquals((Object)table.getSelectedCellColumn(), (Object)"DEPARTMENT");
        Assert.assertEquals((Object)table.getSelectedCellRow(), (Object)new Integer(3));
    }

    @Test
    public void testSelectCellReset() {
        DisplayerSettings allRows = ((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)DisplayerSettingsFactory.newTableSettings().dataset("expenses")).tablePageSize(10).tableOrderDefault("EXPENSES_ID", SortOrder.DESCENDING).filterOn(false, true, true)).buildSettings();
        TableDisplayer table = this.createTableDisplayer(allRows);
        TableDisplayer.View view = table.getView();
        FilterLabelSet filterLabelSet = table.getFilterLabelSet();
        table.addListener(new DisplayerListener[]{this.displayerListener});
        table.addOnCellSelectedCommand(this.selectCommand);
        table.draw();
        this.resetFilterLabelSet(filterLabelSet);
        table.selectCell("DEPARTMENT", 3);
        Mockito.reset((Object[])new TableDisplayer.View[]{view});
        Mockito.reset((Object[])new Command[]{this.selectCommand});
        Mockito.reset((Object[])new DisplayerListener[]{this.displayerListener});
        this.resetFilterLabelSet(filterLabelSet);
        table.selectCell("DEPARTMENT", 3);
        ((Command)Mockito.verify((Object)this.selectCommand)).execute();
        ((TableDisplayer.View)Mockito.verify((Object)view, (VerificationMode)Mockito.never())).gotoFirstPage();
        ((FilterLabelSet)Mockito.verify((Object)filterLabelSet, (VerificationMode)Mockito.never())).addLabel(Mockito.anyString());
        ((DisplayerListener)Mockito.verify((Object)this.displayerListener, (VerificationMode)Mockito.never())).onRedraw((Displayer)table);
        Assert.assertNull((Object)table.getSelectedCellColumn());
        Assert.assertNull((Object)table.getSelectedCellRow());
    }

    @Test
    public void testSelectCellCommands() {
        DisplayerSettings allRows = ((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)DisplayerSettingsFactory.newTableSettings().dataset("expenses")).tablePageSize(10).tableOrderDefault("EXPENSES_ID", SortOrder.DESCENDING).filterOn(false, true, true)).buildSettings();
        TableDisplayer table = this.createTableDisplayer(allRows);
        TableDisplayer.View view = table.getView();
        FilterLabelSet filterLabelSet = table.getFilterLabelSet();
        table.addListener(new DisplayerListener[]{this.displayerListener});
        table.addOnCellSelectedCommand(this.selectCommand);
        Command selectedCommand = (Command)Mockito.mock(Command.class);
        table.addOnCellSelectedCommand(selectedCommand);
        table.draw();
        this.resetFilterLabelSet(filterLabelSet);
        table.selectCell("DEPARTMENT", 3);
        ((Command)Mockito.verify((Object)this.selectCommand)).execute();
        ((Command)Mockito.verify((Object)selectedCommand)).execute();
    }

    @Test
    public void testFormatEmpty() {
        TableDisplayer table = this.createTableDisplayer(((TableDisplayerSettingsBuilderImpl)DisplayerSettingsFactory.newTableSettings().dataset("expenses")).buildSettings());
        table.addFormatter("EMPLOYEE", new ValueFormatter(){

            public String formatValue(DataSet dataSet, int row, int column) {
                return "test";
            }

            public String formatValue(Object value) {
                return "test";
            }
        });
        table.draw();
        String value = table.formatValue(100, 3);
        Assert.assertEquals((Object)value, (Object)"test");
    }

    @Test
    public void test_DASHBUILDE_20_Fix() {
        DisplayerSettings groupedTable = ((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)DisplayerSettingsFactory.newTableSettings().dataset("expenses")).group("CITY")).column("CITY", "City")).column(AggregateFunctionType.COUNT, "#Expenses")).format("Number of expenses", "#,##0")).column("AMOUNT", AggregateFunctionType.MIN)).format("Min", "$ #,###")).column("AMOUNT", AggregateFunctionType.MIN)).format("Min", "$ #,###")).column("AMOUNT", AggregateFunctionType.MIN)).format("Min", "$ #,###")).column("AMOUNT", AggregateFunctionType.MIN)).format("Min", "$ #,###")).tablePageSize(10).tableOrderEnabled(true).tableOrderDefault("CITY", SortOrder.DESCENDING).filterOn(false, true, true)).buildSettings();
        TableDisplayer table = this.createTableDisplayer(groupedTable);
        table.addListener(new DisplayerListener[]{this.displayerListener});
        table.draw();
        table.sortBy("#Expenses", SortOrder.ASCENDING);
        ((DisplayerListener)Mockito.verify((Object)this.displayerListener, (VerificationMode)Mockito.never())).onError((Displayer)Mockito.eq((Object)table), (ClientRuntimeError)Mockito.any(ClientRuntimeError.class));
    }

    @Test
    public void testIsTotalRowsExactSQL() {
        DataSet dataSet = (DataSet)Mockito.mock(DataSet.class);
        DataSetDef dataSetDef = new DataSetDef();
        dataSetDef.setProvider((DataSetProviderType)DataSetProviderType.SQL);
        Mockito.when((Object)dataSet.getDefinition()).thenReturn((Object)dataSetDef);
        TableDisplayer table = this.createTableDisplayer(((TableDisplayerSettingsBuilderImpl)DisplayerSettingsFactory.newTableSettings().tablePageSize(10)).buildSettings());
        Assert.assertTrue((boolean)table.isTotalRowsExact(dataSet, 5));
        Assert.assertTrue((boolean)table.isTotalRowsExact(dataSet, 10));
        Assert.assertTrue((boolean)table.isTotalRowsExact(dataSet, 15));
    }

    @Test
    public void testIsTotalRowsExactRemote() {
        DataSet dataSet = (DataSet)Mockito.mock(DataSet.class);
        DataSetDef dataSetDef = new DataSetDef();
        dataSetDef.setProvider(() -> "REMOTE");
        Mockito.when((Object)dataSet.getDefinition()).thenReturn((Object)dataSetDef);
        TableDisplayer table = this.createTableDisplayer(((TableDisplayerSettingsBuilderImpl)DisplayerSettingsFactory.newTableSettings().tablePageSize(10)).buildSettings());
        Assert.assertTrue((boolean)table.isTotalRowsExact(dataSet, 5));
        Assert.assertFalse((boolean)table.isTotalRowsExact(dataSet, 10));
        Assert.assertFalse((boolean)table.isTotalRowsExact(dataSet, 15));
    }

    @Test
    public void testIsPagerEnabledRemote() {
        DataSet dataSet = (DataSet)Mockito.mock(DataSet.class);
        DataSetDef dataSetDef = new DataSetDef();
        dataSetDef.setProvider(() -> "REMOTE");
        Mockito.when((Object)dataSet.getDefinition()).thenReturn((Object)dataSetDef);
        TableDisplayer table = this.createTableDisplayer(((TableDisplayerSettingsBuilderImpl)DisplayerSettingsFactory.newTableSettings().tablePageSize(10)).buildSettings());
        Assert.assertFalse((boolean)table.isPagerEnabled(dataSet, 5));
        Assert.assertTrue((boolean)table.isPagerEnabled(dataSet, 10));
        ((DataSet)Mockito.verify((Object)dataSet, (VerificationMode)Mockito.never())).getRowCountNonTrimmed();
    }

    @Test
    public void testIsPagerEnabledSQL() {
        DataSet dataSet = (DataSet)Mockito.mock(DataSet.class);
        DataSetDef dataSetDef = new DataSetDef();
        dataSetDef.setProvider((DataSetProviderType)DataSetProviderType.SQL);
        Mockito.when((Object)dataSet.getDefinition()).thenReturn((Object)dataSetDef);
        Mockito.when((Object)dataSet.getRowCountNonTrimmed()).thenReturn((Object)5, (Object[])new Integer[]{10, 15});
        TableDisplayer table = this.createTableDisplayer(((TableDisplayerSettingsBuilderImpl)DisplayerSettingsFactory.newTableSettings().tablePageSize(10)).buildSettings());
        Assert.assertFalse((boolean)table.isPagerEnabled(dataSet, 5));
        Assert.assertFalse((boolean)table.isPagerEnabled(dataSet, 10));
        Assert.assertTrue((boolean)table.isPagerEnabled(dataSet, 15));
    }

    @Test
    public void testIsRemoteProvider() {
        DataSet dataSet = (DataSet)Mockito.mock(DataSet.class);
        DataSetDef dataSetDefSQL = new DataSetDef();
        dataSetDefSQL.setProvider((DataSetProviderType)DataSetProviderType.SQL);
        DataSetDef dataSetDefRemote = new DataSetDef();
        dataSetDefRemote.setProvider(() -> "REMOTE");
        Mockito.when((Object)dataSet.getDefinition()).thenReturn((Object)new DataSetDef(), (Object[])new DataSetDef[]{dataSetDefSQL, dataSetDefRemote});
        TableDisplayer table = this.createTableDisplayer(null);
        Assert.assertFalse((boolean)table.isRemoteProvider(dataSet));
        Assert.assertFalse((boolean)table.isRemoteProvider(dataSet));
        Assert.assertTrue((boolean)table.isRemoteProvider(dataSet));
    }

    @Test
    public void testPageSize() {
        TableDisplayer table = this.createTableDisplayer(((TableDisplayerSettingsBuilderImpl)DisplayerSettingsFactory.newTableSettings().tablePageSize(10)).buildSettings());
        Assert.assertEquals((long)10L, (long)table.getPageSize());
        Mockito.when((Object)table.getView().getPageSize()).thenReturn((Object)20);
        Assert.assertEquals((long)20L, (long)table.getPageSize());
    }
}

