/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.renderer.client.selector;

import java.lang.annotation.Annotation;
import java.util.Date;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.group.AggregateFunctionType;
import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.displayer.DisplayerSettingsFactory;
import org.dashbuilder.displayer.DisplayerSubType;
import org.dashbuilder.displayer.client.AbstractDisplayer;
import org.dashbuilder.displayer.client.AbstractDisplayerTest;
import org.dashbuilder.displayer.client.Displayer;
import org.dashbuilder.displayer.client.DisplayerCoordinator;
import org.dashbuilder.displayer.client.DisplayerListener;
import org.dashbuilder.displayer.client.widgets.filter.DateParameterEditor;
import org.dashbuilder.displayer.client.widgets.filter.NumberParameterEditor;
import org.dashbuilder.displayer.impl.SelectorDisplayerSettingsBuilderImpl;
import org.dashbuilder.displayer.impl.TableDisplayerSettingsBuilderImpl;
import org.dashbuilder.renderer.client.selector.SelectorDropDownDisplayer;
import org.dashbuilder.renderer.client.selector.SelectorDropDownDisplayerView;
import org.dashbuilder.renderer.client.selector.SelectorDropDownItem;
import org.dashbuilder.renderer.client.selector.SelectorLabelItem;
import org.dashbuilder.renderer.client.selector.SelectorLabelSetDisplayer;
import org.dashbuilder.renderer.client.selector.SelectorSliderDisplayer;
import org.jboss.errai.ioc.client.container.SyncBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class SelectorCoordinatorTest
extends AbstractDisplayerTest {
    DisplayerSettings yearLabels = ((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)DisplayerSettingsFactory.newSelectorSettings().dataset("expenses")).group("CREATION_DATE")).column("CREATION_DATE")).column("AMOUNT", AggregateFunctionType.SUM)).filterOn(false, true, false)).subtype(DisplayerSubType.SELECTOR_LABELS)).buildSettings();
    DisplayerSettings dateSlider = ((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)DisplayerSettingsFactory.newSelectorSettings().dataset("expenses")).column("CREATION_DATE")).filterOn(false, true, true)).subtype(DisplayerSubType.SELECTOR_SLIDER)).buildSettings();
    DisplayerSettings numberSlider = ((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)DisplayerSettingsFactory.newSelectorSettings().dataset("expenses")).column("AMOUNT")).filterOn(false, true, false)).subtype(DisplayerSubType.SELECTOR_SLIDER)).buildSettings();
    DisplayerSettings dropDownDept = ((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)DisplayerSettingsFactory.newSelectorSettings().dataset("expenses")).group("DEPARTMENT")).column("DEPARTMENT")).filterOn(false, true, true)).subtype(DisplayerSubType.SELECTOR_DROPDOWN)).multiple(true)).buildSettings();
    DisplayerSettings dropDownCity = ((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)DisplayerSettingsFactory.newSelectorSettings().dataset("expenses")).group("CITY")).column("CITY")).filterOn(false, true, true)).subtype(DisplayerSubType.SELECTOR_DROPDOWN)).multiple(true)).buildSettings();
    DisplayerSettings allRows = ((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)DisplayerSettingsFactory.newTableSettings().dataset("expenses")).column("DEPARTMENT")).column("CITY")).column("EMPLOYEE")).column("AMOUNT")).column("CREATION_DATE")).filterOn(true, false, true)).buildSettings();
    DisplayerCoordinator displayerCoordinator;
    AbstractDisplayer allRowsDisplayer;
    SelectorLabelSetDisplayer yearLabelDisplayer;
    SelectorSliderDisplayer dateSliderDisplayer;
    SelectorSliderDisplayer numberSliderDisplayer;
    SelectorDropDownDisplayer deptDropDownDisplayer;
    SelectorDropDownDisplayer cityDropDownDisplayer;
    @Mock
    SelectorLabelSetDisplayer.View labelSetView;
    @Mock
    SelectorSliderDisplayer.View sliderView;
    @Mock
    SyncBeanManager beanManager;
    @Mock
    DateParameterEditor dateEditor;
    @Mock
    NumberParameterEditor numberEditor;
    @Mock
    DisplayerListener listener;
    @Mock
    SelectorLabelItem labelItem;
    @Mock
    SyncBeanDef<SelectorLabelItem> labelItemBean;
    @Mock
    SyncBeanDef<SelectorDropDownItem> dropDownItemBean;
    @Mock
    SelectorDropDownItem dropDownItem;

    public SelectorLabelSetDisplayer createLabelSetDisplayer(DisplayerSettings settings) {
        return (SelectorLabelSetDisplayer)this.initDisplayer((AbstractDisplayer)new SelectorLabelSetDisplayer(this.labelSetView, this.beanManager), settings);
    }

    public SelectorSliderDisplayer createSliderDisplayer(DisplayerSettings settings) {
        return (SelectorSliderDisplayer)this.initDisplayer((AbstractDisplayer)new SelectorSliderDisplayer(this.sliderView, this.dateEditor, this.dateEditor, this.numberEditor, this.numberEditor), settings);
    }

    public SelectorDropDownDisplayer createDropDownDisplayer(DisplayerSettings settings) {
        return (SelectorDropDownDisplayer)this.initDisplayer((AbstractDisplayer)new SelectorDropDownDisplayer((SelectorDropDownDisplayer.View)Mockito.mock(SelectorDropDownDisplayerView.class), this.beanManager), settings);
    }

    @Before
    public void init() throws Exception {
        super.init();
        Mockito.when((Object)this.beanManager.lookupBean(SelectorLabelItem.class, new Annotation[0])).thenReturn(this.labelItemBean);
        Mockito.when((Object)((SelectorLabelItem)this.labelItemBean.newInstance())).thenReturn((Object)this.labelItem);
        Mockito.when((Object)this.beanManager.lookupBean(SelectorDropDownItem.class, new Annotation[0])).thenReturn(this.dropDownItemBean);
        Mockito.when((Object)((SelectorDropDownItem)this.dropDownItemBean.newInstance())).thenReturn((Object)this.dropDownItem);
        this.allRowsDisplayer = this.createNewDisplayer(this.allRows);
        this.dateSliderDisplayer = this.createSliderDisplayer(this.dateSlider);
        this.numberSliderDisplayer = this.createSliderDisplayer(this.numberSlider);
        this.yearLabelDisplayer = this.createLabelSetDisplayer(this.yearLabels);
        this.cityDropDownDisplayer = this.createDropDownDisplayer(this.dropDownCity);
        this.deptDropDownDisplayer = this.createDropDownDisplayer(this.dropDownDept);
        this.displayerCoordinator = new DisplayerCoordinator(this.rendererManager);
        this.displayerCoordinator.addDisplayers(new Displayer[]{this.allRowsDisplayer, this.dateSliderDisplayer, this.numberSliderDisplayer, this.yearLabelDisplayer, this.cityDropDownDisplayer, this.deptDropDownDisplayer});
        this.displayerCoordinator.addListener(new DisplayerListener[]{this.listener});
    }

    @Test
    public void testDrawAll() {
        this.displayerCoordinator.drawAll();
        ((DisplayerListener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.times((int)6))).onDraw((Displayer)Mockito.any(Displayer.class));
    }

    @Test
    public void testFilterPropagations() {
        this.displayerCoordinator.drawAll();
        Mockito.reset((Object[])new DisplayerListener[]{this.listener});
        Mockito.when((Object)this.labelItem.getId()).thenReturn((Object)0);
        this.yearLabelDisplayer.onItemSelected(this.labelItem);
        DataSet dataSet = this.allRowsDisplayer.getDataSetHandler().getLastDataSet();
        Assert.assertEquals((long)dataSet.getRowCount(), (long)13L);
        ((DisplayerListener)Mockito.verify((Object)this.listener)).onDataLookup((Displayer)this.allRowsDisplayer);
        ((DisplayerListener)Mockito.verify((Object)this.listener)).onRedraw((Displayer)this.allRowsDisplayer);
    }

    @Test
    public void testTwoDateFilters() {
        this.displayerCoordinator.drawAll();
        Mockito.when((Object)this.labelItem.getId()).thenReturn((Object)0);
        this.yearLabelDisplayer.onItemSelected(this.labelItem);
        Mockito.reset((Object[])new DisplayerListener[]{this.listener});
        Mockito.when((Object)this.labelItem.getId()).thenReturn((Object)0);
        Date min = new Date(112, 0, 1);
        Date max = new Date(112, 11, 31);
        this.dateSliderDisplayer.onSliderChange((double)min.getTime(), (double)max.getTime());
        DataSet dataSet = this.allRowsDisplayer.getDataSetHandler().getLastDataSet();
        Assert.assertEquals((long)dataSet.getRowCount(), (long)13L);
        ((DisplayerListener)Mockito.verify((Object)this.listener)).onDataLookup((Displayer)this.allRowsDisplayer);
        ((DisplayerListener)Mockito.verify((Object)this.listener)).onRedraw((Displayer)this.allRowsDisplayer);
    }

    @Test
    public void testSliderDateKeepsSelection() {
        this.displayerCoordinator.drawAll();
        Date min = (Date)this.dateSliderDisplayer.getSelectedMin();
        Date max = (Date)this.dateSliderDisplayer.getSelectedMax();
        Mockito.when((Object)this.labelItem.getId()).thenReturn((Object)0);
        this.yearLabelDisplayer.onItemSelected(this.labelItem);
        Date min2012 = (Date)this.dateSliderDisplayer.getSelectedMin();
        Date max2012 = (Date)this.dateSliderDisplayer.getSelectedMax();
        ((SelectorSliderDisplayer.View)Mockito.verify((Object)this.sliderView)).showSlider((double)min2012.getTime(), (double)max2012.getTime(), 1.0, (double)min2012.getTime(), (double)max2012.getTime());
        Date newMin = new Date(112, 3, 3);
        this.dateSliderDisplayer.onSliderChange((double)newMin.getTime(), (double)max.getTime());
        Assert.assertEquals((Object)this.dateSliderDisplayer.getSelectedMin(), (Object)newMin);
        Assert.assertEquals((Object)this.dateSliderDisplayer.getSelectedMax(), (Object)max);
        Mockito.reset((Object[])new SelectorSliderDisplayer.View[]{this.sliderView});
        this.yearLabelDisplayer.filterReset();
        Assert.assertEquals((Object)this.dateSliderDisplayer.getSelectedMin(), (Object)newMin);
        Assert.assertEquals((Object)this.dateSliderDisplayer.getSelectedMax(), (Object)max);
        ((SelectorSliderDisplayer.View)Mockito.verify((Object)this.sliderView)).showSlider((double)min.getTime(), (double)max.getTime(), 1.0, (double)newMin.getTime(), (double)max.getTime());
    }

    @Test
    public void testMinMaxNumberSliderEquals() {
        this.displayerCoordinator.drawAll();
        this.numberSliderDisplayer.onSliderChange(11.0, 100.0);
        DataSet dataSet = this.allRowsDisplayer.getDataSetHandler().getLastDataSet();
        Assert.assertEquals((long)dataSet.getRowCount(), (long)3L);
        Mockito.reset((Object[])new DisplayerListener[]{this.listener});
        this.numberSliderDisplayer.onSliderChange(100.0, 100.0);
        dataSet = this.allRowsDisplayer.getDataSetHandler().getLastDataSet();
        Assert.assertEquals((long)dataSet.getRowCount(), (long)1L);
        ((DisplayerListener)Mockito.verify((Object)this.listener)).onDataLookup((Displayer)this.allRowsDisplayer);
        ((DisplayerListener)Mockito.verify((Object)this.listener)).onRedraw((Displayer)this.allRowsDisplayer);
    }

    @Test
    public void testSelectedDropDownItems() {
        this.displayerCoordinator.drawAll();
        Mockito.when((Object)this.dropDownItem.getId()).thenReturn((Object)0);
        this.cityDropDownDisplayer.onItemSelected(this.dropDownItem);
        Mockito.reset((Object[])new SelectorDropDownItem[]{this.dropDownItem});
        this.deptDropDownDisplayer.onItemSelected(this.dropDownItem);
        ((SelectorDropDownItem)Mockito.verify((Object)this.dropDownItem)).select();
    }
}

