/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.renderer.client.selector;

import com.google.gwt.dom.client.Style;
import com.google.gwt.dom.client.StyleInjector;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import org.dashbuilder.displayer.client.AbstractGwtDisplayer;
import org.dashbuilder.displayer.client.AbstractGwtDisplayerView;
import org.dashbuilder.renderer.client.resources.i18n.SelectorConstants;
import org.dashbuilder.renderer.client.resources.i18n.SliderConstants;
import org.dashbuilder.renderer.client.selector.SelectorSliderDisplayer;
import org.gwtbootstrap3.client.ui.Label;
import org.gwtbootstrap3.extras.slider.client.ui.Range;
import org.gwtbootstrap3.extras.slider.client.ui.RangeSlider;
import org.gwtbootstrap3.extras.slider.client.ui.base.constants.HandleType;
import org.gwtbootstrap3.extras.slider.client.ui.base.constants.TooltipType;

public class SelectorSliderDisplayerView
extends AbstractGwtDisplayerView<SelectorSliderDisplayer>
implements SelectorSliderDisplayer.View {
    FlowPanel container = new FlowPanel();
    HTML header = new HTML();
    FlowPanel body = new FlowPanel();
    RangeSlider slider = new RangeSlider();
    HorizontalPanel inputs = new HorizontalPanel();
    FlowPanel error = new FlowPanel();

    public void init(SelectorSliderDisplayer presenter) {
        super.setPresenter((AbstractGwtDisplayer)presenter);
        super.setVisualization((IsWidget)this.container);
        StyleInjector.inject((String)".slider .tooltip-inner { max-width: 900px; }");
        this.header.setVisible(false);
        this.slider.setHandle(HandleType.ROUND);
        this.slider.setFormatter(r -> presenter.formatRange(r.getMinValue(), r.getMaxValue()));
        this.slider.addSlideStopHandler(e -> presenter.onSliderChange(((Range)e.getValue()).getMinValue(), ((Range)e.getValue()).getMaxValue()));
        this.slider.getElement().getStyle().setWidth(100.0, Style.Unit.PCT);
        this.inputs.getElement().getStyle().setWidth(100.0, Style.Unit.PCT);
        this.body.add((Widget)this.slider);
        this.body.getElement().getStyle().setMarginLeft(10.0, Style.Unit.PX);
        this.container.add((Widget)this.header);
        this.container.add((Widget)this.body);
        this.container.add((Widget)this.inputs);
        this.container.add((Widget)this.error);
    }

    @Override
    public String getColumnsTitle() {
        return SliderConstants.INSTANCE.sliderColumnName();
    }

    @Override
    public void showTitle(String title) {
        this.error.setVisible(false);
        this.header.setVisible(true);
        this.header.setText(title);
    }

    @Override
    public void setWidth(int width) {
        this.slider.getElement().getStyle().setWidth((double)width, Style.Unit.PX);
        this.inputs.getElement().getStyle().setWidth((double)width, Style.Unit.PX);
    }

    @Override
    public void margins(int top, int bottom, int left, int right) {
        this.container.getElement().getStyle().setMarginTop((double)top, Style.Unit.PX);
        this.container.getElement().getStyle().setMarginBottom((double)bottom, Style.Unit.PX);
        this.container.getElement().getStyle().setMarginLeft((double)left, Style.Unit.PX);
        this.container.getElement().getStyle().setMarginRight((double)right, Style.Unit.PX);
    }

    @Override
    public void setSliderEnabled(boolean enabled) {
        this.slider.setEnabled(enabled);
        this.slider.setTooltip(enabled ? TooltipType.SHOW : TooltipType.HIDE);
    }

    @Override
    public void showSlider(double min, double max, double step, double minSelected, double maxSelected) {
        this.slider.setMin(min);
        this.slider.setMax(max);
        this.slider.setValue((Object)new Range(minSelected, maxSelected));
        this.slider.setStep(step);
        this.header.setVisible(true);
        this.body.setVisible(true);
        this.error.setVisible(false);
    }

    @Override
    public void showInputs(IsWidget minValueEditor, IsWidget maxValueEditor) {
        minValueEditor.asWidget().getElement().getStyle().setMarginTop(5.0, Style.Unit.PX);
        maxValueEditor.asWidget().getElement().getStyle().setMarginTop(5.0, Style.Unit.PX);
        minValueEditor.asWidget().getElement().getStyle().setMarginBottom(5.0, Style.Unit.PX);
        maxValueEditor.asWidget().getElement().getStyle().setMarginBottom(5.0, Style.Unit.PX);
        maxValueEditor.asWidget().getElement().getStyle().setFloat(Style.Float.RIGHT);
        this.inputs.clear();
        this.inputs.add(minValueEditor);
        this.inputs.add(maxValueEditor);
        this.header.setVisible(true);
        this.inputs.setVisible(true);
        this.error.setVisible(false);
    }

    @Override
    public String formatRange(String from, String to) {
        return SliderConstants.INSTANCE.sliderTooltip(from, to);
    }

    @Override
    public void textColumnsNotSupported() {
        this.header.setVisible(false);
        this.error(SliderConstants.INSTANCE.textColumnsNotSupported());
    }

    @Override
    public void noData() {
        this.error(SelectorConstants.INSTANCE.selectorDisplayer_noDataAvailable());
    }

    protected void error(String msg) {
        this.body.setVisible(false);
        this.inputs.setVisible(false);
        this.error.setVisible(true);
        this.error.clear();
        this.error.add((Widget)new Label(msg));
    }
}

